function recalculate(recmode)
	{
   var TotalHours;
   var NewSec;
   var fps;
   var HRsOn

   if ( recmode == 1 )
      {
      TotalHours = $('TotalHours').innerHTML;
      NewSec = $('NewSec').value;
      var NewFrames = 3600*TotalHours/NewSec;
	   fps = Number($('FrameRate').value);

      $('ClipMin').value = Math.floor(NewFrames/(60*fps));
      $('ClipSec').value = (NewFrames/fps)%60;
      }
	var ClipSecs = Number($('ClipMin').value)*60 + Number($('ClipSec').value);
   $('ClipSecs').innerHTML = ClipSecs;

	fps          = Number($('FrameRate').value);
   $('fps').innerHTML = fps;

	var frames      = fps * ClipSecs;
	$('frames').innerHTML = frames;
	
	var NDays       = Number($('NumberDays').value);
	var NHrsPerDay  = Number($('NumberHours').value);
	TotalHours  = NDays * NHrsPerDay;
	$('TotalHours').innerHTML = TotalHours;
	
	var CaptureRate = TotalHours*60/frames;
	$('CaptureRate').innerHTML = Number(CaptureRate).toFixed(1);

   var CycleTime = 60*CaptureRate;
	$('CycleTime').innerHTML = Number(CycleTime).toFixed(1);
   $('NewSec').value = Number(CycleTime).toFixed(1);

   if ( CycleTime > 30 )
      {
      $('30sec').style.display = 'none';
      }
   else
      {
      $('30sec').style.display = 'block';
      }

   var ShotsPerDay = frames/NDays;
   $('ShotsPerDay').innerHTML = ShotsPerDay;

   var SDCard = Number($('SDCard').value);
   var ImageMB = Number($('ImageMB').value);
   $('SDdays').innerHTML = Math.floor(0.85*(1024*SDCard/ImageMB)/ShotsPerDay);
	
	var SelectCamera = $('SelectCamera').value;
   var PWRon = 2.0;
   var PWRstandby = 0.002
	switch(SelectCamera)
		{
		case 'HD':
		  PWRon = 1.2;
        PWRstandby = 0.001;
		  break;
		case 'H2':
		  PWRon = 1.2;
        PWRstandby = 0.001;
		  break;
		case 'H3W':
		  PWRon = 1.2;
        PWRstandby = 0.001;
		  break;
		case 'H3S':
		  PWRon = 1.2;
        PWRstandby = 0.001;
		  break;
		case 'H3+S':
		  PWRon = 1.1;
        PWRstandby = 0.001;
		  break;
		case 'H3B':
		  PWRon = 2.1;
        PWRstandby = 0.002;
		  break;
		case 'H3+B':
		  PWRon = 1.9;
        PWRstandby = 0.002;
		  break;
		default:
		  PWRon = 2.0;
        PWRstandby = 0.002;
		}
   $('PWRon').innerHTML = PWRon;
   $('PWRstandby').innerHTML = PWRstandby;

   if ( $('CamDoI').checked || $('CamDoPS').checked )
      {
      HRsOn = ShotsPerDay*10/3600;
      }
   else 
      {
      HRsOn = NHrsPerDay;
      }

   if ( CycleTime < 30 ) HRsOn = NHrsPerDay;


   if ( $('CamDoPS').checked || HRsOn >= 24)
      {
      $('24hrs').style.display = 'none';
      }
   else
      {
      $('24hrs').style.display = 'block';
      }

   var HRsOff = 24-HRsOn;
   $('HRsOn').innerHTML = Number(HRsOn).toFixed(2);
   $('HRsOff').innerHTML = Number(HRsOff).toFixed(2);
   var Pon = HRsOn*PWRon;
   var Poff = HRsOff*PWRstandby;
   $('Pon').innerHTML = Number(Pon).toFixed(2);
   $('Poff').innerHTML = Number(Poff+0.1).toFixed(2);
   $('DayPWR').innerHTML = Number(Pon+Poff).toFixed(2);

   var GPBatt  = Number($('GPBatt' ).value);
   var AuxBatt = Number($('AuxBatt').value);
   var BattDays = (GPBatt+AuxBatt)/(Pon+Poff);
   $('BattDays').innerHTML = Number(BattDays).toFixed(1);

   var Panel = $('Panel').value;
   var Factor = 0;
	switch(Panel)
		{
		case '6':
		  Factor = 7;
		  break;
     case '16.8':
        Factor = 19;
        break;
      }
   var Sol = Number($('Sol' ).value);
   SunW = Factor*Sol;
   $('SunW').innerHTML = Math.floor(SunW);

   var SunCharge = (GPBatt+AuxBatt)/SunW;
   $('SunCharge').innerHTML = Number(SunCharge).toFixed(1);
   $('Clouds').innerHTML = Math.floor(BattDays);
	}
