// by Mohamed magdy

var GPA = {
	Subject: function (grade, hours) {
		this.grade = +grade || 0.00;
		this.hours = +hours || 0.00;
	},

	Gpa: function (subjects) {
		this.subjects = subjects || [];
	}
}

Object.defineProperty(GPA.Subject.prototype, 'grades', {
	get: function () { return this.isValid() ? this.hours * this.grade : false; }
});

GPA.Subject.prototype.isValid = function() {
	return this.grade > 4.00 || this.grade < 0.00 ? false : true;
};

// gpa object

Object.defineProperty(GPA.Gpa.prototype, 'hours', {
	get: function () { return this._calculateSum('hours'); }
});

Object.defineProperty(GPA.Gpa.prototype, 'grades', {
	get: function () { return this._calculateSum('grades'); }
});

GPA.Gpa.prototype.addSubjects = function (subjects) {
	this.subjects.pushArray(subjects);
};

GPA.Gpa.prototype.addSubject = function (subject) {
	this.subjects.push(subject);
};

GPA.Gpa.prototype.removeSubject = function (subject) {
	this.subjects.remove(subject);
};

GPA.Gpa.prototype.calculateGpa = function () {
	return this.grades / this.hours;
};

GPA.Gpa.prototype.calculateCgpa = function (cgpa) {
	return (this.grades + cgpa.grades) / (this.hours + cgpa.hours);
};


/* private */

GPA.Gpa.prototype._calculateSum = function (method) {
	if (this.subjects.length === 0) return false
	var items = this.subjects.map(function (subject) { return subject[method] });
	return items.reduce(function (mem, i) { return mem + i });
};

