var myApp = angular.module('myApp', ['ngAnimate']);

// Controller

myApp.controller('GpaApp', ['$scope', function($scope){

	// for fields to save orignal object
	$scope.fieldsNumber  	 = 3;
	$scope.fieldsNumberArr = new Array($scope.fieldsNumber);
	$scope.changeNumberArr = function () {
		$scope.fieldsNumberArr = new Array($scope.fieldsNumber);
	};
	$scope.gpaFinal = undefined;
	$scope.cgpaFinal = undefined;

	// for subject and calculation
	$scope.subjects = new Array();
	$scope.calculate = function () {
		$scope.gpaFinal = undefined;
		$scope.cgpaFinal = undefined;

		$scope.subjects.length = $scope.fieldsNumber;
		var subjects = $scope.subjects.map(function (obj) {
			return (obj.hours && obj.grade) ? new GPA.Subject(obj.grade, obj.hours) :
																			  undefined;
		}).compact();

		if (subjects.length > 0) {
			var gpaObject = new GPA.Gpa(subjects),
					cgpaSubject;

			$scope.cgpa && $scope.cgpaHours &&
			(cgpaSubject = new GPA.Subject($scope.cgpa, $scope.cgpaHours));

			$scope.gpaFinal = gpaObject.calculateGpa().toFixed(4);
			cgpaSubject && ($scope.cgpaFinal = gpaObject.calculateCgpa(cgpaSubject).toFixed(4));
		}
	};

}]);

// Directives

myApp.directive('grade', function() {
  return {
    restrict: 'E',
    templateUrl: 'grade.html'
  };
});

myApp.directive('hours', function() {
  return {
    restrict: 'E',
    templateUrl: 'hours.html'
  };
});
