var main = (function () {

	var plot = null;

	function drawPlot() {
	
		var cosPoints = [];
		var start = new Number($('#fstart').val());
		var end = new Number($('#fend').val());
		var step = new Number($('#fstep').val());
		var func = $("#fbody").val();
		try {
		/*
			if (func.indexOf("sqrt") != -1 && start < 0) {
				start = 0;
				$('#fstart').val(start);
			}
			if (func.indexOf("ln") != -1 && start < 0) {
				start = 0.1;
				$('#fstart').val(start);
			}*/
			var countLeft = func.split("(").length - 1;
			var countRight = func.split(")").length - 1;
			while (countLeft > countRight) {
				func += ')';
				countLeft = func.split("(").length - 1;
				countRight = func.split(")").length - 1;
				$("#fbody").val (func);
			}
			while (countLeft < countRight) {
				func = '(' + func;
				countLeft = func.split("(").length - 1;
				countRight = func.split(")").length - 1;
				$("#fbody").val (func);
			}
			
			
			for (var i=start; i<end; i+=step){
				var calculated = func.replace(/cos/g, 'Math.cos');
				calculated = calculated.replace(/sin/g, 'Math.sin');
				calculated = calculated.replace(/tan/g, 'Math.tan');
				calculated = calculated.replace(/exp/g, 'Math.exp');
				calculated = calculated.replace(/sqrt/g, 'Math.sqrt');
				calculated = calculated.replace(/ln/g, 'Math.log');
				calculated = calculated.replace(/X/g, i);
				
				var result = eval(calculated);
				if (!isNaN(result)) {
					cosPoints.push([i, result]);
				}
				
			}
			
			if (plot != null) {
				plot.destroy();
			}
			plot = $.jqplot('chartdiv', [cosPoints], { 
				series:[{
					showMarker:false,
					lineWidth:5
				}],
				axes:{
					xaxis:{
						label:'X',
						labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
						labelOptions: {
							fontFamily: 'Georgia, Serif',
							fontSize: '12pt',
							textColor: '#000000'
						}
					},
					yaxis:{
						label:'Y',
						labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
						labelOptions: {
							fontFamily: 'Georgia, Serif',
							fontSize: '12pt',
							textColor: '#000000'
						}
					}
				},
				grid: {
					drawGridLines: true,        // wether to draw lines across the grid or not.
					gridLineColor: '#000000',   // *Color of the grid lines.
					background: '#fffdf6',      // CSS color spec for background color of grid.
					borderColor: '#000000',     // CSS color spec for border around grid.
					borderWidth: 2.0            // pixel width of border around grid.
				}
			});
		} catch (err) {
			$("#fbody").val (err);
		}
	}
	
	return {
		draw: drawPlot
	};

})();

var calc = (function () {

	var func = '';
	
	function clearFunc() {
		func = '';
		$("#fbody").val ('0');
	}

	return {
		add: function (character) {
			func += character;
			$("#fbody").val (func);
		},
		clear: clearFunc, 
		backspace: function () {
			if (func.length > 1) {
				var temp = func.substring(0, func.length - 1);
				func = temp;
				$("#fbody").val (func);
			} else {
				clearFunc();
			}
		}
	};
}) ();