var Manager = {

    viewManager: new Ro.ViewsManager(),

    goToLogin: function () {

        var hasBaseUrl = window.localStorage.hostConf;
        var hasLocale  = window.localStorage.locales;
        var locales    = null;
        var resources  = null;

        var formBox  = document.querySelector("div.screen[screenname=login] div.formBox");
        var loader   = document.querySelector("div.login_loader");
        var login    = document.getElementById("userLogin");
        var password = document.getElementById("userPassword");
        var localeSc = document.getElementById("locale_list");
        var credentials = {
            login: '',
            password: ''
        };

        var credentialsStorage = window.localStorage.getItem('credentials');

        if (credentialsStorage) {
            credentials = JSON.parse(credentialsStorage);
        }

        if (localeSc) {
            document.body.removeChild(localeSc);
        }

        window.AndroidBackButtonInterface = finishApp;

        if (hasBaseUrl) {

            window.hostConf = hasBaseUrl;

            Ro.Store.set('host_conf', {
                id: 1,
                host_address: hasBaseUrl
            });

            if (hasLocale) {

                locales   = JSON.parse(hasLocale);
                resources = JSON.parse(window.localStorage.resources);

                Ro.Store.set('locale', locales);

                Monet.I18n.locale    = locales;
                Monet.I18n.resources = resources;

                Manager.viewManager.toggleView("login", loginView);

                if(formBox) {
                    formBox.style.display = "block";
                }

                if (loader) {
                    loader.style.display  = "none";
                }

                if (login) {
                    login.value = credentials.login;
                }

                if (password) {
                    password.value = credentials.password;
                }

                if(isOldAndroid) {
                    setTimeout(function () {
                        var section = document.querySelector("#login .scroll");
                        section.style.minHeight = window.innerHeight - 130 + "px";
                    }, 200);

                }

            } else {

                Manager.goToLocaleList();

            }

        } else {

            Manager.goToHostConf();
        }

    },

    goToHostConf: function () {

        var currentList = document.querySelector("div[screenname='host_conf']");

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        Manager.viewManager.toggleView("host_conf", hostConfView);

        var hasBaseUrl = Ro.Store.selectById('host_conf', 1);
        var leftBtn    = document.querySelector("div.screen[screenname=host_conf] header .leftItem");

        if (hasBaseUrl === false) {
            leftBtn.style.display = 'none';
        } else {
            leftBtn.style.display = 'block';
        }

        if(isOldAndroid) {
            var section = document.querySelector("#host_conf .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }

    },

    goToLocaleList: function () {

        Manager.viewManager.toggleView("locale_list", localeListView);

        if(isOldAndroid) {
            var section = document.querySelector("#locale_list .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }

    },

    goToRouteList: function () {

        var currentList = document.querySelector("div[screenname='route_list']");
        var btnClose    = document.querySelector('.closeUrgentNotificationPanel');
        var mapDisplay  = document.getElementById('mapDetailStop');

        mapDisplay.style.display = "none";
        btnClose.style.display   = "none";

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        window.firstResult = 0;

        Manager.viewManager.toggleView("route_list", routeListView);

        if(isOldAndroid) {
            var section = document.querySelector("#route_list .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }

    },

    goToStopList: function (route) {

        window.AndroidBackButtonInterface = Manager.goToRouteList;

        var btnClose    = document.querySelector('.closeUrgentNotificationPanel');
        var mapDisplay  = document.getElementById('mapDetailStop');

        mapDisplay.style.display = "none";
        btnClose.style.display   = "none";

        var currentList = document.querySelector("div[screenname='stops_list']");

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        var routeListClosure = (function(route){
            return function () {
                stopsListView(route);
            }
        }(route));

        Manager.viewManager.toggleView("stops_list", routeListClosure);

        if(isOldAndroid) {
            var section = document.querySelector("#stops_list .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }

    },

    backToStopList: function (route) {

        window.AndroidBackButtonInterface = Manager.goToRouteList;

        var routeListClosure = (function(route){
            return function () {
                stopsListView(route);
            }
        }(route));

        Manager.viewManager.toggleView("stops_list", routeListClosure);
    },

    goToRouteMap: function (route) {

        var currentList = document.querySelector("div[screenname='route_map']");

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        var routeMapClosure = (function(route){
            return function () {
                routeMap(route);
            }
        }(route));

        Manager.viewManager.toggleView("route_map", routeMapClosure);

        if(isOldAndroid) {
            var section = document.querySelector("#route_map .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }
		
    },

    goToStopDetail: function (routeId, stop) {

        var currentList = document.querySelector("div[screenname='stop_detail']");
        var loader = new Ro.UIComponents.Loader();
        var route = new Models.Route();

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        var stopDetailsClosure = (function(routeId, stop){
            return function () {
                stopDetail (routeId, stop);
            }
        }(routeId, stop));

        loader.show();

        route.filter({
            routeId: routeId,
            success: (function (stopDetailsClosure){
                return function () {

                    loader.hide();

                    Manager.viewManager.toggleView("stop_detail", stopDetailsClosure);

                    if(isOldAndroid) {
                        var section = document.querySelector("#stop_detail .scroll");
                        section.style.minHeight = window.innerHeight - 130 + "px";
                    }

                }
            }(stopDetailsClosure))
        });

    },

    goToViewOnMap: function (lat, long, text, btnBack) {

        var currentList = document.querySelector("div[screenname='view_on_map']");

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        var viewOnMapClosure = (function(lat, long, text, btnBack){
            return function () {
                viewOnMap(lat, long, text, btnBack);
            }
        }(lat, long, text, btnBack));

        Manager.viewManager.toggleView("view_on_map", viewOnMapClosure);

        if(isOldAndroid) {
            var section = document.querySelector("#view_on_map .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }

    },

    goToOrderList: function (stop, routeId) {

        var currentList = document.querySelector("div[screenname='orders_list']");

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        var stopListClosure = (function(stop, routeId){
            return function () {
                ordersListView (stop, routeId);
            }
        }(stop, routeId));

        Manager.viewManager.toggleView("orders_list", stopListClosure);

        if(isOldAndroid) {
            var section = document.querySelector("#orders_list .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }
    },

    goToCustomerStatistic: function (stop, routeId) {

        var currentView = document.querySelector("div[screenname='customer_statistic']");

        if(currentView !== null) {
            document.body.removeChild(currentView);
        }

        var customerStatisticClosure = (function(stop, routeId){
            return function () {
                customerStatistic (stop, routeId);
            }
        }(stop, routeId));

        Manager.viewManager.toggleView("customer_statistic", customerStatisticClosure);

        if(isOldAndroid) {
            var section = document.querySelector("#customer_statistic .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }
    },

    goToSearch: function (btnBack) {

        var currentList = document.querySelector("div[screenname='search']");

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        var searchClosure = (function(btnBack){
            return function () {
                searchView (btnBack);
            }
        }(btnBack));

        Manager.viewManager.toggleView("search", searchClosure);

    },

    backToSearch: function (btnBack) {

        var searchClosure = (function(btnBack){
            return function () {
                searchView (btnBack);
            }
        }(btnBack));

        Manager.viewManager.toggleView("search", searchClosure);


    },

    goToDriverDetails: function (routeId, driverName) {

        var currentList = document.querySelector("div[screenname='driver_detail']");

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        var callback = (function () {

            return function () {

                var driverDetailClosure = (function(routeId, driverName){
                    return function () {
                        driverDetail (routeId, driverName);
                    }
                }(routeId, driverName));

                Manager.viewManager.toggleView("driver_detail", driverDetailClosure);

                if(isOldAndroid) {
                    var section = document.querySelector("#driver_detail .scroll");
                    section.style.minHeight = window.innerHeight - 130 + "px";
                }
            }

        }());

        var route = Ro.Store.selectById('route', routeId);

        if (route) {
            callback();
        } else {
            var newRoute = new Models.Route ();

            newRoute.filter({
                routeId: routeId,
                success: callback
            })

        }

    },

    goToRouteFilter: function () {

        var currentList = document.querySelector("div[screenname='route_filter']");

        if(currentList !== null) {
            document.body.removeChild(currentList);
        }

        Manager.viewManager.toggleView("route_filter", routeFilter);

        if(isOldAndroid) {
            var section = document.querySelector("#route_filter .scroll");
            section.style.minHeight = window.innerHeight - 130 + "px";
        }

    },

    I18n: {
        getResourcesByKeyOrAlternative : function (resourceId, alternativeValue){
            var numberOfResources = Object.keys(Monet.I18n.resources).length;
            var message;

            if (numberOfResources === 0 && typeof alternativeValue !== 'undefined') {
                message   = alternativeValue;
            }else{
                message =  Monet.I18n.getResourcesByKey(resourceId);
            }

            return message;
        }
    },

    goToSwitchAppMode: function () {

        Manager.viewManager.toggleView(SwitchAppModeUtils.VIEW_NAME, switchAppMode);

    },

    goToSalesmanInitialView: function () {

        var currentScreen = document.querySelector("div[screenname='"+ SalesmanDashboardStopsUtils.VIEW_NAME +"']");

        if(currentScreen !== null) {
            document.body.removeChild(currentScreen);
        }

        Manager.viewManager.toggleView(SalesmanDashboardStopsUtils.VIEW_NAME, salesmanDashboardStops);

    },

    goToSalesmanStopList: function () {

        var currentScreen = document.querySelector("div[screenname='"+ SalesmanStopListUtils.VIEW_NAME +"']");

        if(currentScreen !== null) {
            document.body.removeChild(currentScreen);
        }


        Manager.viewManager.toggleView(SalesmanStopListUtils.VIEW_NAME, salesmanStopList);

    },
    goToInitialViewByAppMode: function (appMode) {

        if (appMode === SwitchAppModeUtils.MANAGER_MODE) {

            Session.appMode = SwitchAppModeUtils.MANAGER_MODE;
            Manager.goToRouteList();

        } else if (appMode === SwitchAppModeUtils.SALESMAN_MODE) {

            Session.appMode = SwitchAppModeUtils.SALESMAN_MODE;
            Manager.goToSalesmanInitialView();

        }
    },
    requestLoginAgain: function () {

        var dataCredentials    = JSON.parse(window.localStorage.getItem('credentials'));
        var loader   = new Ro.UIComponents.Loader();

        loader.show()
        loginViewDoLoginRequest(dataCredentials.login, dataCredentials.password, loginViewDoLoginRequestCallback)
    }
};