$.ajaxSetup({
    xhrFields: {
        mozSystem: true
    }
});

function loadcss (url) {
    var head = document.getElementsByTagName('head')[0], link = document.createElement('link');
    link.type = 'text/css';
    link.rel = 'stylesheet';
    link.href = url;
    head.appendChild(link);
    return link;
}

var isFirefox       = navigator.userAgent.match('Firefox') === null ? false : true;
var isOldAndroid    = (navigator.userAgent.match('Android 2.3') === null && navigator.userAgent.match('Android 3.2') === null) ? false : true;
var isAndroid4      = navigator.userAgent.match('Android 4.0') === null ? false : true;
var isModernAndroid = navigator.userAgent.match('Android 4.2') === null ? false : true;
var isIPhone        = navigator.userAgent.match('iPhone OS') === null ? false : true;
var isIPad          = navigator.userAgent.match('iPad') === null ? false : true;

if(isOldAndroid) {
    loadcss('stylesheets/roads.android.2.3.css');
    loadcss('stylesheets/greenmile.android.2.3.css');
} else {

    if (isFirefox) {
        loadcss('stylesheets/greenmile.ffos.css');
        loadcss('stylesheets/roads.ffos.css');
        loadcss('stylesheets/roads.css');
        loadcss('stylesheets/greenmile.css');

    } else {
        if (isModernAndroid) {
            loadcss('stylesheets/roads.android.css');
        } else {
            if(isAndroid4) {
                loadcss('stylesheets/roads.android.4.0.css');
                console.log('roads.android.4.0.css');
            } else {
                if (isIPhone || isIPad) {
                    loadcss('stylesheets/greenmile.ios.css');
                }
            }
        }

        loadcss('stylesheets/roads.css');
        loadcss('stylesheets/greenmile.css');

    }

}

Ro.globals.defaultTimeout = 30000;

function finishApp () {
    Android.finishApplication();
}

//Callback function to use Android Back button
window.AndroidBackButtonInterface = function () {
    finishApp ();
};

Manager.goToLogin();