var CreateMap = function (mapContainer, options) {

    var mapConfiguration = Monet.Session.Configurations.MapConfiguration.models[0];
    var serverUrl        = Monet.Maps.defaults.serverUrl;
    var format           = Monet.Maps.defaults.format;

    var map = new L.Map(mapContainer, options);

    var baseLayer = L.tileLayer.wms(window.hostConf + "/" + serverUrl + "/Cached", {
        layers:  mapConfiguration.get("wmsLayer"),
        format: format,
        transparent: true,
        crs: L.CRS.EPSG4326.code
    }).addTo(map);

    baseLayer.bringToBack();

    var marker = L.marker([options.center[0], options.center[1]], {
        icon : new L.Icon({
            iconUrl : 'images/marker.png',
            iconAnchor : new L.Point(34, -10),
            popupAnchor : new L.Point(0, 0)
        })
    }).addTo(map)
      .bindPopup(options.popUpText)
      .openPopup();


    var zoom = new L.Control.Zoom('bottomleft');

    zoom.addTo(map);

}

function ajaxHandler (xhr, successCallback, errorCallback, overwriteDefaultMessage) {

    if (typeof overwriteDefaultMessage === 'undefined') {
        overwriteDefaultMessage = false;
    }

    if (xhr.readyState === 4) {

        if (xhr.status === 200) {

            if (typeof successCallback !== 'undefined') {
                successCallback(xhr);
            }

        } else {

            if (overwriteDefaultMessage) {
                GenerictConnectionErroHandler(xhr.status);
            }

            if (typeof errorCallback !== 'undefined') {
                errorCallback(xhr);
            }

        }
    }

}


function addLoader () {
    var loader = new Ro.UIComponents.Loader();
    loader.show();
}

function removeLoader () {
    var loader = new Ro.UIComponents.Loader();
    loader.hide();
}

function GenerictConnectionErroHandler (errorCode) {

    switch (errorCode) {
        case 0:
            cannotReachServer();
            break;
        case 401:
            accessDenied();
            break;
        case 403:
            Manager.requestLoginAgain();
            break;
        case 404:
            ServerNotFound();
            break;
        case 500:
            internalServerError();
            break;
        case 503:
            serviceTemporarilyUnavailable();
            break;
    }

}

var cannotReachServer = function () {

    Ro.UIComponents.ToastNotification(
        Manager.I18n.getResourcesByKeyOrAlternative('GenericMessages.ServerNotFound', 'Cannot reach server')
    );

}

var ServerNotFound = function () {

    Ro.UIComponents.ToastNotification(
        Monet.I18n.getResourcesByKey('GenericMessages.ServerNotFound')
    );

}

var connectionTimeOut = function () {

    Ro.UIComponents.ToastNotification(
        Monet.I18n.getResourcesByKey('GenericMessages.Timeout')
    );

};

var internalServerError = function () {

    Ro.UIComponents.ToastNotification(
        Monet.I18n.getResourcesByKey('GenericMessages.InternalServerError')
    );

};

var accessDenied = function () {

    Ro.UIComponents.ToastNotification(
        Monet.I18n.getResourcesByKey('GenericMessages.AccessDenied')
    );

};

var serviceTemporarilyUnavailable = function () {

    Ro.UIComponents.ToastNotification(
        Monet.I18n.getResourcesByKey('GenericMessages.Service.Temporarily.Unavailable')
    );

};

function base64ArrayBuffer(arrayBuffer) {
    var base64    = ''
    var encodings = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
    
    var bytes         = new Uint8Array(arrayBuffer);
    var byteLength    = bytes.byteLength;
    var byteRemainder = byteLength % 3;
    var mainLength    = byteLength - byteRemainder;
    
    var a, b, c, d
    var chunk
    
    // Main loop deals with bytes in chunks of 3
    for (var i = 0; i < mainLength; i = i + 3) {
        // Combine the three bytes into a single integer
        chunk = (bytes[i] << 16) | (bytes[i + 1] << 8) | bytes[i + 2]
        
        // Use bitmasks to extract 6-bit segments from the triplet
        a = (chunk & 16515072) >> 18 // 16515072 = (2^6 - 1) << 18
        b = (chunk & 258048)   >> 12 // 258048   = (2^6 - 1) << 12
        c = (chunk & 4032)     >>  6 // 4032     = (2^6 - 1) << 6
        d = chunk & 63               // 63       = 2^6 - 1
        
        // Convert the raw binary segments to the appropriate ASCII encoding
        base64 += encodings[a] + encodings[b] + encodings[c] + encodings[d]
    }
    
    // Deal with the remaining bytes and padding
    if (byteRemainder == 1) {
        chunk = bytes[mainLength]
        
        a = (chunk & 252) >> 2 // 252 = (2^6 - 1) << 2
        
        // Set the 4 least significant bits to zero
        b = (chunk & 3)   << 4 // 3   = 2^2 - 1
        
        base64 += encodings[a] + encodings[b] + '=='
    } else if (byteRemainder == 2) {
        chunk = (bytes[mainLength] << 8) | bytes[mainLength + 1]
        
        a = (chunk & 64512) >> 10 // 64512 = (2^6 - 1) << 10
        b = (chunk & 1008)  >>  4 // 1008  = (2^6 - 1) << 4
        
        // Set the 2 least significant bits to zero
        c = (chunk & 15)    <<  2 // 15    = 2^4 - 1
        
        base64 += encodings[a] + encodings[b] + encodings[c] + '='
    }
    
    return base64
}

function isJson(text) {

    return (typeof text !== 'undefined') && (/^[\],:{}\s]*$/
        .test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
            .replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
            .replace(/(?:^|:|,)(?:\s*\[)+/g, '')))

}

function serverIsOldVersion() {

    var serverVersion = Monet.Session.Configurations.ServerInformation;
    var commercialVersion = serverVersion.commercialVersion;
    var arrayVersion = commercialVersion.split('.');
    var isOldVersion = false;

    if (arrayVersion[0] <= 4 && arrayVersion[1] < 5) {
        isOldVersion = true;
    }

    return isOldVersion;

}