var Models = Models || {};

Models.Locale = (function(){

    var Locale = function () {

        this.setName('locale');

        this.setFields({
            id: {
                type: 'number'
            },
            language: {
                type: 'string'
            },
            description: {
                type: 'string'
            },
            currency: {
                type: 'string'
            },
            dateFormat: {
                type: 'string'
            },
            decimalSymbol: {
                type: 'string'
            },
            digitalGrouping: {
                type: 'string'
            },
            key: {
                type: 'string'
            },
            timeFormat: {
                type: 'string'
            }
        });

        this.filter = function (obj) {

            var request     = new Ro.Ajax();

            request.url     = window.hostConf + '/I18NLocale?criteria={"filters":["*"]}';
            request.method  = 'get';

            request.success = function (data) {

                Ro.Store.set("locale", data);

                obj.success(data);

            };

            if (typeof obj.error !== "undefined") {
                request.error = obj.error;
            }

            request.send();

        };

        return this;

    };

    Locale.prototype = new Ro.Model();

    Ro.Store.addModel(Locale);

    return Locale;

})();
