var Models = Models || {};

Models.Locations = (function(){

    var Stops = function () {

        this.setName('locations');

        this.setFields({
            id: {
                type: 'number'
            },
            key: {
                type: 'string'
            },
            actualArrival: {
                type: 'date'
            },
            actualDeparture: {
                type: 'date'
            },
            actualDistance: {
                type: 'number'
            },
            actualSequenceNum: {
                type: 'integer'
            },
            actualService: {
                type: 'date'
            },
            actualServiceTime: {
                type: 'integer'
            },
            arrivalAccuracyMeters: {
                type: 'integer'
            },
            arrivalLatitude: {
                type: 'integer'
            },
            arrivalLongitude: {
                type: 'integer'
            },
            arrivalMobileGpsProvider: {
                type: 'string'
            },
            arrivedInTimeWindow: {
                type: 'boolean'
            },
            cancelCode: {
                type: 'object'
            },
            canceled: {
                type: 'boolean'
            },
            route: {
                type: 'object'
            },
            redeliveryStop: {
                type: 'object'
            },
            undeliverableCode: {
                type: 'object'
            },
            location: {
                type: 'object'
            },
            stopType: {
                type: 'string'
            }

        });

        this.filter = function (obj) {

            var request = new Ro.Ajax();

            request.url = window.hostConf + '/Location/filter?criteria={"filters":["id", "key", "organization.*", "description", "locationType.*", "accountType.*", "addressLine1", "addressLine2", "city", "state", "zipCode", "country", "district", "phone1", "phone1Type", "phone2", "phone2Type", "email", "latitude", "geocodingQuality", "deliveryRadius", "longitude", "serviceTimeType.*", "timeWindowType.*", "helperFixedTimeSecs", "helperVarTimeSecs", "nonHelperFixedTimeSecs", "nonHelperVarTimeSecs", "deliveryInstructions"]}';
            request.method = 'post';
            request.data = '{"id": ' + this.id + '}';

            request.success = function (data) {

                Ro.Store.set("stops", data);

                obj.success(data);

            };

            if (typeof obj.error !== "undefined") {
                request.error = obj.error;
            }

            request.send();

        };

        return this;

    };

    Stops.prototype = new Ro.Model();

    Ro.Store.addModel(Stops);

    return Stops;

})();
