var Models = Models || {};

Models.Route = (function(){

    var Route = function () {

        this.setName('route');

        var inProgress     = '&inProgress=' + window.inProgress;
        var beginDate      = '';
        var endDate        = '';
        var organizationId = '';
        var firstResult = '&firstResult=0';
        var maxResult = '&maxResult=51';

        if (window.firstResult) {
            firstResult = '&firstResult=' + window.firstResult;
        }

        if (window.beginDate) {
            beginDate = '&beginDate=' + encodeURIComponent(window.beginDate);
        }

        if (window.endDate) {
            endDate = '&endDate=' + encodeURIComponent(window.endDate);
        }

        if (window.organizationId) {
            organizationId = '&organizationId=' + window.organizationId;
        }

        // Route/PendingMonitor?firstResult=0&maxResult=51&inProgress=true&beginDate=07%2F29%2F2013&endDate=07%2F30%2F2013&organizationId=10000
        this.url = window.hostConf + '/Route/PendingMonitor?' + firstResult + maxResult + inProgress + beginDate + endDate + organizationId;

        this.setFields({
            id: {
                type: 'number'
            },
            date: {
                type: 'date'
            },
            key: {
                type: 'string'
            },
            principalEquipment: {
                type: 'string'
            },
            status: {
                type: 'string'
            },
            name: {
                type: 'string'
            },
            totalEventLogs: {
                type: 'integer',
                data: 0
            },
            totalStops: {
                type: 'integer',
                data: 0
            },
            actualDepartures: {
                type: 'integer',
                data: 0
            },
            canceledStops: {
                type: 'integer',
                data: 0
            },
            redeliveredStops: {
                type: 'integer',
                data: 0
            },
            undeliveredStops: {
                type: 'integer',
                data: 0
            },
            driversName: {
                type: 'string',
                data: ''
            }
        });

        this.filter = function (obj) {

            var request    = new Ro.Ajax();

            request.url    = window.hostConf + '/Route/filter?criteria={"filters":["*.*"]}';
            request.method = 'post';
            request.data   = '{"id": ' + obj.routeId + '}';

            request.success = function (data) {
                Ro.Store.set("route", data);
                obj.success(data);
            };

            if (typeof obj.error !== "undefined") {
                request.error = obj.error;
            }

            request.ontimeout = obj.timeout;

            request.send();

        };

        return this;

    };

    Route.prototype = new Ro.Model();

    Ro.Store.addModel(Route);

    return Route;

})();
