var Models = Models || {};

Models.Stop = (function(){

    var Stop = function () {

        this.setName('stop');

        this.setFields({
            id: {
                type: 'number'
            },
            key: {
                type: 'string'
            },
            actualArrival: {
                type: 'date'
            },
            actualDeparture: {
                type: 'date'
            },
            actualDistance: {
                type: 'number'
            },
            actualSequenceNum: {
                type: 'integer'
            },
            actualService: {
                type: 'date'
            },
            actualServiceTime: {
                type: 'integer'
            },
            arrivalAccuracyMeters: {
                type: 'integer'
            },
            arrivalLatitude: {
                type: 'integer'
            },
            arrivalLongitude: {
                type: 'integer'
            },
            arrivalMobileGpsProvider: {
                type: 'string'
            },
            arrivedInTimeWindow: {
                type: 'boolean'
            },
            cancelCode: {
                type: 'object'
            },
            canceled: {
                type: 'boolean'
            },
            route: {
                type: 'object'
            },
            routeId: {
                type: 'integer'
            },
            redeliveryStop: {
                type: 'object'
            },
            undeliverableCode: {
                type: 'object'
            },
            location: {
                type: 'object'
            },
            plannedArrival: {
                type: 'date'
            },
            plannedDeparture: {
                type: 'date'
            },
            plannedDistance: {
                type: 'number',
                data: ""
            },
            plannedSequenceNum: {
                type: 'number',
                data: ""
            },
            plannedService: {
                type: 'date',
                data: ""
            },
            plannedServiceTime: {
                type: 'number',
                data: ""
            },
            projectedArrival: {
                type: 'date'
            },
            projectedDeparture: {
                type: 'date'
            },
            projectedDistance: {
                type: 'date'
            },
            projectedService: {
                type: 'date'
            },
            redelivered: {
                type: 'boolean'
            },
            stopType: {
                type: 'object'
            },
            locationRequired: {
                type: 'boolean'
            },
            plannedSize1: {
                type: 'number',
                data: 0
            },
            plannedSize2: {
                type: 'number',
                data: 0
            },
            plannedSize3: {
                type: 'number',
                data: 0
            },
            actualSize1: {
                type: 'number',
                data: 0
            },
            actualSize2: {
                type: 'number',
                data: 0
            },
            actualSize3: {
                type: 'number',
                data: 0
            },
            plannedPickupSize1: {
                type: 'number',
                data: 0
            },
            plannedPickupSize2: {
                type: 'number',
                data: 0
            },
            plannedPickupSize3: {
                type: 'number',
                data: 0
            },
            actualPickupSize1: {
                type: 'number',
                data: 0
            },
            actualPickupSize2: {
                type: 'number',
                data: 0
            },
            actualPickupSize3: {
                type: 'number',
                data: 0
            }

        });

        this.filter = function (obj) {

            var request    = new Ro.Ajax();
            var route      = this.select("route");

            request.url    = window.hostConf + '/Stop/filter?criteria={"filters":["*",' +
                '"location.locationType.*",' +
                '"location.*",' +
                '"stopType.*",' +
                '"cancelCode.*",' +
                '"redeliveryStop.*",' +
                '"redeliveryStop.location.key*",' +
                '"undeliverableCode.*"]}';

            request.method = 'post';
            request.data   = '{"route": ' + JSON.stringify(route) + '}';

            request.success = function (data) {

                for (var i=0; i < data.length; i++) {

                    data[i].routeId = route.id;

                }

                Ro.Store.set("stop", data);

                obj.success(data);

            };

            if (typeof obj.error !== "undefined") {
                request.error = obj.error;
            }

            request.ontimeout = obj.timeout;

            request.send();

        };

        this.filterWithRestrictionsOnRoute = function (obj) {

            var request = new Ro.Ajax();
            var criteria = '{"filters":["**.*"]}';
            var dataStops = [];

            request.url    = window.hostConf + '/Route/restrictions?criteria=';
            request.method = 'post';
            request.data   = JSON.stringify(obj.data);


            if (obj.filters) {
                criteria = JSON.stringify(obj.filters);
            }

            request.url += criteria;
            request.success = function (data) {

                for (var i =0; i < data.length; i++) {

                    var stops = data[i].stops;

                    for (var j = 0; j < stops.length; j++) {

                        stops[j].routeId = data[i].id;
                        Ro.Store.set("stop", stops[j]);

                    }

                    Ro.Store.set("route", data[i]);

                }

                obj.success(data);

            };

            if (typeof obj.error !== "undefined") {
                request.error = obj.error;
            }

            request.ontimeout = obj.timeout;

            request.send();

        };

        return this;

    };

    Stop.prototype = new Ro.Model();

    Ro.Store.addModel(Stop);

    return Stop;

})();
