function customerStatistic (stop, routeId) {

    var route     = Ro.Store.selectById('route', routeId);
    var location  = stop.select('location');

    var customerStatisticView = new Ro.View('customer_statistic');

    var buttonBar = new Ro.UIComponents.ButtonBar('toolbar_host_conf');
    var search    = new Ro.UIComponents.Button("search");
    var spacer    = new Ro.UIComponents.Button("spacer");

    var classIcon                          = "stopIcon " + renderStopStatus(stop);
    var iconDiv                            = document.createElement('div');
    var customerNameDiv                    = document.createElement('div');
    var customerNameText                   = document.createElement('div');

    var customerNameContainer              = document.createElement("div");
    var customerDetailsContainer           = document.createElement("div");
    var customerStatisticsContainer        = document.createElement("div");
    var lastDriverContainer                = document.createElement("div");

    var undeliverableReasonsChartContainer = document.createElement("div");
    var cancelReasonsChartContainer        = document.createElement("div");
    var redeliveryReasonsChartContainer    = document.createElement("div");

    var loaderCustomerDetails              = document.createElement('div');
    var loaderCancel                       = document.createElement('div');
    var loaderUndeliverable                = document.createElement('div');
    var loaderreceliverable                = document.createElement('div');

    var stopStatusIcon = new Ro.UIComponents.Icon({
        url: "images/stopDetail.png",
        className: classIcon
    });

    var goToStopDetail = (function (routeId, stop) {
        return function () {
            Manager.goToStopDetail(routeId, stop, "");
        }
    }(routeId, stop));

    iconDiv.className = classIcon;

    customerNameText.innerHTML = location.key + " - " + stop.select("location").description;
    customerNameText.className = "customerNameText";
    customerNameDiv.className  = "customerName";

    customerNameDiv.appendChild(iconDiv);
    customerNameDiv.appendChild(customerNameText);

    customerStatisticView.stage.appendChild(customerNameDiv);

    customerNameContainer.id               = "customerNameContainer";
    customerDetailsContainer.id            = "customerDetailsContainer";
    customerStatisticsContainer.id         = "customerStatisticsContainer";
    undeliverableReasonsChartContainer.id  = "undeliverableReasonsChart";
    cancelReasonsChartContainer.id         = "cancelReasonsChart";
    redeliveryReasonsChartContainer.id     = "redeliveryReasonsChart";
    lastDriverContainer.id                 = "lastDriverContainer";

    loaderCancel.className                 = 'screen_loader_inline';
    loaderUndeliverable.className          = 'screen_loader_inline';
    loaderreceliverable.className          = 'screen_loader_inline';
    loaderCustomerDetails.className        = 'screen_loader_inline';

    customerNameContainer.appendChild(customerNameDiv);
    customerStatisticsContainer.appendChild(loaderCustomerDetails);
    cancelReasonsChartContainer.appendChild(loaderCancel);
    undeliverableReasonsChartContainer.appendChild(loaderUndeliverable);
    redeliveryReasonsChartContainer.appendChild(loaderreceliverable);

    customerStatisticView.addHeader(
        Monet.I18n.getResourcesByKey('CustomerStatistic.Title')
    );

    customerStatisticView.addHeaderButton({
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey('BackTo.Stop'),
        onClick: goToStopDetail
    });

    customerDetailsContainer.appendChild(customerNameContainer);
    customerDetailsContainer.appendChild(customerStatisticsContainer);
    customerDetailsContainer.appendChild(undeliverableReasonsChartContainer);
    customerDetailsContainer.appendChild(cancelReasonsChartContainer);
    customerDetailsContainer.appendChild(redeliveryReasonsChartContainer);
    customerDetailsContainer.appendChild(lastDriverContainer);

    customerStatisticView.stage.appendChild(customerDetailsContainer);

    customerStatisticView.addFooter();

    search.setIcon('url(images/btn_search_icon.png)');

    search.setAction(function (){
        Manager.goToSearch({
            text: Monet.I18n.getResourcesByKey('CustomerStatistic.Title'),
            action: (function(routeId, stop, classIcon){
                return function () {
                    Manager.goToCustomerStatistic(stop, routeId);
                }
            }(routeId, stop, classIcon))
        });
    });

    spacer.setFlexWidth(4);

    buttonBar.addButton(search);
    buttonBar.addButton(spacer);
    buttonBar.addToScreen(customerStatisticView, "footer");

    window.AndroidBackButtonInterface = goToStopDetail;

    getCostumeStatistics(location.id);
    getLastDriversThatServicedThisCustomer(location.id);
    getUndeliverableChart(location.id);
    getRedeliveryChart(location.id);
    getCancelChart(location.id);

};

function getRedeliveryChart (locationId) {

    callPieChar(locationId, "TOP_REDELIVERY_CODE", function (closure){
        pieChart (
            closure,
            "redeliveryReasonsChart",
            Monet.I18n.getResourcesByKey("Kpi.Title.TopRedeliveryReasons")
        );
    })

}

function getCancelChart (locationId) {

    callPieChar(locationId, "TOP_CANCEL_CODE", function (closure){
        pieChart (
            closure,
            "cancelReasonsChart",
            Monet.I18n.getResourcesByKey("Kpi.Title.TopCancelReasons")
        );
    })

}

function getUndeliverableChart (locationId) {

    callPieChar(locationId, "TOP_UNDELIVERABLE_CODE", function (closure){
        pieChart (
            closure,
            "undeliverableReasonsChart",
            Monet.I18n.getResourcesByKey("Kpi.Title.TopUndeliverableReasons")
        );
    })

}

function callPieChar (locationId, kpiKey, callback) {

    this.filters = {};

    var now, past, stringifiedParameters;

    var request  = new Ro.Ajax();
    var baseUrl  = Ro.Store.selectById('host_conf', 1).select("host_address");
    request.url  = baseUrl + '/Dashboard/KpiByType/' + kpiKey;

    now  = new Date();
    past = new Date(now.getFullYear(), now.getMonth() - 120, 1);

    this.filters.startDate = past.toJSON();
    this.filters.endDate   = now.toJSON();
    this.filters.topValue  = 5;
    this.filters.locationIdList  = [locationId];

    request.method = 'post';

    request.success = (function () {
        return function (data) {
            callback (data);
        };
    })();

    stringifiedParameters = JSON.stringify(
        this.filters, ["endDate", "startDate", "topValue", "locationIdList"]
    );

    request.data = stringifiedParameters;
    request.send();

}


function pieChart (data, element, title) {

    var el = document.getElementById(element);
    var values = [];

    if (data.topResults.length > 0) {

        for (var i=0; i < data.topResults.length; i++) {
            values.push([
                data.topResults[i].description,
                data.topResults[i].value
            ])
        }

    } else {
        values = [];
    }

    $('#'+element).highcharts({
        chart: {
            type: 'pie',
            reflow: true,
            backgroundColor:'transparent',
            events: {
                load: function(event) {
                    //When is chart ready?
                    $(window).resize();
                }
            }
        },
        credits: {
            enabled: false
        },
        title: {
            text: title,
            style: {
                color: 'rgb(199, 199, 199)'
            }
        },
        xAxis: {
            gridLineWidth: 1,
            lineColor: 'rgb(194, 194, 194)',
            tickColor: 'rgb(194, 194, 194)',
            labels: {
                style: {
                    color: 'rgb(194, 194, 194)'
                }
            },
            title: {
                style: {
                    color: 'rgb(194, 194, 194)'
                }
            }
        },
        yAxis: {
            minorTickInterval: 'auto',
            lineColor: 'rgb(194, 194, 194)',
            lineWidth: 1,
            tickWidth: 1,
            tickColor: 'rgb(194, 194, 194)',
            labels: {
                style: {
                    color: 'rgb(194, 194, 194)'
                }
            },
            title: {
                style: {
                    color: 'rgb(194, 194, 194)'
                }
            }
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: false,
                    color: 'rgb(194, 194, 194)',
                    connectorColor: 'rgb(194, 194, 194)',
                    formatter: function () {
                        return '<b>'+ Monet.I18n.getResourcesByKey(this.point.name) +'</b>: '+ this.percentage.toFixed(2) +' %';
                    }
                },
                showInLegend: true

            }
        },
        legend: {
            width: 300,
            borderWidth: 0,
            align: 'bottom',
            labelFormatter: function() {
                return '<div style="color: white">' + this.name + '</div>';
            }
        },
        series: [{
            type: 'pie',
            data : values
        }],
        exporting: {
            enabled: false
        }
    });

}

function getCostumeStatistics (locationID) {

    var request     = new Ro.Ajax();
    var baseUrl     = Ro.Store.selectById('host_conf', 1).select("host_address");

    request.url     = baseUrl + '/Location/DeliveryStatistics?locationId=' + locationID;
    request.method  = 'get';
    request.success = getCostumeStatisticsCallback;

    request.send();

}

function getCostumeStatisticsCallback (data) {

    var customerStatisticsContainer = document.getElementById("customerStatisticsContainer");
    var loader = document.querySelector("#customerDetailsContainer .screen_loader_inline");
    var container = document.getElementById("customerStatisticsContainer");

    customerStatisticsContainer.removeChild(loader);

    var screenLayout = new Ro.UIComponents.ScrenLayout.GroupedList([
        {
            header: {
                title: Monet.I18n.getResourcesByKey('CustomerStat.Headers.Title')
            },
            items: [{
                label: Monet.I18n.getResourcesByKey('CustomerStat.Items.Deliveries'),
                content: data.numberOfDeliveries
            }, {
                label: Monet.I18n.getResourcesByKey('CustomerStat.Items.PercentDeliveries'),
                content: data.deliveriesOnTimeWindow
            }, {
                label: Monet.I18n.getResourcesByKey('CustomerStat.Items.AverageCubes'),
                content: data.avgSize1.toFixed(2)
            }, {
                label: Monet.I18n.getResourcesByKey('CustomerStat.Items.AverageVolume'),
                content: data.avgSize2.toFixed(2)
            }, {
                label: Monet.I18n.getResourcesByKey('CustomerStat.Items.AverageKGs'),
                content: data.avgSize3.toFixed(2)
            }]
        }]);

    container.appendChild(screenLayout);

}

function getLastDriversThatServicedThisCustomer (locationID) {

    var request     = new Ro.Ajax();
    var baseUrl     = Ro.Store.selectById('host_conf', 1).select("host_address");
    request.url     = baseUrl + '/Location/LatestServices?locationId='+locationID+'&firstResult=0&maxResults=5';

    request.method  = 'get';
    request.success = getLastDriversThatServicedThisCustomerCallback;
    request.send();

}

function getLastDriversThatServicedThisCustomerCallback (data) {

    var container = document.getElementById("lastDriverContainer");
    var lineItens = [];
    var lastVisit, lastPlannedVisit, reasonDescription;
    var lastVisitResource, lastPlannedVisitResource, reasonDescriptionResource;

    for (var i = 0; i < data.length; i++) {

        lastVisitResource         = Monet.I18n.getResourcesByKey("CustomerStatistic.History.Last");
        lastPlannedVisitResource  = Monet.I18n.getResourcesByKey("CustomerStatistic.History.Planned");
        reasonDescriptionResource = Monet.I18n.getResourcesByKey("CustomerStatistic.History.Reason");


        lastVisit         = typeof data[i].lastVisit !== "undefined" ? lastVisitResource + " " + Globalize.format(Date.create(data[i].lastVisit), Monet.I18n.locale.dateFormat) + "<br>" : "";
        lastPlannedVisit  = typeof data[i].lastPlannedVisit !== "undefined" ? lastPlannedVisitResource + " " + Globalize.format(Date.create(data[i].lastPlannedVisit), Monet.I18n.locale.dateFormat) + "<br>" : "";
        reasonDescription = typeof data[i].reasonDescription !== "undefined" ? reasonDescriptionResource + " " + data[i].reasonDescription : "";

        lineItens.push({
            label: data[i].driverName,
            content: lastVisit + lastPlannedVisit + reasonDescription
        })

    }

    var screenLayout = new Ro.UIComponents.ScrenLayout.GroupedList([{
        header: {
            title: Monet.I18n.getResourcesByKey('CustomerStat.Headers.History')
        },
        items: lineItens
    }]);

    container.appendChild(screenLayout);
}