function driverDetail (routeId, driverName) {

    var route             = Ro.Store.selectById('route', routeId);
    var driverDetailView  = new Ro.View('driver_detail');
    var buttonBar         = new Ro.UIComponents.ButtonBar('toolbar_driver_detail');
    var search            = new Ro.UIComponents.Button("search");
    var spacer            = new Ro.UIComponents.Button("spacer");

    var h1 = document.createElement('h1');

    var driverPositionDiv               = document.createElement('div');
    driverPositionDiv.className         = "driverPositionIconWaiting";

    var driverPositionDoneDiv           = document.createElement('div');
    driverPositionDoneDiv.id            = "driverPositionDoneDiv";
    driverPositionDoneDiv.style.display = "none";

    h1.innerHTML = driverName;

    driverDetailView.addHeader(
        Monet.I18n.getResourcesByKey('DriverDetail.Title')
    );

    driverDetailView.stage.appendChild(h1);

    var goToStopList = (function(routeId){
        return function () {
            Manager.goToStopList(routeId);
        }
    })(routeId);

    var backToSearch = (function () {
      return function () {
          Manager.backToSearch({
              text: Monet.I18n.getResourcesByKey('Route.Title'),
              action: Manager.goToRouteList
          });
      }
    }());

    driverDetailView.addHeaderButton({
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey('Search.Title'),
        onClick: backToSearch
    });

    var addressIcon = new Ro.UIComponents.Icon({
        url: "images/stopDetail.png",
        action: goToStopList
    });

    var screenLayout = new Ro.UIComponents.ScrenLayout.GroupedList([{
        header: {
            title: Monet.I18n.getResourcesByKey('DriverDetail.Headers.ActiveRoute'),
            icon: addressIcon
        },
        items: [{
            content: renderRouteInfo (route)
        }]
    }], true);

    driverDetailView.stage.appendChild(screenLayout);
    driverDetailView.stage.appendChild(driverPositionDiv);
    driverDetailView.stage.appendChild(driverPositionDoneDiv);

    driverOnMap (routeId, driverName);

    driverDetailView.addFooter();

    search.setIcon('url(images/btn_search_icon.png)');
    search.setAction(function (){
        Manager.goToSearch({
            text: Monet.I18n.getResourcesByKey('Route.Title'),
            action: Manager.goToRouteList
        });
    });

    spacer.setFlexWidth(4);

    buttonBar.addButton(search);
    buttonBar.addButton(spacer);

    buttonBar.addToScreen(driverDetailView, "footer");

    window.AndroidBackButtonInterface = goToStopList;

};

function renderRouteInfo (route) {

   var routeKey      = route.select("key");
   var stops         = Ro.Store.find('stop', {routeId: route.id});
   var numberOfStops = stops.length;
   var stopsPlannedResource = Monet.I18n.getResourcesByKey("DriverDetail.NumberOfStopsPlanned");
   var totalSize1 = 0, totalSize2 = 0, totalSize3 = 0;

   for (var i = 0; i < numberOfStops; i++) {

       if (typeof stops[i].select("plannedSize1") !== 'undefined') {
           totalSize1 += stops[i].select("plannedSize1");
       }

       if (typeof stops[i].select("plannedSize2") !== 'undefined') {
           totalSize2 += stops[i].select("plannedSize2");
       }

       if (typeof stops[i].select("plannedSize3") !== 'undefined') {
           totalSize3 += stops[i].select("plannedSize3");
       }

   }

   var html = "";

   html += routeKey + "<br />";
   html += numberOfStops + " " + stopsPlannedResource + "<br />";
   html += totalSize1 + " " + Monet.Session.Configurations.size1Alias + ", ";
   html += totalSize2 + " " + Monet.Session.Configurations.size2Alias + ", ";
   html += totalSize3 + " " + Monet.Session.Configurations.size3Alias + "<br />";

   return html;
}

function driverOnMap (routeId, driverName) {

    var coordsLoader  = document.querySelector("#driver_detail .driverPositionIconWaiting");
    var coordsGoToMap = document.querySelector("#driver_detail #driverPositionDoneDiv");
    var lastCoord;

    $.ajax({
        url: window.hostConf + "/Route/" + routeId + "/Coordinates",
        type: 'GET',
        headers: {
            "Cookie": window.cookie
        },
        'contentType' : 'application/json',
        dataType : 'json',
        success: function (data) {

            if (data !== null) {

                if (data.length > 0) {

                    lastCoord = data[data.length-1];

                    coordsLoader.style.display = "none";
                    coordsGoToMap.style.display = "block";
                    coordsGoToMap.className = "driverPositionIconDone";

                    coordsGoToMap.addEventListener('click', (function (lastCoord) {

                        return function () {
                            Manager.goToViewOnMap(
                                lastCoord.position.latitude,
                                lastCoord.position.longitude,
                                driverName,{
                                    text: driverName,
                                    action: (function(routeId, driverName){
                                        return function () {
                                            Manager.goToDriverDetails (routeId, driverName);
                                        }
                                    }(routeId, driverName))
                                }
                            );
                        }

                    }(lastCoord)))

                } else {

                    coordsLoader.style.display = "none";
                    coordsGoToMap.style.display = "block";
                    coordsGoToMap.className = "driverPositionIconDoneNoCoordinates";

                }

            } else {
                coordsLoader.style.display = "none";
                coordsGoToMap.style.display = "block";
                coordsGoToMap.className = "driverPositionIconDoneNoCoordinates";
            }

        }
    })

}