function hostConfView () {

    var hostConfView      = new Ro.View('host_conf');
    var buttonBar         = new Ro.UIComponents.ButtonBar('toolbar_host_conf');
    var confirm           = new Ro.UIComponents.Button("confirm");
    var qrCode            = new Ro.UIComponents.Button("qrCode");
    var bSpacer           = new Ro.UIComponents.Button("teste_spacer");

    var logoGM            = document.createElement("div");
    var formBox           = document.createElement("div");
    var hostLabel         = document.createElement("label");
    var hostInput         = document.createElement("input");
    var screnTitle, fieldLabel, loginButtonText;

    screnTitle        = Manager.I18n.getResourcesByKeyOrAlternative('HostConf.Title', 'Server Address');
    fieldLabel        = Manager.I18n.getResourcesByKeyOrAlternative('HostConf.Form.ServerAddress', 'Server Address');
    loginButtonText   = Manager.I18n.getResourcesByKeyOrAlternative('Login.Title', 'Login');

    logoGM.className = "logo_greenmile";

    if (Ro.environment.browser.isOldAndroid) {
        logoGM.style.marginTop = '20px';
    }

    hostConfView.addHeader(screnTitle);

    hostConfView.stage.appendChild(logoGM);

    hostConfView.addHeaderButton({
        type: 'leftNav',
        text: loginButtonText,
        onClick: Manager.goToLogin
    });

    hostConfView.stage.className += ' greenmile_trees';

    hostLabel.innerHTML = fieldLabel;

    hostInput.type  = 'url';
    hostInput.id    = 'formHostAddressConf';

    if (typeof window.localStorage.hostConf !== "undefined") {
        hostInput.value = window.localStorage.hostConf;
    } else {
        hostInput.value = 'http://';
    }

    formBox.className    = "formBox";
    formBox.style.height = '100px';

    formBox.appendChild(hostLabel);
    formBox.appendChild(hostInput);

    hostConfView.stage.appendChild(formBox);

    hostConfView.addFooter();

    confirm.setIcon('url(images/btn_confirm_icon.png)');
    confirm.setAction(hostConfViewSaveHostAddress);

    if (isIPhone || isIPad || isFirefox) {

        qrCode.setFlexWidth(1);

    } else {

        qrCode.setIcon('url(images/btn_qrcode_asphalt.png)');
        qrCode.setAction(window.AndroidCallQrCode);

    }

    buttonBar.addButton(qrCode);

    bSpacer.setFlexWidth(3);
    buttonBar.addButton(bSpacer);
    buttonBar.addButton(confirm);

    buttonBar.addToScreen(hostConfView, "footer");

    window.AndroidBackButtonInterface = Manager.goToLogin;

    window.AndroidQRCodeSuccess = function (content) {
        var hostInput = document.getElementById("formHostAddressConf");
        var serverAddrs = {
            server:content,
            auto : false
        };

        var contentIsJson = isJson(content);

        if (contentIsJson) {
            serverAddrs = JSON.parse(content);
            window.UserJsonParamters = serverAddrs;
        }

        hostInput.value = serverAddrs.server.trim();

        if (serverAddrs.auto === 'true') {
            hostConfViewSaveHostAddress();
        }
    };;

    window.AndroidQRCodeError = function (i18NResourceError) {
        Ro.UIComponents.ToastNotification( Monet.I18n.getResourcesByKey(i18NResourceError));
    };

}

function hostConfViewSaveHostAddress () {

    var hostInput = document.getElementById("formHostAddressConf");
	hostInput.value = hostInput.value.trim();
    var toastNotification = Manager.I18n.getResourcesByKeyOrAlternative('HostConf.Alert.ServerIsRequired', 'Server Address is Required');
    if (hostInput.value === "" || hostInput.value === "http://") {

        Ro.UIComponents.ToastNotification(toastNotification);

    } else {

        Ro.Store.set('host_conf', {
            id: 1,
            host_address: hostInput.value
        });

        window.localStorage.hostConf = hostInput.value;

        window.hostConf = hostInput.value;

        Manager.goToLogin();

    }

};
