function localeListView () {

    var i18n           = Monet.I18n;
    var ui             = Ro.UIComponents;

    var localeListView = new Ro.View('locale_list');
    var locales        = new Models.Locale();
    var listView       = new ui.ListView();

    localeListView.addHeader(
        Manager.I18n.getResourcesByKeyOrAlternative('LocaleList.Title', 'Locales list')
    );

    localeListView.addHeaderButton({
        type: 'leftNav',
        text: Manager.I18n.getResourcesByKeyOrAlternative('Login.Title', 'Login'),
        onClick: Manager.goToLogin
    });

    listView.listItemAction = loadResourcesByLocale;
    listView.dataProvider   = Models.Locale;
    listView.defaultInfo    = 'description';
    listView.el.className   = "table_list dark";

    addLoader();

    locales.filter({

        success: function () {

            listView.addToScreen(localeListView, "section > section");

            removeLoader();

        },

        error: function (xhr) {

            removeLoader();

            GenerictConnectionErroHandler (xhr.status);

            Manager.goToHostConf();

        },

        timeout: function () {

            connectionTimeOut();

            removeLoader();

        }

    });

    window.AndroidBackButtonInterface = Manager.goToHostConf;

}

function loadResourcesByLocale (locale) {

    addLoader();

    var request    = new Ro.Ajax();

    request.url    = window.hostConf + '/I18NResource/filter?criteria={"filters":["key", "value"]}';
    request.method = 'post';
    request.data   = '{"i18nlocale": {"language":"' + locale.select("language") + '"}, "module": {"key":"GreenMileManager"}}';

    request.success = function (data) {
        prepareMonet (locale, data);
        destroyTranslatedScreens ();
        removeLoader();
        Manager.goToLogin();
    };

    request.send();

}

function prepareMonet (locale, data) {

    setLocaleToMonet (locale);
    processLocalesToManager (data);

}

function setLocaleToMonet (locale) {

    Monet.I18n.locale           = locale.selectAll();
    window.localStorage.locales = JSON.stringify(Monet.I18n.locale);

}

function processLocalesToManager (data) {

    Monet.I18n.resources = {};

    for (var i = 0; i < data.length; i++) {
        Monet.I18n.resources[data[i].key] = data[i].value;
    }

    window.localStorage.resources = JSON.stringify(Monet.I18n.resources);
}

function destroyTranslatedScreens () {

    var login      = document.getElementById("login");
    var hostConf   = document.getElementById("host_conf");
    var routeList  = document.getElementById("route_list");
    var orderList  = document.getElementById("stops_list");
    var stopList   = document.getElementById("orders_list");
    var stopDetail = document.getElementById("stop_detail");
    var search     = document.querySelector("div[screenname='search']");
    var viewOnMap  = document.getElementById("view_on_map");
    var cStatistic = document.getElementById("customer_statistic");

    if (login) {
        document.body.removeChild(login);
    }

    if (hostConf) {
        document.body.removeChild(hostConf);
    }

    if (routeList) {
        document.body.removeChild(routeList);
    }

    if (orderList) {
        document.body.removeChild(orderList);
    }

    if (stopList) {
        document.body.removeChild(stopList);
    }

    if (stopDetail) {
        document.body.removeChild(stopDetail);
    }

    if (search) {
        document.body.removeChild(search);
    }

    if (viewOnMap) {
        document.body.removeChild(viewOnMap);
    }

    if (cStatistic) {
        document.body.removeChild(cStatistic);
    }

}