/**
 * @author Mozart Diniz <mozart.diniz@gmail.com>
 * Date: 6/16/13
 * Time: 5:55 PM
 */

function loginView () {

    var login       = new Ro.View('login');
    var tb          = new Ro.UIComponents.ButtonBar('toolbarTela1');
    var btnLogin    = new Ro.UIComponents.Button("btn_login");
    var btnQrCode   = new Ro.UIComponents.Button("btn_login_qrcode");
    var bSpacer1    = new Ro.UIComponents.Button("teste_spacer1");
    var bSpacer2    = new Ro.UIComponents.Button("teste_spacer2");
    var c           = new Ro.UIComponents.Button("configure_server");
    var dataCredentials    = window.localStorage.getItem('credentials');
    var credentials = {
        login: '',
        password: ''
    };

    if (dataCredentials) {
        credentials = JSON.parse(dataCredentials);
    }

    var adjustSize  = null;
    var loginBox    = document.createElement("div");
    var userLabel   = document.createElement("label");
    var passLabel   = document.createElement("label");
    var userInput   = document.createElement("input");
    var passInput   = document.createElement("input");
    var logoGM      = document.createElement("div");
    var loginLoader = new Ro.UIComponents.Loader();

    logoGM.className      = "logo_greenmile";

    login.addHeader(
        Monet.I18n.getResourcesByKey('Login.Title')
    );

    if (Ro.environment.browser.isOldAndroid) {
        logoGM.style.marginTop = '20px';
    }

    login.stage.appendChild(logoGM);

    userLabel.innerHTML = Monet.I18n.getResourcesByKey('Login.Form.User');
    passLabel.innerHTML = Monet.I18n.getResourcesByKey('Login.Form.Password');

    userInput.type = "text";
    userInput.id   = "userLogin";
    userInput.value = credentials.login;
    userInput.autofocus = 'autofocus';

    passInput.type = "password";
    passInput.id   = "userPassword";
    passInput.value = credentials.password;

    loginBox.className = "formBox";

    userInput.addEventListener('focus', function () {
        Ro.UIComponents.MenuRemove('login');
    });

    passInput.addEventListener('focus', function () {
        Ro.UIComponents.MenuRemove('login');
    });

    loginBox.appendChild(userLabel);
    loginBox.appendChild(userInput);
    loginBox.appendChild(passLabel);
    loginBox.appendChild(passInput);

    login.stage.className += ' greenmile_trees';
    login.stage.appendChild(loginBox);

    login.addFooter();

    if (isIPhone || isIPad || isFirefox) {

        btnQrCode.setFlexWidth(1);
        tb.addButton(btnQrCode);

    } else {

        btnQrCode.setIcon('url(images/btn_qrcode_asphalt.png)');
        btnQrCode.setAction(window.AndroidCallQrCode);
        tb.addButton(btnQrCode);

    }

    bSpacer1.setFlexWidth(1);
    tb.addButton(bSpacer1);

    btnLogin.setIcon('url(images/btn_confirm_icon.png)');
    btnLogin.setAction(loginViewDoLogin);
    tb.addButton(btnLogin);

    bSpacer2.setFlexWidth(1);
    tb.addButton(bSpacer2);

    c.setIcon('url(images/btn_conf_icon.png)');
    c.setAction(loginViewShowMenu);
    tb.addButton(c);

    tb.addToScreen(login, "footer");

    if (Ro.environment.browser.isOldAndroid) {

        setTimeout(function(){
            adjustSize = document.querySelector("div.screen[screenname=login] section.scroll");
            adjustSize.style.height = (window.innerHeight - 132) + "px";
            logoGM.style.top = '20px';
        }, 20)

    } else {
        if (Ro.environment.browser.isIPhone) {
            logoGM.style.top = '20px';
        }
    }

    window.AndroidBackButtonInterface = finishApp;
    window.AndroidQRCodeSuccess = threatQrCodeSuccessLogin;
    window.AndroidQRCodeError = threatQrCodeErrorLogin;

};

function saveUserAndSenhaOnLocalStorage(login, password) {

    var user = {};

    if (login && password) {

        user.login = login;
        user.password = password;

        window.localStorage.setItem('credentials', JSON.stringify(user));
    }

}

function loginViewDoLogin () {

    var formBox  = document.querySelector("div.screen[screenname=login] div.formBox");
    var loader   = new Ro.UIComponents.Loader();
    var login    = document.getElementById("userLogin");
    var password = document.getElementById("userPassword");

    if (login.value === "") {

        Ro.UIComponents.ToastNotification(
            Monet.I18n.getResourcesByKey('Login.Alert.UserAndPasswordAreRequired')
        );

    } else {


        if (!loader.isVisible()) {

            formBox.style.display = "none";
            loader.show();

            saveUserAndSenhaOnLocalStorage(login.value, password.value);
            loginViewDoLoginRequest(login.value, password.value, loginViewDoLoginRequestCallback);
        }

    }

};

function loginViewDoLoginRequest (login, password, callbackSuccess) {

    window.cookie = "";

    var login         = login;
    var password      = password;

    var request       = new Ro.Ajax();

    request.url       = window.hostConf + "/login";
    request.method    = 'post';
    request.data      = "j_password=" + password + "&j_username=" + login;
    request.contentType = 'application/x-www-form-urlencoded; charset=UTF-8';

    request.ontimeout = loginViewDoLoginTimeoutCallback;
    request.success   = callbackSuccess;
    request.error     = loginViewDoLoginErrorCallback;

    request.send();

};

function loginViewDoLoginRequestCallback (response, xhr) {

    var formBox = document.querySelector("div.screen[screenname=login] div.formBox");
    var loader   = new Ro.UIComponents.Loader();
    var storage = window.localStorage;
    var appMode = storage.getItem('appMode');

    if (response.targetUrl !== window.hostConf) {
        window.hostConf = response.targetUrl;
        loginViewDoLoginRequest();
    } else {

        window.cookie = xhr.getResponseHeader("set-cookie");

        Globalize.culture(Monet.I18n.locale.language);

        var organizations = new Models.Organization();

        organizations.getByName({
            success: function () {
                GMInitialize.getConfs(function () {

                    window.inProgress   = true;
                    window.beginDate    = Globalize.format (new Date, 'MM/dd/yyyy');
                    window.endDate      = Globalize.format (new Date, 'MM/dd/yyyy');

                    if (serverIsOldVersion()) {

                        Session.appMode = SwitchAppModeUtils.MANAGER_MODE;
                        Manager.goToRouteList();

                    } else {

                        if (appMode) {
                            Manager.goToInitialViewByAppMode(appMode);
                        } else {
                            Manager.goToSwitchAppMode();
                        }

                    }

                    loader.hide();

                });
            }
        });

    }

};

function loginViewDoLoginTimeoutCallback () {

    var formBox  = document.querySelector("div.screen[screenname=login] div.formBox");
    var loader   = new Ro.UIComponents.Loader();

    formBox.style.display = "block";
    loader.hide();

    connectionTimeOut();

};

function loginViewDoLoginErrorCallback (xhr) {

    var formBox  = document.querySelector("div.screen[screenname=login] div.formBox");
    var loader   = new Ro.UIComponents.Loader();

    formBox.style.display = "block";
    loader.hide();

    if (xhr.status === 401) {

        Ro.UIComponents.ToastNotification(
            Monet.I18n.getResourcesByKey('Login.Alert.UserAndPasswordIsInvalid')
        );

    } else {
        GenerictConnectionErroHandler(xhr.status);
    }

};

function loginViewShowMenu () {

    var items = [{
        id: 1,
        text: Manager.I18n.getResourcesByKeyOrAlternative('Login.Menu.ConfigureServerAddress', 'Configure Server Address'),
        action: Manager.goToHostConf
    },{
        id: 2,
        text: Manager.I18n.getResourcesByKeyOrAlternative('Login.Menu.GetLocales', 'Change Language'),
        action: Manager.goToLocaleList
    }];

    Ro.UIComponents.Menu(items, 'login');

}

function logout () {

    var routeList,
        stopList,
        search,
        credentials = {
            login: '',
            password: ''
        };


    var request       = new Ro.Ajax();

    request.url       = window.hostConf + "/logout";
    request.method    = 'get';
    request.ontimeout = loginViewDoLoginTimeoutCallback;

    request.success   = function (response, xhr) {

        window.cookie = xhr.getResponseHeader("set-cookie");

        routeList        = document.getElementById("route_list");
        switch_app_mode  = document.getElementById("switch_app_mode");
        dashboard        = document.getElementById("salesman_dashboard_stops");
        salesStopList    = document.getElementById("salesman_stop_list");
        stopList         = document.getElementById("orders_list");
        search           = document.querySelector("div[screenname='search']");

        delete Ro.Store.data.organization;

        if (routeList) {
            document.body.removeChild(routeList);
        }

        if (stopList) {
            document.body.removeChild(stopList);
        }

        if (search) {
            document.body.removeChild(search);
        }

        if (switch_app_mode) {
            document.body.removeChild(switch_app_mode);
        }

        if (dashboard) {
            document.body.removeChild(dashboard);
        }

        if (salesStopList) {
            document.body.removeChild(salesStopList);
        }

        if (Session.intervalId) {
            clearInterval(Session.intervalId);
        }

        delete Ro.Store.data.route;
        delete Session.appMode;

        window.localStorage.setItem('credentials', JSON.stringify(credentials));

        Manager.goToLogin();

    };

    request.error = loginViewDoLoginErrorCallback;

    request.send();
};

function threatQrCodeSuccessLogin(content){

    var loginJson =  window.UserJsonParamters;
    var login         = document.getElementById("userLogin");
    var password      = document.getElementById("userPassword");

    var contentIsJson = isJson(content);
    if(contentIsJson){
        loginJson = JSON.parse(content);
        window.UserJsonParamters = loginJson;
    }

    login.value = loginJson.login.trim();
    password.value =  loginJson.password.trim();

    if(loginJson.auto === 'true'){
        loginViewDoLoginRequest();
    }
};

function threatQrCodeErrorLogin(i18NResourceError){
    Ro.UIComponents.ToastNotification( Monet.I18n.getResourcesByKey(i18NResourceError));
};