function orderDetail (stop, order) {

    var order_detail_view = new Ro.View('order_detail');

    var goToStopDetail = (function(route, stop, classIcon){
        return function () {
            stopDetail (route, stop, classIcon);
        }
    }(stop.select('route').id, stop, ""));

    var buttonBar   = new Ro.UIComponents.ButtonBar('toolbar_order_detail');
    var search      = new Ro.UIComponents.Button("search");
    var chart       = new Ro.UIComponents.Button("chart");
    var more        = new Ro.UIComponents.Button("more");
    var leftSpacer  = new Ro.UIComponents.Button("leftSpacer");
    var rightSpacer = new Ro.UIComponents.Button("rightSpacer");

    //Header
    order_detail_view.addHeader('Stop Detail');

    order_detail_view.addHeaderButton({
        type: 'leftNav',
        text: 'Stop:' +  stop.getSelection('key'),
        onClick: goToStopDetail
    });

    //Body
    var section   = document.querySelector("div[screenname='order_detail'] section.scroll");

    var screenLayout = new Ro.UIComponents.ScrenLayout.GroupedList([{
        header: {
            title: "Stop Details",
            icon: stopDetail
        },
        items: [{
            label: "On Route",
            content: route.select("key")
        }, {
            label: "Stop Sequence",
            content: stop.select("plannedSequenceNum")
        }, {
            label: "Planned Arrival",
            content: stop.select("plannedArrival")
        }, {
            label: "Projected Arrival",
            content: stop.select("projectedArrival")
        }, {
            label: "",
            content: ""
        }, {
            label: "Planned Size 1",
            content: stop.select("plannedSize1")
        }, {
            label: "Planned Size 2",
            content: stop.select("plannedSize2")
        }, {
            label: "Planned Size 3",
            content: stop.select("plannedSize3")
        }, {
            label: "Planned Pickup 1",
            content: stop.select("plannedPickupSize1")
        }, {
            label: "Planned Pickup 2",
            content: stop.select("plannedPickupSize2")
        }, {
            label: "Planned Pickup 3",
            content: stop.select("plannedPickupSize3")
        }]
    },{
        header: {
            title: "Drivers",
            icon: telLink
        },
        items: [{
            content: route.select("driversName")
        }]
    },{
        header: {
            title: "Address",
            icon: addressIcon
        },
        items: [{
            content: address
        }]
    }]);

    //Footer
    section.appendChild(screenLayout);

    order_detail_view.addFooter();

    search.setIcon('url(images/btn_search_icon.png)');
    chart.setIcon('url(images/btn_dashboard_icon.png)');
    more.setIcon('url(images/btn_more_icon.png)');

    leftSpacer.setFlexWidth(1);
    rightSpacer.setFlexWidth(1);

    buttonBar.addButton(search);
    buttonBar.addButton(leftSpacer);
    buttonBar.addButton(chart);
    buttonBar.addButton(rightSpacer);
    buttonBar.addButton(more);

    buttonBar.addToScreen(order_detail_view, "footer");

    window.AndroidBackButtonInterface = goToStopDetail;

};