var Session = Session || {};
Session.stopId = null;

function ordersListView (stop, routeId) {

    var orders_list_view = new Ro.View('orders_list');
    var orders           = new Models.Order();
    var tb               = new Ro.UIComponents.ButtonBar('toolbarTela1');
    var b                = new Ro.UIComponents.Button("teste");
    var b2               = new Ro.UIComponents.Button("teste");
    var list             = new Ro.UIComponents.ListView();
    var loader           = new Ro.UIComponents.Loader();

    orders.set({stop: {id: stop.id}});

    Session.stopId = stop.id;

    var goToStopDetail = (function (routeId, stop) {
        return function () {
            Manager.goToStopDetail(routeId, stop, "");
        }
    }(routeId, stop));

    var actionHeaderButton = function () {
        loader.hide();
        goToStopDetail();
    };

    orders_list_view.addHeader(
        Monet.I18n.getResourcesByKey('OrderList.Title')
    );

    orders_list_view.addHeaderButton({
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey('StopDetail.Title'),
        onClick: actionHeaderButton
    });

    orders_list_view.addFooter();

    b.setIcon("url(images/btn_search_icon.png)");
    b.setAction(function (){
        Manager.goToSearch({
            text: Monet.I18n.getResourcesByKey('OrderList.Title'),
            action: (function(stop, routeId){
                return function () {
                    Manager.goToOrderList(stop, routeId)
                }
            }(stop, routeId))
        });
    });

    tb.addButton(b);
    b2.setFlexWidth(4);
    tb.addButton(b2);

    tb.addToScreen(orders_list_view, "footer");

    list.dataProvider    = Models.Order;
    list.defaultInfo     = "number";
    list.el.className    = "table_list dark";

    loader.show();

    orders.filter({
        success: function () {

            list.addToScreen(orders_list_view, "section > section");
            var orderListIntensContainer = document.querySelector("#orders_list .table_list.dark");

            orders_list_view.stage.style.height = 'auto';

            loader.hide();

            var orderList = Object.keys(Ro.Store.selectAll('order'));
                  
            if (orderList.length === 0) {
                if (orderListIntensContainer) {
                    orderListIntensContainer.innerHTML = '<div class="listViewItem">' + Monet.I18n.getResourcesByKey('Lists.noRecordFound') + '</div>';
                }
            }

        },

        error: function (xhr) {

            GenerictConnectionErroHandler (xhr.status);
            loader.hide();

        },

        timeout: function () {

            connectionTimeOut();
            loader.hide();

        }

    });

    window.AndroidBackButtonInterface = goToStopDetail;

}

function stopDetailCallMenu (data, classIcon) {

    Manager.goToStopDetail(Session.routeId, data, classIcon);

}