/**
 * Created with IntelliJ IDEA.
 * User: mozartdiniz
 * Date: 7/29/13
 * Time: 5:23 PM
 * To change this template use File | Settings | File Templates.
 */


function routeFilter () {

    var routeFilterView   = new Ro.View('route_filter');
    var organizations     = Ro.Store.selectAll('organization');
    var orgList = document.createElement('select');
    var option = document.createElement('option');
    var inProgressLabel = document.createElement('label');
    var inProgressCheckbox     = document.createElement('input');
    var initialDate       = document.createElement('input');
    var initialDateDiv       = document.createElement('div');
    var initialFragment = document.createDocumentFragment();
    var finalDateDiv       = document.createElement('div');
    var finalDate       = document.createElement('input');
    var finalFragment = document.createDocumentFragment();

    routeFilterView.addHeader(
        Monet.I18n.getResourcesByKey('Route.Filter.Screen.Title')
    );

    var backToRouteList = function () {

        delete Ro.Store.data.route;

        window.firstResult = 0;
        window.beginDate  = document.getElementById('idInitialDate').value;
        window.endDate    = document.getElementById('idFinalDate').value;
        window.inProgress = document.getElementById('inProgressCheckbox').checked;

        var iniForValidation = new Date(window.beginDate);
        var finalForValidation = new Date(window.endDate);

        if (finalForValidation && iniForValidation) {
            if (iniForValidation.getTime() > finalForValidation.getTime()) {
                Ro.UIComponents.ToastNotification(
                    Monet.I18n.getResourcesByKey('FilterRoute.Val.FinalDateMustBeBiggerThatInitial')
                );
            } else {
                Manager.goToRouteList ();
            }
        } else {
            Manager.goToRouteList ();
        }

    };

    var clearFilter = function () {
        inProgressCheckbox.checked = false;
        orgList.value = '';
        window.organizationId = '';
        initialDateDiv.innerHTML = '';
        initialDate.value = '';
        finalDateDiv.innerHTML = '';
        finalDate.value = '';
    };

    routeFilterView.addHeaderButton({
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey('Route.Title'),
        onClick: (function (backToRouteList) {

            return backToRouteList;

        }(backToRouteList))
    });

    routeFilterView.addHeaderButton({
        type: 'rightButton',
        text: '',
        onClick: clearFilter
    });

    orgList.id = 'organizationList';

    option.appendChild(document.createTextNode(''));
    option.value = '';
    orgList.appendChild(option);

    for (key in organizations) {

        var option = document.createElement('option');
        option.appendChild(document.createTextNode(organizations[key].select('description')))
        option.value = organizations[key].select('id');

        if (window.organizationId == organizations[key].select('id')) {
            option.selected = true;
        }

        orgList.appendChild(option);

    }

    orgList.addEventListener('change', function () {
        window.organizationId = orgList.value;
    });

    inProgressLabel.id         = 'inProgressCheckboxLabel';

    inProgressCheckbox.type    = 'checkbox';
    inProgressCheckbox.id      = 'inProgressCheckbox';
    inProgressCheckbox.checked = window.inProgress;

    inProgressLabel.appendChild(inProgressCheckbox);

    initialDate.type      = 'text';
    initialDate.className = 'inputDate';
    initialDate.id        = 'idInitialDate';
    initialDate.readonly  = true;
    initialDate.value     = window.beginDate || '';

    initialDateDiv.id        = 'idInitialDateDisplay';
    initialDateDiv.className = 'inputDate';
    initialDateDiv.innerHTML = window.beginDate || '';

    if(window.beginDate) {
        var initialDateTemDate = new Date(window.beginDate);
        initialDateDiv.innerHTML = Globalize.format(initialDateTemDate, 'd');
    }

    initialFragment.appendChild(initialDate);
    initialFragment.appendChild(initialDateDiv);

    finalDate.type      = 'text';
    finalDate.className = 'inputDate';
    finalDate.id        = 'idFinalDate';
    finalDate.readonly  = true;
    finalDate.value     = window.endDate || '';

    finalDateDiv.id        = 'idInitialDateDisplay';
    finalDateDiv.className = 'inputDate';

    if(window.endDate) {
        var finalDateTemDate = new Date(window.endDate);
        finalDateDiv.innerHTML = Globalize.format(finalDateTemDate, 'd');
    }


    finalFragment.appendChild(finalDate);
    finalFragment.appendChild(finalDateDiv);

    var screenLayout = new Ro.UIComponents.ScrenLayout.GroupedList([{
        header: {
            title: Monet.I18n.getResourcesByKey('Route.Filter.Form.Title')
        },
        items: [{
            label: Monet.I18n.getResourcesByKey('Route.Filter.Form.inProgress'),
            content: inProgressLabel
        }, {
            label: Monet.I18n.getResourcesByKey('Route.Filter.Form.organization'),
            content: orgList
        }, {
            label: Monet.I18n.getResourcesByKey('Route.Filter.Form.initialDate'),
            content: initialFragment
        }, {
            label: Monet.I18n.getResourcesByKey('Route.Filter.Form.finalDate'),
            content: finalFragment
        }]
    }], true);

    routeFilterView.stage.appendChild(screenLayout);

    $("input[type='text'].inputDate").minical({
        trigger: "div.inputDate",
        date_format: function (d, e) {

            var x = new Date(d);

            this.$el[0].nextSibling.innerHTML = Globalize.format(x, 'd');

            return [d.getMonth() + 1, d.getDate(), d.getFullYear()].join("/");

        },
        date_changed: function (d) {
        }
    });


    window.AndroidBackButtonInterface = backToRouteList;

};