var Session = Session || {};
Session.routeListViewMove = false;

function routeListView () {

    var route_list_view = new Ro.View('route_list');
    var noRouteFoundIcon = document.createElement('div'),
        noRouteFoundText = document.createElement('div');

    var tb = new Ro.UIComponents.ButtonBar('toolbarTela1');
    var b  = new Ro.UIComponents.Button("teste");
    var b2  = new Ro.UIComponents.Button("spacer");
    var b3  = new Ro.UIComponents.Button("teste_3");
    var list = new Ro.UIComponents.ListView();
    var loader = new Ro.UIComponents.Loader();
    var lastScrollTop = 0;

    var filterButton = {
        type: 'rightButton',
        text: Monet.I18n.getResourcesByKey('Route.Filter'),
        onClick: Manager.goToRouteFilter
    };

    var actionAppModeButton = function () {

        loader.hide();
        Manager.goToSwitchAppMode();

    };

    var appModeButton = {
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey(SwitchAppModeUtils.TITLE),
        onClick: actionAppModeButton
    };

    var fiatLux = function (data) {

        if (data) {

            if (!data.length && !window.firstResult) {

                noRouteFoundIcon.id = 'noRountFoundIcon';
                noRouteFoundText.id = 'noRouteFoundText';
                noRouteFoundText.innerHTML = Monet.I18n.getResourcesByKey('Route.List.noRouteFound');

                route_list_view.stage.appendChild(noRouteFoundIcon);
                route_list_view.stage.appendChild(noRouteFoundText);

            } else if (data.length) {

                if (!window.firstResult) {

                    var listAlreadyExists = route_list_view.stage.querySelector('.table_list');

                    if (listAlreadyExists) {
                        route_list_view.stage.removeChild(listAlreadyExists);
                    }

                } else {
                    list.el.innerHTML = '';
                }

                list.listItemRender = routeListItemRender;
                list.listItemAction = routeListCallMenu;
                list.dataProvider = Models.Route;

                list.addToScreen(route_list_view, "section > section");
                list.el.scrollTop = lastScrollTop;

                if (Ro.environment.browser.isOldAndroid) {

                    x = document.querySelector("div[screenname='route_list'] section.scroll");
                    x.style.height = 'auto';

                }

                var table_list = document.querySelector("div[screenname='route_list'] section.scroll div.table_list");
                table_list.className = "table_list dark";

            }

        }

        loader.hide();

    };

    var getRoutes = function () {

        loader.show();

        Ro.Store.get('route', {

            success: function (data) {
                fiatLux (data);
            },

            error: function (xhr) {
                fiatLux ();
                GenerictConnectionErroHandler(xhr.status);
            },

            timeout: function () {
                fiatLux ();
                connectionTimeOut();
            }

        });
    };

    var releasePagination = function () {

        var actualScrollTop = this.scrollTop;
        var sumScrollHeight = actualScrollTop + this.offsetHeight;


        if (sumScrollHeight === this.scrollHeight) {

            window.firstResult = list.el.childElementCount;
            lastScrollTop = this.scrollTop;
            getRoutes();

        }

    };

    route_list_view.addHeader(
        Monet.I18n.getResourcesByKey('Route.Title')
    );

    route_list_view.addHeaderButton(filterButton);

    if (!serverIsOldVersion()) {

        route_list_view.addHeaderButton(appModeButton);

    }

    route_list_view.addFooter();

    b.setIcon("url(images/btn_search_icon.png)");
    b.setAction(function (){
        Manager.goToSearch({
            text: Monet.I18n.getResourcesByKey('Route.Title'),
            action: Manager.goToRouteList
        });
    });

    b2.setFlexWidth(3);

    b3.setIcon("url(images/btn_more_icon.png)");
    b3.setAction(logouViewShowMenu);

    tb.addButton(b);
    tb.addButton(b2);
    tb.addButton(b3);

    tb.addToScreen(route_list_view, "footer");

    list.el.removeEventListener('scroll', _.debounce(releasePagination, 300));
    list.el.addEventListener('scroll', _.debounce(releasePagination, 300));

    Ro.Store.data.route = [];

    getRoutes();

    window.AndroidBackButtonInterface = actionAppModeButton;

}

function routeListItemRender(data, itemAction) {

    this.id = data.select('id');

    var row              = document.createElement('div');
    var overflow         = document.createElement('div');
    var menu             = document.createElement('div');
    var button1          = document.createElement('div');
    var button2          = document.createElement('div');
    var itemIcon         = document.createElement('div');
    var itemContent      = document.createElement('div');
    var menuContainer    = document.createElement('div');
    var spanId           = document.createElement('span');
    var routeName        = document.createElement('div');
    var routeDate        = document.createElement('div');
    var routeProgressBar = document.createElement('div');
    var delivered        = document.createElement('div');
    var backLater        = document.createElement('div');
    var returnId         = document.createElement('div');
    var deliveryProgress = document.createElement('div');
    var brZinho          = document.createElement('br');

    var percentCanceled  = data.select('canceledStops') / data.select('totalStops') * 100;
    var percentUndelivered = (data.select('undeliveredStops') + data.select('redeliveredStops')) / data.select('totalStops') * 100;
    var percentDelivered = data.select('actualDepartures') / data.select('totalStops') * 100;
    var totalDone        = data.select('canceledStops') + data.select('undeliveredStops') + data.select('actualDepartures') + data.select('redeliveredStops');

    var totalDonePercent = percentCanceled + percentUndelivered + percentDelivered;

    row.className        = "row";
    row.id               = "row-" + this.id;
    overflow.className   = "overflow";
    menu.className       = "menu";
    button1.className    = "button routeListMaker";
    button2.className    = "button routeListDetails";
    itemIcon.className   = "item icon" + routeListRouteStatusIcon(data.select('status'));
    itemContent.className = "item content";
    menuContainer.className = "menuContainer";
    spanId.style         = "display:none";
    routeName.className  = "routeName";
    routeDate.className  = "routeDate";
    routeProgressBar.className = "routeProgressBar";
    delivered.className  = "delivered";
    backLater.className  = "backLater";
    returnId.className   = "return";
    deliveryProgress.className = "deliveryProgress";
    spanId.style.display = "none";
    spanId.innerHTML     = data.select('id');
    routeName.innerHTML  = data.select('key');
    routeDate.innerHTML  = Globalize.format(Date.create(data.select('date')), Monet.I18n.locale.dateFormat);

    delivered.style.width = percentDelivered + "%";
    backLater.style.width = percentUndelivered + "%";
    returnId.style.width  = percentCanceled + "%";

    if (isNaN(totalDonePercent)) {
        totalDonePercent = 0
    }

    deliveryProgress.innerHTML = totalDone + "/" + data.select('totalStops') + "(" + Math.round(totalDonePercent) +"%)";

    routeProgressBar.appendChild(delivered);
    routeProgressBar.appendChild(backLater);
    routeProgressBar.appendChild(returnId);
    routeProgressBar.appendChild(deliveryProgress);

    menuContainer.appendChild(routeName);
    menuContainer.appendChild(routeDate);
    menuContainer.appendChild(spanId);

    menuContainer.appendChild(routeProgressBar);

    itemContent.appendChild(menuContainer);

    var rDetailClosure = (function(rowId){
        return function (e) {
            routeListDetailsListener(rowId);
        }
    }(this.id));

    var rMarkerClosure = (function(rowId){
        return function (e) {
            routeListMapListener(rowId);
        }
    }(this.id));


    if(Ro.environment.isTouchDevice) {
        if(Ro.environment.isOldAndroid) {
            button2.addEventListener('mousedown', rMarkerClosure);
            button1.addEventListener('mousedown', rDetailClosure);
        } else {
            button2.addEventListener('touchend', rMarkerClosure);
            button1.addEventListener('touchend', rDetailClosure);
        }
    } else {
        button2.addEventListener('click', rMarkerClosure);
        button1.addEventListener('click', rDetailClosure);
    }

    menu.appendChild(button2);
    menu.appendChild(button1);

    overflow.appendChild(menu);

    row.appendChild(overflow);
    row.appendChild(itemIcon);
    row.appendChild(itemContent);

    row.appendChild(brZinho);

    if (typeof itemAction !== 'undefined') {

        if(Ro.environment.isTouchDevice) {
            if(Ro.environment.isOldAndroid) {
                row.addEventListener('mousedown', itemAction);
            } else {
                row.addEventListener('touchstart', routeListCallTouchStartMenu);
                row.addEventListener('touchend', itemAction);
                row.addEventListener('touchmove', routeListCallMovieMenu);
            }
        } else {
            row.addEventListener('click', itemAction);
        }

    }

    this.render = function () {
        return row;
    };

}

function routeListMapListener (rowId) {
    Manager.goToRouteMap(rowId);
}

function routeListDetailsListener (rowId) {
    Manager.goToStopList(rowId);
}

function routeListCallTouchStartMenu () {
    Session.routeListViewMove = false;
}

function routeListCallMovieMenu () {
    Session.routeListViewMove = true;
}

function routeListRouteStatusIcon(routeStatus) {

    switch (routeStatus) {
        case "NOT_STARTED":
            return " not_loaded";
            break;
        case "STARTED":
            return " depart_origin";
            break;
        case "DEPARTED_ORIGIN":
            return " in_route";
            break;
        case "ARRIVED_ORIGIN":
            return " back_to_origin";
            break;
        case "COMPLETED":
            return " completed";
            break;
        default:
            return " not_loaded";
            break;
    }

}

function routeListCallMenu () {

    if (Session.routeListViewMove === false) {

        var activeMenu = document.querySelector(".menuAnime");
        var menu       = this.querySelector(".menu");

        window.global = false;

        if (activeMenu !== null) {
            activeMenu.className = 'menu';
        }

        if (window.global) {

            menu.className = 'menu';

            window.global  = false;

        } else {

            if (menu) {

                menu.className = 'menuAnime';

                window.global = true;

            }
        }

        Session.routeListViewMove = false;

    }

}

function logouViewShowMenu () {

    var items = [{
        id: 1,
        text: Monet.I18n.getResourcesByKey('Route.Menu.Logout'),
        action: function(){
            logout ();
            Android.logOut();
        }
    }];

    Ro.UIComponents.Menu(items, 'route_list');

}