function routeMap (routeId) {

    var route_map_view = new Ro.View('route_map');
    var route 		   = Ro.Store.selectById('route', routeId);

    route_map_view.addHeader(
        Monet.I18n.getResourcesByKey('Route.Title') + ' ' + route.select("key")
    );

    route_map_view.addHeaderButton({
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey('Route.Title'),
        onClick: backToRouteList
    });

    route_map_view.addFooter();

    var tb = new Ro.UIComponents.ButtonBar('route_map_footer');

    var spacer = new Ro.UIComponents.Button("spacer");

    spacer.setFlexWidth(1);

    var b2  = new Ro.UIComponents.Button("Truck");

    b2.setIcon("url(images/truck_disabled.png)");
    b2.setAction(goToTruck);
    tb.addButton(b2);

    var goToStops = (function (routeId) {
        return function () {
            Manager.goToStopList(routeId);
        }
    }(routeId));

    var stopList  = new Ro.UIComponents.Button("StopList");

    stopList.setIcon("url(images/stop_list_btn.png)");
    stopList.setAction(goToStops);
    tb.addButton(stopList);

    tb.addButton(spacer);

    var b  = new Ro.UIComponents.Button("previous");

    b.setIcon("url(images/previous.png)");
	b.setAction(goToPreview);
    tb.addButton(b);

    var b3  = new Ro.UIComponents.Button("Next");

    b3.setIcon("url(images/next.png)");
	b3.setAction(goToNext);
    tb.addButton(b3);

    tb.addToScreen(route_map_view, "footer");

    if(isOldAndroid) {
        var section = document.querySelector("#route_map .scroll");
        section.style.minHeight = window.innerHeight - 130 + "px";
    }

	var mapContainer = document.querySelector("#route_map section section");
	mapContainer.id = "route_map_mapContainer"; 
	mapContainer.style.backgroundColor = "#A5BFDD";
	
	var mapDetailStop = document.getElementById("mapDetailStop");

	App.Routers.MobileMap.show(routeId, "route_map_mapContainer");

    window.AndroidBackButtonInterface = backToRouteList;

}

function backToRouteList () {
	
	var mapDetailStop    = document.getElementById("mapDetailStop");
	var mapDetailStopBtn = document.querySelector(".closeUrgentNotificationPanel");	

	mapDetailStop.style.display = 'none';
	mapDetailStopBtn.style.display = 'none';
	
	Manager.goToRouteList();
}