
SalesmanDashboardStopsUtils = {

    VIEW_NAME: 'salesman_dashboard_stops',
    COLOR_CHART: {
        pending: '#565656',
        canceled: '#FF0000',
        delivered: '#028D02',
        undelivered: '#FF9428'
    },
    TITLE: 'Stop.dashboard'

};

function salesmanDashboardStops() {

    var view = new Ro.View(SalesmanDashboardStopsUtils.VIEW_NAME);
    var buttonsBar = new Ro.UIComponents.ButtonBar('buttonsBar');
    var btnSpacer1 = new Ro.UIComponents.Button('btnSpacer1');
    var btnSpacer2 = new Ro.UIComponents.Button('btnSpacer2');
    var buttonFilter = new Ro.UIComponents.Button('btnFilter');
    var buttonStopsList = new Ro.UIComponents.Button('btnStopsList');
    var buttonMenuMore = new Ro.UIComponents.Button('btnMenuMore');
    var loader = new Ro.UIComponents.Loader();
    var TIME_TO_INTERVAL = 60000;

    var actionHeaderButton = function () {
        loader.hide();
        Manager.goToSwitchAppMode();
    };

    var parseResultRequest = function (result) {

        var data = {
            pending: 0,
            canceled: 0,
            delivered: 0,
            undelivered: 0,
            customers: 0
        };

        if (result.pending) {
            data.pending = result.pending;
        }

        if (result.canceled) {
            data.canceled = result.canceled;
        }
        if (result.delivered) {
            data.delivered = result.delivered;
        }
        if (result.undelivered) {
            data.undelivered = result.undelivered;
        }

        data.customers = data.pending + data.canceled + data.delivered + data.undelivered;

        return data;
    };

    var renderSectionDate = function () {

        var div = document.createElement('div');
        var dateFormat = Monet.I18n.locale.dateFormat;

        div.className = 'date';
        div.innerHTML = Globalize.format(new Date(), Monet.I18n.locale.dateFormat);

        return div;

    };

    var renderSectionCustomerLength = function (lengthCustomers) {

        var div = document.createElement('div');

        div.className = 'customer';
        div.innerHTML = lengthCustomers + ' ' + Monet.I18n.getResourcesByKey('SalesmanDashboardStops.CustomerLength');

        return div;

    };

    var renderSectionLengthStopsByStatus = function (stopsGrouped) {

        var divParent = document.createElement('div');
        var divPendingStops = document.createElement('div');
        var countPendingStops = document.createElement('span');
        var divCanceledStops = document.createElement('div');
        var countCanceledStops = document.createElement('span');
        var divDeliveredStops = document.createElement('div');
        var countDeliveredStops = document.createElement('span');
        var divUndeliveredStops = document.createElement('div');
        var countUndeliveredStops = document.createElement('span');

        countPendingStops.innerHTML = stopsGrouped.pending;
        countPendingStops.className = 'countPendingStops';

        divPendingStops.className = 'statusStops';
        divPendingStops.appendChild(countPendingStops);
        divPendingStops.innerHTML += ' ' + Monet.I18n.getResourcesByKey('SalesmanDashboardStops.pendingStops');

        countCanceledStops.innerHTML = stopsGrouped.canceled;
        countCanceledStops.className = 'countCanceledStops';


        divCanceledStops.className = 'statusStops';
        divCanceledStops.appendChild(countCanceledStops);
        divCanceledStops.innerHTML += ' ' + Monet.I18n.getResourcesByKey('SalesmanDashboardStops.canceledStops');

        countDeliveredStops.innerHTML = stopsGrouped.delivered;
        countDeliveredStops.className = 'countDeliveredStops';

        divDeliveredStops.className = 'statusStops';
        divDeliveredStops.appendChild(countDeliveredStops);
        divDeliveredStops.innerHTML += ' ' + Monet.I18n.getResourcesByKey('SalesmanDashboardStops.deliveredStops');

        countUndeliveredStops.innerHTML = stopsGrouped.undelivered;
        countUndeliveredStops.className = 'countUndeliveredStops';

        divUndeliveredStops.className = 'statusStops';
        divUndeliveredStops.appendChild(countUndeliveredStops);
        divUndeliveredStops.innerHTML += ' ' + Monet.I18n.getResourcesByKey('SalesmanDashboardStops.undeliveredStops');

        divParent.className = 'listStopStatus';
        divParent.appendChild(divPendingStops);
        divParent.appendChild(divCanceledStops);
        divParent.appendChild(divDeliveredStops);
        divParent.appendChild(divUndeliveredStops);

        return divParent;

    };

    var renderSectionChart = function (dataStopsToChart) {

        var div = document.createElement('div');

        div.id = 'chartStops';

        $(div).highcharts({
            chart: {
                type: 'pie',
                backgroundColor: 'transparent',
                borderColor: 'transparent',
                borderWidth: 0,
                height: 220,
                width: 320
            },
            title:{
                text: ''
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                pie: {
                    borderWith: 0,
                    borderColor: 'transparent'
                }

            },
            exporting: {
                enabled: false
            },
            credits: {
                enabled: false
            },
            series: [{
                type: 'pie',
                data: dataStopsToChart,
                innerSize: '60%',
                dataLabels: {
                    enabled: false
                }
            }]
        });

        return div;

    };

    var actionBtnFilter = function () {

        var backButton = {
            text: SalesmanDashboardStopsUtils.TITLE,
              action: Manager.goToSalesmanInitialView
        };

        Manager.goToSearch(backButton);
    };

    var actionBtnMenuMore = function () {
        salesmanBtnMenuMore(SalesmanDashboardStopsUtils.VIEW_NAME, Manager.goToSwitchAppMode);
    };

    var actionBtnStopList = function () {
        Manager.goToSalesmanStopList();
    };

    var renderAfterRequest = function (result) {

        var footer = view.stage.getElementsByTagName('footer')[0];
        var stopsToChart = [{
            name: 'Canceled',
            y: result.canceled,
            color: SalesmanDashboardStopsUtils.COLOR_CHART.canceled
        },{
            name: 'Undelivered',
            y: result.undelivered,
            color: SalesmanDashboardStopsUtils.COLOR_CHART.undelivered
        },{
            name: 'Delivered',
            y: result.delivered,
            color: SalesmanDashboardStopsUtils.COLOR_CHART.delivered
        },{
            name: 'Pending',
            y: result.pending,
            color: SalesmanDashboardStopsUtils.COLOR_CHART.pending
        }];

        var customersDiv = view.stage.querySelector('.customer');
        var listStops = view.stage.querySelector('.listStopStatus');
        var dashboard = view.stage.querySelector('#chartStops');

        if (customersDiv) {
            view.stage.removeChild(customersDiv);
        }

        if (listStops) {
            view.stage.removeChild(listStops);
        }

        if (dashboard) {
            view.stage.removeChild(dashboard);
        }

        loader.hide();

        view.stage.insertBefore(renderSectionCustomerLength(result.customers), footer);
        view.stage.insertBefore(renderSectionLengthStopsByStatus(result), footer);
        view.stage.insertBefore(renderSectionChart(stopsToChart), footer);

    };

    var getInfoStatus = function () {

        var request = new Ro.Ajax();

        request.timeout = 30000;
        request.url =  window.hostConf + '/Stop/Status/PendingRoute/User/' + Monet.Session.User.id;
        request.success = function (data) {

            renderAfterRequest(parseResultRequest(data));

        };

        request.error = function (xhr) {

            var result = {};

            loader.hide();
            renderAfterRequest(parseResultRequest(result));
            GenerictConnectionErroHandler(xhr.status);

        };

        loader.show();
        request.send();

    };

    var registerIntervalToUpdateDashboard = function () {

        var updateDashBoard = function () {
            if (view.el.style.display !== 'none') {
                getInfoStatus();
            }
        };

        if (!Session.intervalId) {
            Session.intervalId = setInterval(updateDashBoard, TIME_TO_INTERVAL);
        }

    };

    view.addHeader(
        Monet.I18n.getResourcesByKey('Sales.Dashboard')
    );

    view.addHeaderButton({
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey(SwitchAppModeUtils.TITLE),
        onClick: actionHeaderButton
    });


    view.stage.appendChild(renderSectionDate());

    view.addFooter();

    buttonFilter.setIcon('url(images/btn_search_icon.png)');
    buttonFilter.setAction(actionBtnFilter);

    buttonStopsList.setIcon('url(images/list_menu_details.png)');
    buttonStopsList.setAction(actionBtnStopList);

    buttonMenuMore.setIcon('url(images/btn_more_icon.png)');
    buttonMenuMore.setAction(actionBtnMenuMore);

    btnSpacer1.setFlexWidth(1);
    btnSpacer2.setFlexWidth(1);

    buttonsBar.addButton(buttonFilter);
    buttonsBar.addButton(btnSpacer1);
    buttonsBar.addButton(buttonStopsList);
    buttonsBar.addButton(btnSpacer2);
    buttonsBar.addButton(buttonMenuMore);

    buttonsBar.addToScreen(view, 'footer');

    getInfoStatus();

    registerIntervalToUpdateDashboard();

    window.AndroidBackButtonInterface = actionHeaderButton;

};
