/**
 * Created by adalto.junior on 21/02/14.
 */

SalesmanStopListUtils = {
    VIEW_NAME: 'salesman_stop_list',
    TITLE: 'Salesman.stopList'
};

function salesmanStopList () {

    var view = new Ro.View(SalesmanStopListUtils.VIEW_NAME);
    var header = document.createElement('header');
    var search = new Ro.UIComponents.SearchBar(Monet.I18n.getResourcesByKey('Search.Placeholder'));
    var buttonsHeader = new Ro.UIComponents.ButtonBar('toolbarStatusStops');
    var buttonsFooter = new Ro.UIComponents.ButtonBar('footerStopList');
    var pendingStops = new Ro.UIComponents.Button('btnPendingStops');
    var undeliverableStops = new Ro.UIComponents.Button('btnUndeliverableStops');
    var completedStops = new Ro.UIComponents.Button('btnCompletedStops');
    var canceledStops = new Ro.UIComponents.Button('btnCompletedStops');
    var btnFilter = new Ro.UIComponents.Button('btnFilter');
    var btnMore = new Ro.UIComponents.Button('btnMore');
    var btnSpacer = new Ro.UIComponents.Button('btnSpacer');
    var loader = new Ro.UIComponents.Loader();
    var list = new Ro.UIComponents.ListView();
    var userId = Monet.Session.User.id;
    var firstStopResult = 0;
    var lastScrollTop = 0;

    var formatFilterStops = function () {

        var criteria = {
                criteriaChain: []
            },
            and = [{
                "attr": 'status',
                "eq": 'DEPARTED_ORIGIN'
            },{
                'or': []
            }],
            or = [{
                "attr": "stops.orders.salesMan.id",
                "eq": userId
            }, {
                "attr": "stops.location.allowedUsers.user.id",
                "eq": userId
            }],
            queryPendingStops = {
                'and':[{
                    attr: 'stops.actualArrival',
                    isNull: true
                },{
                    attr: 'stops.cancelCode.id',
                    isNull: true
                },{
                    attr: 'stops.redeliveryStop.id',
                    isNull: true
                },{
                    attr: 'stops.undeliverableCode.id',
                    isNull: true
                }]
            },
            queryUndeliverableStops = {
                attr: 'stops.undeliverableCode.id',
                isNull: false
            },
            queryCompletedStops = {
                'and':[{
                    attr: 'stops.actualArrival',
                    isNull: false
                },{
                    attr: 'stops.actualDeparture',
                    isNull: false
                },{
                    attr: 'stops.cancelCode.id',
                    isNull: true
                },{
                    attr: 'stops.undeliverableCode.id',
                    isNull: true
                },{
                    attr: 'stops.redeliveryStop.id',
                    isNull: true
                }]
            },
            queryCanceledStops = {
                attr: 'stops.cancelCode.id',
                isNull: false
            };

        if (pendingStops.isSelected()) {
            and[1].or.push(queryPendingStops);
        }

        if (undeliverableStops.isSelected()) {
            and[1].or.push(queryUndeliverableStops);
        }

        if (completedStops.isSelected()) {
            and[1].or.push(queryCompletedStops);
        }

        if (canceledStops.isSelected()) {
            and[1].or.push(queryCanceledStops);
        }

        if (input.value) {

            var index = and.length;

            and[index] = {or :[{
                attr: 'stops.location.key',
                eq: input.value,
                matchMode: 'ANYWHERE'
            },{
                attr: 'stops.location.description',
                eq: input.value,
                matchMode: 'ANYWHERE'
            }]};

        }

        if (and.length) {
            criteria.criteriaChain.push({'and': and});
        }

        if (or.length) {
            criteria.criteriaChain.push({'or': or});
        }

        if (and[1].hasOwnProperty('or') && !and[1].or.length) {
            criteria = null;
        }

        return criteria;

    };

    var showStopList = function () {

        list.el.innerHTML = '';

        list.listItemRender = stopsListViewListRender;
        list.listItemAction = stopListCallMenu;
        list.dataProvider = Models.Stop;

        loader.hide();
        list.el.style.display = 'block';

        list.addToScreen(view, "section > section");
        list.el.scrollTop = lastScrollTop;

    };

    var showOnError = function (xhr) {

        loader.hide();
        GenerictConnectionErroHandler(xhr.status);

    };

    var getStopsByFilter = function () {

        var stops = new Models.Stop(),
        filter = formatFilterStops(),
        filters = {
            filters: [
                "id",
                "key",
                "driverAssignments.*",
                "driverAssignments.driver.name",
                "stops.*",
                "stops.location.locationType.*",
                "stops.location.*",
                "stops.stopType.type",
                "stops.cancelCode.id",
                "stops.redeliveryStop.id",
                "stops.redeliveryStop.location.key",
                "stops.undeliverableCode.key",
                "stops.location.allowedUsers.id",
                "stops.location.allowedUsers.user.id",
                "stops.cancelCode.description",
                "stops.undeliverableCode.description"
            ],
            firstResult: firstStopResult,
            maxResults: 100
        },
        obj = {
            filters: filters,
            data: filter,
            success: showStopList,
            error: showOnError
        };

        if (!firstStopResult) {
            list.el.style.display = 'none';
        }

        loader.show();

        if (filter) {

            stops.filterWithRestrictionsOnRoute(obj);

        } else {

            list.el.innerHTML = '';
            loader.hide();

        }

    };

    var resetFirstStopResultAndGetStopsByFilter = function () {

        firstStopResult = 0;
        lastScrollTop = 0;
        Ro.Store.data.route = [];
        Ro.Store.data.stop = [];

        getStopsByFilter();

    };

    var actionToButtons = function () {

        var divButton = this;
        var className = divButton.className;

        if (className.indexOf('unselected') !== -1) {
            className = className.replace('unselected', ' selected').trim();
        } else if (className.indexOf('selected') !== -1){
            className = className.replace('selected', ' unselected').trim();
        }

        divButton.className = className;

        resetFirstStopResultAndGetStopsByFilter();
    };

    var actionBtnFilter = function () {

        var backButton = {
            text:  Monet.I18n.getResourcesByKey('Stop.Title'),
            action: Manager.goToSalesmanStopList
        };

        Manager.goToSearch(backButton);
    };

    var actionBtnMenuMore = function () {

        var items = [{
            id: 1,
            text: Monet.I18n.getResourcesByKey('Menu.Logout'),
            action: function(){
                logout ();
                Android.logOut();
            }
        },{
            id: 2,
            text: Monet.I18n.getResourcesByKey('Menu.back'),
            action: Manager.goToSalesmanInitialView
        }];

        Ro.UIComponents.Menu(items, SalesmanStopListUtils.VIEW_NAME);
    };

    var releasePagination = function () {

        var actualScrollTop = this.scrollTop;
        var sumScrollHeight = actualScrollTop + this.offsetHeight;

        if (sumScrollHeight === this.scrollHeight) {

            firstStopResult = list.el.childElementCount;
            lastScrollTop = this.scrollTop;
            getStopsByFilter();

        }

    };

    var input = search.querySelector('input');

    pendingStops.setIcon('url(images/pending_stops.png)');
    pendingStops.el.className += ' selected';
    pendingStops.setAction(_.debounce(actionToButtons, 300));

    undeliverableStops.setIcon('url(images/undelivery_stops.png)');
    undeliverableStops.el.className += ' selected';
    undeliverableStops.setAction(_.debounce(actionToButtons, 300));

    completedStops.setIcon('url(images/completed_stops.png)');
    completedStops.el.className += ' selected';
    completedStops.setAction(_.debounce(actionToButtons, 300));

    canceledStops.setIcon('url(images/canceled_stops.png)');
    canceledStops.el.className += ' selected';
    canceledStops.setAction(_.debounce(actionToButtons, 300));

    input.addEventListener('keyup', _.debounce(resetFirstStopResultAndGetStopsByFilter, 600));
    input.removeEventListener('keyup', _.debounce(resetFirstStopResultAndGetStopsByFilter, 600));

    list.el.removeEventListener('scroll', _.debounce(releasePagination, 300));
    list.el.addEventListener('scroll', _.debounce(releasePagination, 300));

    view.stage.appendChild(header);
    view.stage.appendChild(search);

    buttonsHeader.addButton(pendingStops);
    buttonsHeader.addButton(undeliverableStops);
    buttonsHeader.addButton(completedStops);
    buttonsHeader.addButton(canceledStops);

    buttonsHeader.addToScreen(view, 'header');

    view.addFooter();

    btnFilter.setIcon('url(images/btn_search_icon.png)');
    btnFilter.setAction(actionBtnFilter);

    btnMore.setIcon('url(images/btn_more_icon.png)');
    btnMore.setAction(actionBtnMenuMore);

    btnSpacer.setFlexWidth(7);

    buttonsFooter.addButton(btnFilter);
    buttonsFooter.addButton(btnSpacer);
    buttonsFooter.addButton(btnMore);

    buttonsFooter.addToScreen(view, 'footer');

    list.el.className += ' dark';

    resetFirstStopResultAndGetStopsByFilter();

    window.AndroidBackButtonInterface = Manager.goToSalesmanInitialView;

};