/**
 * @author Mozart Diniz <mozart.diniz@gmail.com>
 * Date: 6/16/13
 * Time: 5:55 PM
 */

function searchView (backBtn) {

    var search    = new Ro.View('search');
    var searchBar = new Ro.UIComponents.SearchBar(Monet.I18n.getResourcesByKey('Search.Placeholder'));
    var searchResult = document.createElement('div');
    var input;

    searchResult.className = "searchResult";

    var options = {
        callback: function (value){
            searchRelated (search, value);
            searchRoute (search, value);
        },
        wait: 400,
        captureLength: 1
    };

    search.addHeader(
        Monet.I18n.getResourcesByKey('Search.Title')
    );

    search.addHeaderButton({
        type: 'leftNav',
        text: backBtn.text,
        onClick: backBtn.action
    });

    search.stage.appendChild(searchBar);
    search.stage.appendChild(searchResult);

    if (Ro.environment.browser.isOldAndroid) {

        var sectionScroll = document.querySelector("div[screenname='search'] section.scroll");
        sectionScroll.style.height = 'auto';

    }

    $(".UIComponents-SearchBar input").typeWatch( options );

    $("#search .UIComponents-SearchBar input").focus();

    window.AndroidBackButtonInterface = backBtn.action;

}

function searchRoute (search, value) {

    var scroll        = document.querySelector("#search .scroll");
    var tableList     = document.querySelectorAll("#search .scroll .table_list");
    var h1            = document.querySelectorAll("#search .scroll h1");
    var searchResults = document.querySelector('#search .searchResult');
    var title         = document.createElement('h1');

    title.appendChild(document.createTextNode(
        Monet.I18n.getResourcesByKey('Search.Groups.Routes')
    ));

    searchResults.appendChild(title);

    var list = new Ro.UIComponents.ListView();

    list.listItemRender = routeListItemRender;
    list.listItemAction = routeListCallMenu;

    list.dataProvider = Models.Route;

    list.dataFilter = function (modelName) {

        var routes = Ro.Store.find(modelName, {key: value});

        return routes.slice(0, 5);
    };

    list.addToScreen(search, ".searchResult");

    var table_list = document.querySelector("#search .searchResult div.table_list");
    table_list.className = "table_list dark";
    table_list.style.top = '0';
    table_list.style.bottom = '0';
    table_list.style.paddingBottom = "10px";

}

function searchRelated (search, value) {

    var searchResults = document.querySelector('#search .searchResult');
    var request = new Ro.Ajax();
    var loader = new Ro.UIComponents.Loader();

    request.url = window.hostConf + "/Route/FindRelated?queryParameter=" + value;
    request.success = function (data) {

        loader.hide();

        searchRenderDrivers (data.drivers);
        searchRenderEquipments (data.equipments);
        searchRenderLocations (data.locations);

    };

    request.error = function (xhr) {

        loader.hide();
        GenerictConnectionErroHandler (xhr.status);

    };

    searchResults.innerHTML = "";

    loader.show();
    request.send();

}

function searchRenderDrivers (driversList) {

    var title  = document.createElement('h1');
    var scroll = document.querySelector("#search .searchResult");
    var list   = document.createElement('div');
    var item;

    list.className = "table_list dark";

    if (typeof driversList !== "undefined") {
        for (var i = 0; i < driversList.length; i++) {

            item = document.createElement('div');
            item.className = 'listViewItem';
            item.innerHTML = driversList[i].driver.name;

            item.addEventListener('click', (function(driverItem){

                return function () {

                    var stopsLength = countRouteStops (driverItem.route.id);

                    if (stopsLength > 0) {
                        Manager.goToDriverDetails(driverItem.route.id, driverItem.driver.name);
                    } else {

                        var stops = new Models.Stop();
                        stops.set({route: {id: driverItem.route.id}});

                        var loader           = document.createElement('div');
                        loader.id            = 'screen_loader';
                        loader.className     = 'screen_loader';
                        loader.style.display = 'block';

                        if (!scroll.querySelector('screen_loader')) {
                            scroll.appendChild(loader);
                        }

                        stops.filter({

                            success: function () {

                                scroll.removeChild(loader);

                                Manager.goToDriverDetails(driverItem.route.id, driverItem.driver.name);

                            },

                            error: function (xhr) {

                                GenerictConnectionErroHandler(xhr.status);

                                scroll.removeChild(loader);

                                scroll.innerHTML = "";

                            },

                            timeout: function () {

                                document.body.removeChild(loader);

                                connectionTimeOut();

                                scroll.innerHTML = "";

                            }
                        });

                    }

                }

            }(driversList[i])));

            list.appendChild(item);

        }

        title.appendChild(document.createTextNode(
            Monet.I18n.getResourcesByKey('Search.Groups.Drivers')
        ));

        scroll.appendChild(title);
        scroll.appendChild(list);
    }

}

function searchRenderEquipments (equipmentsList) {

    var title  = document.createElement('h1');
    var scroll = document.querySelector("#search .searchResult");
    var list   = document.createElement('div');
    var item;

    list.className = "table_list dark";

    if (typeof equipmentsList !== "undefined") {
        for (var i = 0; i < equipmentsList.length; i++) {

            item = document.createElement('div');
            item.className = 'listViewItem';
            item.innerHTML = equipmentsList[i].equipment.key;

            item.addEventListener('click', (function(equipItem){

                return function () {

                    var loader           = document.createElement('div');
                    loader.id            = 'screen_loader';
                    loader.className     = 'screen_loader';
                    loader.style.display = 'block';

                    var equipName = "";

                    if (typeof equipItem.equipment.description !== "undefined") {
                        equipName = " - " + equipItem.equipment.description;
                    }

                    if (!scroll.querySelector('screen_loader')) {
                        scroll.appendChild(loader);
                    }

                    $.ajax({
                        url: window.hostConf + "/Route/" + equipItem.route.id + "/Coordinates",
                        type: 'GET',
                        headers: {
                            "Cookie": window.cookie
                        },
                        'contentType' : 'application/json',
                        dataType : 'json',
                        success: function (data) {

                            if (data !== null) {

                                if (data.length > 0) {

                                    lastCoord = data[data.length-1];

                                    scroll.removeChild(loader);

                                    Manager.goToViewOnMap(
                                        lastCoord.position.latitude,
                                        lastCoord.position.longitude,
                                        equipItem.equipment.key + equipName,
                                        {
                                            text: equipItem.equipment.key + equipName,
                                            action: (function(){
                                                return function (){
                                                    Manager.goToSearch({
                                                        text: Monet.I18n.getResourcesByKey('Route.Title'),
                                                        action: Manager.goToRouteList
                                                    });
                                                }
                                            }())
                                        }
                                    );

                                } else {
                                    scroll.removeChild(loader);
                                    Ro.UIComponents.ToastNotification("Map.noCoordinateMessage");
                                }

                            } else {
                                scroll.removeChild(loader);
                                Ro.UIComponents.ToastNotification("Map.noCoordinateMessage");
                            }

                        }
                    })

                }

            }(equipmentsList[i])));

            list.appendChild(item);

        }

        title.appendChild(document.createTextNode(
            Monet.I18n.getResourcesByKey('Search.Groups.Equipments')
        ));

        scroll.appendChild(title);
        scroll.appendChild(list);
    }

}

function searchRenderLocations (locationsList) {

    var title  = document.createElement('h1');
    var scroll = document.querySelector("#search .searchResult");
    var searchResults = document.querySelector('#search .searchResult');
    var list   = document.createElement('div');
    var item, stops;

    list.className = "table_list dark";

    if (typeof locationsList !== "undefined") {
        for (var i = 0; i < locationsList.length; i++) {

            item = document.createElement('div');
            item.className = 'listViewItem';
            item.innerHTML = locationsList[i].location.description;

            item.addEventListener('click', (function(locationItem){
                return function () {

                    locationFound = findStopByLocationId (
                        locationItem.route.id,
                        locationItem.location.id
                    );

                    if(!locationFound) {

                        var stops = new Models.Stop();
                        stops.set({route: {id: locationItem.route.id}});

                        var loader           = document.createElement('div');
                        loader.id            = 'screen_loader';
                        loader.className     = 'screen_loader';
                        loader.style.display = 'block';


                        if (!scroll.querySelector('screen_loader')) {
                            scroll.appendChild(loader);
                        }

                        stops.filter({

                            success: function () {

                                scroll.removeChild(loader);

                                findStopByLocationId (
                                    locationItem.route.id,
                                    locationItem.location.id
                                );

                            },

                            error: function (xhr) {

                                GenerictConnectionErroHandler(xhr.status);

                                scroll.removeChild(loader);

                                searchResults.innerHTML = "";

                            },

                            timeout: function () {

                                scroll.removeChild(loader);

                                connectionTimeOut();

                                searchResults.innerHTML = "";

                            }
                        });

                    }

                }
            }(locationsList[i])));

            list.appendChild(item);

        }

        title.appendChild(document.createTextNode(
            Monet.I18n.getResourcesByKey('Search.Groups.Locations')
        ));

        scroll.appendChild(title);
        scroll.appendChild(list);
    }

}

function findStopByLocationId (routeId, locationId) {

    var stops         = Ro.Store.find('stop', {routeId: routeId});
    var locationFound = false;

    for (var i=0; i < stops.length; i++) {
        if (stops[i].select('location').id === locationId) {

            locationFound = i;

            Manager.goToStopDetail(
                routeId, stops[i]
            );

            break;
        }
    }

    return locationFound;

}

function countRouteStops (routeId) {

    var stops = Ro.Store.find('stop', {routeId: routeId});

    return stops.length;

}