function stopDetail (routeId, stop, classIcon) {

    var routeId = routeId;
    var stop = stop;

    var route;
    var stopDetailPopUp;
    var goToStopList;

    var location          = stop.select("location");
    var latitude          = location.latitude;
    var longitude         = location.longitude;
    var address           = renderAddress(location.addressLine1, location.city, location.country, location.zipCode);
    
    var stopDetailView    = new Ro.View('stop_detail');
    var buttonBar         = new Ro.UIComponents.ButtonBar('toolbar_host_conf');
    var search            = new Ro.UIComponents.Button("search");
    var chart             = new Ro.UIComponents.Button("chart");
    var orderList         = new Ro.UIComponents.Button("order_list");
    var viewStopOnMap     = new Ro.UIComponents.Button("view_stop_on_map");
    var leftSpacer        = new Ro.UIComponents.Button("leftSpacer");
    var rightSpacer       = new Ro.UIComponents.Button("rightSpacer");
    var classIcon         = "stopIcon " + renderStopStatus(stop);
    var iconDiv           = document.createElement('div');
    var customerNameDiv   = document.createElement('div');
    var customerNameText  = document.createElement('div');
    var undeliverableCodeDescription = '';
    var undeliverableCode;
    var cancelCodeDescription = '';
    var cancelCode;

    stopDetailPopUp = new Greenmile.RouteDetail.StopDetailPopup(stop.id, routeId);
    route = Ro.Store.selectById('route', routeId);

    if (Session.appMode === SwitchAppModeUtils.MANAGER_MODE) {

        goToStopList = (function(routeId){
            return function () {
                Manager.backToStopList(routeId);
            };

        })(routeId);

    } else if (Session.appMode === SwitchAppModeUtils.SALESMAN_MODE) {

        goToStopList = Manager.goToSalesmanStopList;

    }

    customerNameDiv.appendChild(iconDiv);
    customerNameDiv.appendChild(customerNameText);

    stopDetailView.stage.appendChild(customerNameDiv);

    stopDetailView.addHeader(
        Monet.I18n.getResourcesByKey('StopDetail.Title')
    );

    stopDetailView.addHeaderButton({
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey('Stop.Title'),
        onClick: goToStopList
    });

    var addressPhone = new Ro.UIComponents.Icon({
        url: "images/phoneToDriver.png"
    });

    var telLink = document.createElement("a");
    telLink.href = "tel:99557744";

    telLink.appendChild(addressPhone);

    var goToOrderList = (function(stop){
        return function () {
            Manager.goToOrderList(stop, Session.routeId);
        }
    }(stop));

    var stopStatusIcon = new Ro.UIComponents.Icon({
        className: classIcon
    });

    var stopDetailIcon = new Ro.UIComponents.Icon({
        url: "images/stopDetail.png",
        action: goToOrderList
    });

    if ( typeof (location.timeWindowType) !== "undefined") {

        if ( typeof (location.timeWindowType.timeWindowTypeDayss) !== "undefined") {

            timeWindow = stopDetailPopUp.getTimeWindow(
                location.timeWindowType.timeWindowTypeDayss
            );

            var timeWindowStructure = timeWindowRender(timeWindow);

        }

    }

    if (typeof timeWindowStructure === 'undefined') {
        timeWindowStructureString = "";
    } else {
        timeWindowStructureString = timeWindowStructure.innerHTML;
    }

    var actualArrival    = stop.select("actualArrival");
    var plannedArrival   = stop.select("plannedArrival");
    var projectedArrival = stop.select("projectedArrival");

    if (actualArrival) {
        actualArrival = Globalize.format(Date.create(stop.select("actualArrival")), Monet.I18n.locale.dateFormat);
        actualArrival += " " + Globalize.format(Date.create(stop.select("actualArrival")), Monet.I18n.locale.timeFormat);
        projectedArrival = "";
    } else {
        actualArrival = "";
    }

    if (plannedArrival) {
        plannedArrival = Globalize.format(Date.create(stop.select("plannedArrival")), Monet.I18n.locale.dateFormat);
        plannedArrival += " " + Globalize.format(Date.create(stop.select("plannedArrival")), Monet.I18n.locale.timeFormat);
    } else {
        plannedArrival = "";
    }

    if (projectedArrival) {
        projectedArrival = Globalize.format(Date.create(stop.select("projectedArrival")), Monet.I18n.locale.dateFormat);
        projectedArrival += " " + Globalize.format(Date.create(stop.select("projectedArrival")), Monet.I18n.locale.timeFormat);
    } else {
        projectedArrival = "";
    }

    cancelCode = stop.select('cancelCode');
    undeliverableCode = stop.select('undeliverableCode');

    if (cancelCode) {
        cancelCodeDescription = cancelCode.description;
    }

    if (undeliverableCode) {
        undeliverableCodeDescription = undeliverableCode.description;
    }

    //Delivery Table

    var deliveryTable = '<table class="deliveryTable" cellspacing="0" cellspacing="0" border="0">';

    deliveryTable += '<tr>';
    deliveryTable += '<th>&nbsp;</th>';
    deliveryTable += '<th>' + Monet.I18n.getResourcesByKey('StopDetail.DeliveryTable.Planned') + '</th>';
    deliveryTable += '<th>' + Monet.I18n.getResourcesByKey('StopDetail.DeliveryTable.Actual') + '</th>';
    deliveryTable += '</tr>';

    var plannedSize1 = stop.select("plannedSize1");
    var plannedSize2 = stop.select("plannedSize2");
    var plannedSize3 = stop.select("plannedSize3");

    var actualSize1 = stop.select("actualSize1");
    var actualSize2 = stop.select("actualSize2");
    var actualSize3 = stop.select("actualSize3");

    var plannedPickupSize1 = stop.select("plannedPickupSize1");
    var plannedPickupSize2 = stop.select("plannedPickupSize2");
    var plannedPickupSize3 = stop.select("plannedPickupSize3");

    var actualPickupSize1 = stop.select("actualPickupSize1");
    var actualPickupSize2 = stop.select("actualPickupSize2");
    var actualPickupSize3 = stop.select("actualPickupSize3");

    deliveryTable += '<tr>';
    deliveryTable += '<td class="sizeAlias">' + Monet.Session.Configurations.size1Alias + '</td>';
    deliveryTable += '<td>' + plannedSize1.toFixed(2) + '</td>';
    deliveryTable += '<td>' + actualSize1.toFixed(2) + '</td>';
    deliveryTable += '</tr>';

    deliveryTable += '<tr>';
    deliveryTable += '<td class="sizeAlias">' + Monet.Session.Configurations.size2Alias + '</td>';
    deliveryTable += '<td>' + plannedSize2.toFixed(2) + '</td>';
    deliveryTable += '<td>' + actualSize2.toFixed(2) + '</td>';
    deliveryTable += '</tr>';

    deliveryTable += '<tr>';
    deliveryTable += '<td class="sizeAlias">' + Monet.Session.Configurations.size3Alias + '</td>';
    deliveryTable += '<td>' + plannedSize3.toFixed(2) + '</td>';
    deliveryTable += '<td>' + actualSize3.toFixed(2) + '</td>';
    deliveryTable += '</tr>';

    deliveryTable += '</table>';

    //Pickup Table

    var pickupTable = '<table class="deliveryTable" cellspacing="0" cellspacing="0" border="0">';

    pickupTable += '<tr>';
    pickupTable += '<th>&nbsp;</th>';
    pickupTable += '<th>' + Monet.I18n.getResourcesByKey('StopDetail.DeliveryTable.Planned') + '</th>';
    pickupTable += '<th>' + Monet.I18n.getResourcesByKey('StopDetail.DeliveryTable.Actual') + '</th>';
    pickupTable += '</tr>';

    pickupTable += '<tr>';
    pickupTable += '<td class="sizeAlias">' + Monet.Session.Configurations.size1Alias + '</td>';
    pickupTable += '<td>' + plannedPickupSize1.toFixed(2) + '</td>';
    pickupTable += '<td>' + actualPickupSize1.toFixed(2) + '</td>';
    pickupTable += '</tr>';

    pickupTable += '<tr>';
    pickupTable += '<td class="sizeAlias">' + Monet.Session.Configurations.size2Alias + '</td>';
    pickupTable += '<td>' + plannedPickupSize2.toFixed(2) + '</td>';
    pickupTable += '<td>' + actualPickupSize2.toFixed(2) + '</td>';
    pickupTable += '</tr>';

    pickupTable += '<tr>';
    pickupTable += '<td class="sizeAlias">' + Monet.Session.Configurations.size3Alias + '</td>';
    pickupTable += '<td>' + plannedPickupSize3.toFixed(2) + '</td>';
    pickupTable += '<td>' + actualPickupSize3.toFixed(2) + '</td>';
    pickupTable += '</tr>';

    pickupTable += '</table>';

    var screenLayout = new Ro.UIComponents.ScrenLayout.GroupedList([{
        header: {
            title: location.key + " - " + stop.select("location").description,
            icon: stopStatusIcon
        },
        items: [{
            content: " "
        }]
        },{
        header: {
                title: Monet.I18n.getResourcesByKey('StopDetail.Headers.CancelCodeDescription')
            },
            items: [{
                content: cancelCodeDescription
            }]
        },{
        header: {
                title: Monet.I18n.getResourcesByKey('StopDetail.Headers.UndeliverableCodeDescription')
            },
            items: [{
                content: undeliverableCodeDescription
            }]
        },{
        header: {
            title: Monet.I18n.getResourcesByKey('StopDetail.Headers.DeliveryTable')
        },
        items: [{
            content: deliveryTable
        }]
        },{
        header: {
            title: Monet.I18n.getResourcesByKey('StopDetail.Headers.PickupTable')
        },
        items: [{
            content: pickupTable
        }]
        }, {
        header: {
            title: Monet.I18n.getResourcesByKey('StopDetail.Headers.StopDetails')
        },
        items: [{
            label: Monet.I18n.getResourcesByKey('StopDetail.Items.OnRoute'),
            content: route.select("key")
        }, {
            label: Monet.I18n.getResourcesByKey('StopDetail.Items.StopSequence'),
            content: stop.select("plannedSequenceNum")
        }, {
            label: Monet.I18n.getResourcesByKey('StopDetail.Items.PlannedArrival'),
            content: plannedArrival
        }, {
            label: Monet.I18n.getResourcesByKey('StopDetail.Items.ProjectedArrival'),
            content: projectedArrival
        }, {
            label: Monet.I18n.getResourcesByKey('StopDetail.Items.ActualArrival'),
            content: actualArrival
        }, {
            label: "",
            content: ""
        }, {
            label: "",
            content: ""
        }]
    }, {
        header: {
            title: Monet.I18n.getResourcesByKey('StopDetail.Headers.Phones')
        },
        items: [{
            content: phoneRender(Monet.I18n.getResourcesByKey('StopDetail.Items.Phone1'), location.phone1) + phoneRender(Monet.I18n.getResourcesByKey('StopDetail.Items.Phone2'), location.phone2)
        }]
    },{
        header: {
            title: Monet.I18n.getResourcesByKey('StopDetail.Headers.Drivers')
        },
        items: [{
            content: '<div id="driversContainer-'+routeId+'"><div class="screen_loader_inline"></div></div>'
        }]
    },{
        header: {
            title: Monet.I18n.getResourcesByKey('StopDetail.Headers.Address')
        },
        items: [{
            content: address
        }]
    },{
        header: {
            title: Monet.I18n.getResourcesByKey('StopDetail.Headers.TimeWindow')
        },
        items: [{
            content: timeWindowStructureString
        }]
    }], true);

    stopDetailView.stage.appendChild(screenLayout);

    getDriversList (routeId);

    stopDetailView.addFooter();

    search.setIcon('url(images/btn_search_icon.png)');
    chart.setIcon('url(images/btn_dashboard_icon.png)');
    orderList.setIcon('url(images/btn_order_icon.png)');
    viewStopOnMap.setIcon('url(images/btn_map_icon.png)');

    search.setAction(function (){
        Manager.goToSearch({
            text: Monet.I18n.getResourcesByKey('StopDetail.Title'),
            action: (function(routeId, stop, classIcon){
                return function () {
                    Manager.goToStopDetail(routeId, stop, classIcon)
                }
            }(routeId, stop, classIcon))
        });
    });

    var chartCallback = (function (stop, routeId){
        return function () {
            Manager.goToCustomerStatistic(stop, routeId);
        }
    }(stop, routeId));
    
    var viewStopOnMapCallback = (function (latitude, longitude, address, routeId, stop, classIcon) {
        return function () {
             Manager.goToViewOnMap(latitude, longitude, address, {
                   text: Monet.I18n.getResourcesByKey('StopDetail.Title'),
                   action: (function(routeId, stop, classIcon){
                        return function () {
                                Manager.goToStopDetail(routeId, stop, classIcon)
                            }
                        }(routeId, stop, classIcon))
                   })
             }
     }(latitude, longitude, address, routeId, stop, classIcon))
    
    viewStopOnMap.setAction(viewStopOnMapCallback);
    chart.setAction(chartCallback);
    orderList.setAction(goToOrderList);
    
    buttonBar.addButton(search);
    buttonBar.addButton(orderList);
    buttonBar.addButton(viewStopOnMap);    
    buttonBar.addButton(chart);

    buttonBar.addToScreen(stopDetailView, "footer");

    window.AndroidBackButtonInterface = goToStopList;

};

function timeWindowRender (timeWindow) {

    var daysDiv, timesDiv, openClose, openCloseDiv, timeWindowDiv, times,
        openTimeLabel, timesLabel;

    var fragment = document.createElement('div');

    for (var i=0; i < timeWindow.length; i++) {

        timeWindowDiv = document.createElement('div');
        timesDiv      = document.createElement('div');
        openCloseDiv  = document.createElement('div');
        daysDiv       = document.createElement('div');

        daysDiv.className = "timeWindowDays";
        openCloseDiv.className = "timwWindowOpenClose";
        timesDiv.className = "timeWindowTimes";

        daysText = "";

        for (var day = 0; day < timeWindow[i].days.length; day++) {

            daysText += "(" + Monet.I18n.getResourcesByKey(
                timeWindow[i].days[day]
            ) + ") "

        }

        daysDiv.innerHTML = daysText;

        openTimeLabel = document.createElement("label");
        timesLabel    = document.createElement("label");

        openTimeLabel.innerHTML = Monet.I18n.getResourcesByKey(
            "TimeWindow.openCloseLabel"
        );

        timesLabel.innerHTML    = Monet.I18n.getResourcesByKey(
            "TimeWindow.times"
        );

        openClose     = document.createTextNode(timeWindow[i].openClose);
        times         = document.createTextNode(timeWindow[i].timeWindow);

        openCloseDiv.appendChild(openTimeLabel);
        timesDiv.appendChild(timesLabel);

        openCloseDiv.appendChild(openClose);
        timesDiv.appendChild(times);

        timeWindowDiv.appendChild(daysDiv);
        timeWindowDiv.appendChild(openCloseDiv);
        timeWindowDiv.appendChild(timesDiv);

        fragment.appendChild(timeWindowDiv);

    }

    return fragment;

}

function getDriversList (routeId) {

    var request = new Ro.Ajax();

    request.url    = window.hostConf + '/Route/filter?criteria={"filters":["driverAssignments.driver.name", "driverAssignments.driver.phone1", "driverAssignments.driver.phone2"]}';
    request.data   = '{"id":' + routeId + '}';
    request.method = 'post';
    request.success = function (data) {
        driverListRender(data, routeId);
    };

    request.send();

}

function driverListRender (driverList, routeId) {

 var drivers;

 var driverListDiv = document.createElement('div');
 var driverListContainer = document.getElementById("driversContainer-" + routeId);
 var fatherDiv = driverListContainer.parentNode.parentNode;
 var fatherHeader = fatherDiv.previousSibling;

 var driverItemDiv, driverItemLabelDiv, driverItemValueDiv, phone1, phone2,
     phone1Ico, phone2Ico, lineItem1, lineItem2, phone1Link, phone2Link;

    if (driverList.length) {
        drivers = driverList[0].driverAssignments
    }

    if (drivers) {

        for (var i=0; i < drivers.length; i++) {

            lineItem1 = document.createElement('div');
            lineItem2 = document.createElement('div');

            lineItem1.className = "driverLineItem";
            lineItem2.className = "driverLineItem";

            driverItemDiv = document.createElement('div');
            driverItemDiv.className = "ScrenLayout-GroupedList-lineItemRender";

            driverItemLabelDiv = document.createElement('div');
            driverItemLabelDiv.className = "ScrenLayout-contentHeader";

            driverItemValueDiv = document.createElement('div');
            driverItemValueDiv.className = "ScrenLayout-contentElement";

            driverItemLabelDiv.innerHTML = drivers[i].driver.name;

            phone1 = document.createElement('div');
            phone2 = document.createElement('div');

            phone1.className = "driverPhoneText";
            phone2.className = "driverPhoneText";

            phone1Ico = document.createElement('div');
            phone2Ico = document.createElement('div');

            phone1Link = document.createElement('a');
            phone2Link = document.createElement('a');

            phone1Link.href = "tel:" + drivers[i].driver.phone1;
            phone2Link.href = "tel:" + drivers[i].driver.phone2;

            phone1Ico.className = "UIComponents-Icon driverPhoneIco";
            phone2Ico.className = "UIComponents-Icon driverPhoneIco";

            phone1Ico.style.backgroundImage = 'url(images/phoneToDriver.png)';
            phone2Ico.style.backgroundImage = 'url(images/phoneToDriver.png)';

            phone1Link.appendChild(phone1Ico);
            phone2Link.appendChild(phone2Ico);

            phone1.innerHTML = drivers[i].driver.phone1;
            phone2.innerHTML = drivers[i].driver.phone2;

            if (typeof drivers[i].driver.phone1 !== "undefined") {
                lineItem1.appendChild(phone1);
                lineItem1.appendChild(phone1Link);
            }

            if (typeof drivers[i].driver.phone2 !== "undefined") {
                lineItem2.appendChild(phone2);
                lineItem2.appendChild(phone2Link);
            }

            if (typeof drivers[i].driver.phone1 !== "undefined" && typeof drivers[i].driver.phone2 !== "undefined") {
                driverItemValueDiv.appendChild(lineItem1);
                driverItemValueDiv.appendChild(lineItem2);

                driverItemDiv.appendChild(driverItemLabelDiv);
                driverItemDiv.appendChild(driverItemValueDiv);
                driverListDiv.appendChild(driverItemDiv);
            } else {
                fatherDiv.style.display = "none";
                fatherHeader.style.display = "none";
            }

        }

    } else {
        fatherDiv.style.display = "none";
        fatherHeader.style.display = "none";
    }

    driverListContainer.innerHTML = "";
    driverListContainer.appendChild(driverListDiv);

}

function phoneRender (label, phone) {

    if (typeof phone !== 'undefined') {

        var phoneItemDiv      = document.createElement('div');
        var phoneItemHeader   = document.createElement('div');
        var phoneItemContent  = document.createElement('div');
        var phoneItemIconLink = document.createElement('a');
        var phoneItemIcon     = document.createElement('div');

        phoneItemHeader.innerHTML = label;
        phoneItemHeader.className = "ScrenLayout-contentHeader locationPhoneHeader";

        phoneItemIconLink.href = "tel: " + phone;

        phoneItemIcon.className =  "UIComponents-Icon locationPhoneIco";
        phoneItemIcon.style.backgroundImage = 'url(images/phoneToDriver.png)';

        phoneItemIconLink.appendChild(phoneItemIcon);

        phoneItemContent.className = "locationPhoneText";
        phoneItemContent.innerHTML = phone;

        phoneItemDiv.appendChild(phoneItemHeader);
        phoneItemDiv.appendChild(phoneItemContent);
        phoneItemDiv.appendChild(phoneItemIconLink);

        return phoneItemDiv.innerHTML;
    }

    return "";

}

function renderAddress(addressLine1, city, country, zipCode) {

    var addressString = "";

    if (typeof addressLine1 !== 'undefined') {
        addressString += addressLine1 + ", ";
    }

    if (typeof city !== 'undefined') {
        addressString += city + ", ";
    }

    if (typeof country !== 'undefined') {
        addressString += country + ", ";
    }

    if (typeof zipCode !== 'undefined') {
        addressString += zipCode;
    }

    return addressString;

}