var Session = Session || {};
Session.routeId = null;
Session.stopListViewMove = false;

function stopsListView (routeId) {

    var stops_list_view = new Ro.View('stops_list');
    var stops = new Models.Stop();
    var route = Ro.Store.selectById('route', routeId);
    var tb = new Ro.UIComponents.ButtonBar('toolbarTela1');
    var b  = new Ro.UIComponents.Button("teste");
    var b2  = new Ro.UIComponents.Button("teste");
    var loader = new Ro.UIComponents.Loader();

    var actionLeftButton = function () {
        loader.hide();
        Manager.goToRouteList();
    };

    var leftButton = {
        type: 'leftNav',
        text: Monet.I18n.getResourcesByKey('Route.Title'),
        onClick: actionLeftButton
    };

    stops.set({route: {id: routeId}});
    Session.routeId = routeId;

    if (Session.appMode === SwitchAppModeUtils.SALESMAN_MODE) {

        leftButton.text = Monet.I18n.getResourcesByKey(SalesmanStopListUtils.TITLE);
        leftButton.onClick = Manager.goToSalesmanStopList;

    }

    stops_list_view.addHeader(
        Monet.I18n.getResourcesByKey('Stop.Title.Route') + " " + route.select("key")
    );

    stops_list_view.addHeaderButton(leftButton);

    stops_list_view.addFooter();

    var goToRouteListClosure = (function(routeId){

        return function () {

            removeStopLoader();

            Manager.goToStopList(routeId)
        }
    }(routeId));

    b.setIcon("url(images/btn_search_icon.png)");
    b.setAction(function (){
        Manager.goToSearch({
            text: Monet.I18n.getResourcesByKey('Stop.Title'),
            action: goToRouteListClosure
        });
    });

    tb.addButton(b);

    b2.setFlexWidth(4);
    tb.addButton(b2);

    tb.addToScreen(stops_list_view, "footer");

    //List
    var list = new Ro.UIComponents.ListView();
    list.listItemRender = stopsListViewListRender;
    list.listItemAction = stopListCallMenu;

    loader.show();

    list.dataProvider = Models.Stop;
    list.dataFilter   = function () {
        return Ro.Store.find('stop', {routeId: routeId})
    };

    var fiatLux = function () {

        list.addToScreen(stops_list_view, "section > section");

        table_list = document.querySelector("div[screenname='stops_list'] section.scroll div.table_list");
        table_list.className = "table_list dark";

        section_scroll = document.querySelector("div[screenname='stops_list'] section.scroll");
        section_scroll.style.height = 'auto';

        removeStopLoader();
    };

    stops.filter({

        success: function () {

            fiatLux ();

        },

        error: function (xhr) {

            fiatLux ();

            GenerictConnectionErroHandler(xhr.status);

        },

        timeout: function () {

            fiatLux ();

            connectionTimeOut();

        }
    });

}

function stopsListViewListRender (data, itemAction) {

    this.id = data.select('id');

    var key        = '',
        locationDescription = "",
        mainInfoContent = "",
        secondInfoText = "",
        location   = data.select('location'),
        item       = document.createElement('div'),
        icon       = document.createElement('div'),
        mainInfo   = document.createElement('div'),
        secondInfo = document.createElement('div');
        driverName = document.createElement('div');

    var routeId     = data.select('routeId');
    var route       = Ro.Store.selectById('route', routeId);
    var dNameString = route.select('driversName');

    if (location) {

        key = location.key;

        locationDescription = location.description;

        if (location.addressLine1) {
            secondInfoText += location.addressLine1;
        }

        if (location.zipCode) {
            secondInfoText += ", " + location.zipCode;
        }

        if (location.city) {
            secondInfoText += ", " + location.city;
        }

    }

    mainInfoContent = document.createTextNode(key + " - " + locationDescription);

    var secondInfoContent = document.createTextNode(secondInfoText);
    var classIcon         = renderStopStatus(data);

    icon.className       = "stopIcon " + classIcon;
    mainInfo.className   = "mainStopInfo";
    secondInfo.className = "secondStopInfo";
    driverName.className = "secondStopInfo";

    mainInfo.appendChild(mainInfoContent);
    secondInfo.appendChild(secondInfoContent);

    item.appendChild(icon);
    item.appendChild(mainInfo);
    item.appendChild(secondInfo);

    if (dNameString) {
        driverName.innerHTML = dNameString.replace(/\[null\]/g, "");
        item.appendChild(driverName);
    }

    item.className = 'listViewItem';

    if (itemAction) {

        var callback = (function(data, routeId, classIcon){
            return function () {
                itemAction(data, classIcon);
            }
        })(data, Session.routeId, classIcon);

        if(Ro.environment.isTouchDevice) {
            if(Ro.environment.isOldAndroid) {
                item.addEventListener('mousedown', callback);
            } else {
                item.addEventListener('touchstart', stopListCallTouchStartMenu);
                item.addEventListener('touchend', callback);
                item.addEventListener('touchmove', stopListCallMovieMenu);
            }
        } else {
            item.addEventListener('click', callback);
        }
    }

    this.render = function () {
        return item;
    };

}

function renderStopStatus (stop) {

    var stopType = stop.select("stopType").type;
    var icon     = "";
    var redeliveryStop, cancelCode, undeliverableCode, location, actualArrival, actualDeparture;

    redeliveryStop    = stop.select("redeliveryStop");

    if (typeof redeliveryStop !== "undefined") {
        redeliveryStop = redeliveryStop.location;
    }

    cancelCode = stop.select("cancelCode");

    if (typeof cancelCode !== "undefined") {
        cancelCode = cancelCode.id;
    }

    undeliverableCode = stop.select("undeliverableCode");

    if (typeof undeliverableCode !== "undefined") {
        undeliverableCode = undeliverableCode.key;
    }

    location          = stop.select("location");
    actualArrival     = stop.select("actualArrival");
    actualDeparture   = stop.select("actualDeparture");

    if(stopType == "STOP") {

        if(typeof(redeliveryStop) !== "undefined" ){
            icon = "stopRedeliveryStop";
        } else {
            if(typeof(cancelCode) !== "undefined"){
                icon = "stopCancel";
            } else {
                if(typeof(undeliverableCode) !== "undefined"){
                    icon = "stopUndeliverable";
                } else {
                    if(typeof(actualArrival) !== "undefined" && typeof(actualDeparture) !== "undefined") {
                        icon = "stopComplete";
                    } else {
                        icon = "stopPending";
                    }

                }
            }
        }

    } else {
        icon = stopType;
    }

    return icon;

}

function stopListCallTouchStartMenu () {
    Session.stopListViewMove = false;
}

function stopListCallMovieMenu () {
    Session.stopListViewMove = true;
}

function stopListCallMenu (data, classIcon) {

    if (!Session.stopListViewMove) {

        if (!Session.routeId) {
            Session.routeId = data.select('routeId');
        }

        Manager.goToStopDetail(Session.routeId, data, classIcon);

        Session.stopListViewMove = false;

    }
}

function removeStopLoader () {

    var loader = new Ro.UIComponents.Loader();

    loader.hide();

}