
SwitchAppModeUtils = {
    VIEW_NAME: 'switch_app_mode',
    TITLE: 'SwitchAppMode.title',
    MANAGER_MODE: 'MANAGER',
    SALESMAN_MODE: 'SALESMAN'
};

function switchAppMode() {

    var appMode = new Ro.View(SwitchAppModeUtils.VIEW_NAME);
    var headerResource = Monet.I18n.getResourcesByKey(SwitchAppModeUtils.TITLE);
    var buttonsFooter = new Ro.UIComponents.ButtonBar('toolbarSwitchAppMode');
    var btnLogout = new Ro.UIComponents.Button('btn_logout');
    var btnSpacer = new Ro.UIComponents.Button('btnSpacer');
    var divContent = document.createElement('div');
    var storage = window.localStorage;

    var showRouteList = function () {

        storage.setItem('appMode', SwitchAppModeUtils.MANAGER_MODE);
        Manager.goToInitialViewByAppMode(SwitchAppModeUtils.MANAGER_MODE);

    };

    var showSalesmanInitialView = function () {

        storage.setItem('appMode', SwitchAppModeUtils.SALESMAN_MODE);
        Manager.goToInitialViewByAppMode(SwitchAppModeUtils.SALESMAN_MODE);

    };

    var createRouteSectionMode = function () {

        var div = document.createElement('div');
        var divText = document.createElement('div');

        div.className = 'switchAppMode managerRoutes';
        divText.innerHTML = Monet.I18n.getResourcesByKey('Manager.item.managerRoute');

        div.appendChild(divText);

        div.removeEventListener('click', showRouteList, true);
        div.addEventListener('click', showRouteList, true);

        return div;

    };

    var createSalesmanSectionMode = function () {

        var div = document.createElement('div');
        var divText = document.createElement('div');

        div.className = 'switchAppMode managerSalesman';
        divText.innerHTML = Monet.I18n.getResourcesByKey('Manager.item.managerSalesman');

        div.removeEventListener('click', showSalesmanInitialView, true);
        div.addEventListener('click', showSalesmanInitialView, true);

        div.appendChild(divText);

        return div;

    };

    var moreMenu = function () {

        var items = [{
            id: 1,
            text: Manager.I18n.getResourcesByKeyOrAlternative('Login.Menu.ConfigureServerAddress', 'Configure Server Address'),
            action: Manager.goToHostConf
        }, {
            id: 2,
            text: Monet.I18n.getResourcesByKey('Menu.Logout'),
            action: function(){
                logout ();
                Android.logOut();
            }
        }];

        Ro.UIComponents.Menu(items, SwitchAppModeUtils.VIEW_NAME);

    };

    appMode.addHeader(headerResource);
    appMode.addFooter();

    btnLogout.setIcon("url(images/btn_more_icon.png)");
    btnLogout.setAction(moreMenu);

    btnSpacer.setFlexWidth(7);

    buttonsFooter.addButton(btnSpacer);
    buttonsFooter.addButton(btnLogout);

    buttonsFooter.addToScreen(appMode, "footer");

    divContent.className = 'table_list dark';

    divContent.appendChild(createRouteSectionMode());
    divContent.appendChild(createSalesmanSectionMode());

    appMode.stage.appendChild(divContent);

};

var salesmanBtnMenuMore = function (viewName) {

    var items = [{
        id: 1,
        text: Manager.I18n.getResourcesByKeyOrAlternative('Login.Menu.ConfigureServerAddress', 'Configure Server Address'),
        action: Manager.goToHostConf
    },{
        id: 2,
        text: Monet.I18n.getResourcesByKey('Menu.Logout'),
        action: function(){
            logout ();
            Android.logOut();
        }
    }];

    Ro.UIComponents.Menu(items, viewName);
};