function viewOnMap (lat, long, text, backBtn) {

    var view_on_map_view = new Ro.View('view_on_map');

    view_on_map_view.addHeader(
        Monet.I18n.getResourcesByKey('Map.Title')
    );

    view_on_map_view.addHeaderButton({
        type: 'leftNav',
        text: backBtn.text,
        onClick: backBtn.action
    });

    if (Ro.environment.browser.isOldAndroid) {

        adjustSize = document.querySelector("div.screen[screenname=view_on_map] section.scroll");
        adjustSize.style.height = (window.innerHeight-44) + 'px';

    }

    var mapContainer = document.querySelector("#view_on_map section section");
    mapContainer.id = "view_on_map_mapContainer";
    mapContainer.style.backgroundColor = "#A5BFDD !important";

    CreateMap("view_on_map_mapContainer", {
        center : [lat, long],
        zoom : 18,
        crs: L.CRS.EPSG4326,
        zoomAnimation: false,
        markerZoomAnimation: false,
        zoomsliderControl: false,
        popUpText: text
    });

    window.AndroidBackButtonInterface = backBtn.action;

}

function backToRouteList () {

    var mapDetailStop    = document.getElementById("mapDetailStop");
    var mapDetailStopBtn = document.querySelector(".closeUrgentNotificationPanel");

    mapDetailStop.style.display = 'none';
    mapDetailStopBtn.style.display = 'none';

    Manager.goToRouteList();
}