/**
 * @author Adalto Junior adaltojunior@sagaranatech.com
 * DATE 16/01/2013
 *  Time: 09:00
 */

var Greenmile = Greenmile || {};
Greenmile.Calculos = Greenmile.Calculos || {};

Greenmile.Calculos.GeneralFunctions = function (){
		
	this.calculateAverageSpeed = function (distanceInMetters, timeInMillis){
				
		var unitSystem = Monet.Session.User.unitSystem;
		var unitSystemStr =  Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.kilometersPerHour");
    	var averageSpeed = 0;
    	
    	if(typeof(distanceInMetters !== "undefined") && typeof(timeInMillis !== "undefined")){
    		
    		if(distanceInMetters != 0 && timeInMillis != 0){
    			
            	var time	 = timeInMillis / 3600000;
            	var distance = 0;
             	            	
            	if(unitSystem == "NON_METRIC" ){

            		distance  = this.convertMettersToMilles(distanceInMetters);

            	}else{

            		distance = this.convertMettersToKilometters(distanceInMetters);

            	}
            	
            	averageSpeed = distance / time;
            	averageSpeed.toFixed(2);

    		}
    	}
    	
    	if(unitSystem == "NON_METRIC" ){
    		unitSystemStr =  Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.milesPerHour");        		
    	}	
    	
    	return Globalize.format(averageSpeed, "n2") + " "+ unitSystemStr;

    	
    };
    
    this.convertKilometersToMilles = function (killometers){
    	
    	var milles = 0;
    	
    	if(typeof(killometers) !== "undefined"){

    		milles = new BigInt(killometers) * 0.62137;
    		milles = milles.toFixed(2);
    	
    	}
    	
    	return Globalize.format(milles, "n2");

    };
    
    this.convertMettersToFeets = function (metters){
    	
    	var feets = 0;
    	
    	if(typeof(metters) !== "undefined"){
    		feets = metters * 3.2808;
    	}
    	
    	return feets.toFixed(2);
    		
    };
    
    this.convertMettersToKilometters = function(metters){
    	
    	var kilometters = 0;
    	
    	if(typeof(metters) !== "undefined"){
    		kilometters = metters / 1000;
    	}
    	
    	return kilometters.toFixed(2);
    	
    };
    
    this.convertMettersToMilles = function(metters){
    	
    	var milles = 0;
    	
    	if(typeof(metters) !== "undefined"){
    		
    		milles = new BigInt(metters) * 0.00062137;
    		milles = milles.toFixed(2);

    	}
    	
    	return Globalize.format(milles, "n2");
    	
    };
    
    this.convertFeetToMetters = function(feets){
    	
    	var metters = 0;
    	
    	if(typeof(metters) !== "undefined"){
    		metters	 = feets / 3.2808;
    	}
    	
    	return metters.toFixed(2);
    	
    };
    
    this.formatDistanceTotal = function(metters){
    	  	    	
    	try {
    		
        	var result = 0;
    		var unitSystemStr = "";
        	var unitSystem = Monet.Session.User.unitSystem;

    		if(typeof metters !== "undefined"){
    			
    			if(unitSystem == "METRIC"){
    				
    				result = this.convertMettersToKilometters(metters);
    				unitSystemStr =  Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.kilometers");
    				
    			}else{
    				
    				result = this.convertMettersToMilles(metters);
    				unitSystemStr =  Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.miles");
    				
    			}
    			
    		}

    		return result + " "+ unitSystemStr;

		} catch (e) {
			
			var error = new Monet.Exception.ReturnError(this, "Error on format distance total.");
			error.console();
		
		}
    };
    
    this.getUnitSystemToColumnGrid = function(){
    	
    	var unitSystem = Monet.Session.User.unitSystem;
    	var strUnitySystem = "";
    	
    	if(unitSystem == "METRIC"){
    		strUnitySystem =  Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.kilometers");
    	}else{
    		strUnitySystem =  Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.miles");
    	}
    	
    	return strUnitySystem;

    };
    
    this.getUnitySystemMettersOrFeets = function(){
    	
    	var unitSystem = Monet.Session.User.unitSystem;
    	var strUnitySystem = "";
    	
    	if(unitSystem == "METRIC"){
    		strUnitySystem =  Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.meters");
    	}else{
    		strUnitySystem =  Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.feet");
    	}
    	
    	return strUnitySystem;
    	
    };
    
    this.formatDistanceOnKmOrMilles = function(metters){
    	
    	var unitSystem = Monet.Session.User.unitSystem;
    	var value = 0;
    	
    	if(typeof(metters) != "undefined"){
    		
        	if(unitSystem == "METRIC"){
        		value =  this.convertMettersToKilometters(metters);
        	}else{
        		value =  this.convertMettersToMilles(metters);
        	}
    		
    	}
    	
    	return value;
    }
};