/**
 * @author Fabio Junior fabiojunior@sagaranatech.com DATE 18/01/2013 Time: 17:20
 * 
 * @author Daniel Laurindo daniellaurindo@sagaranatech.com DATE 21/05/2013 Time: 09:59
 */

var Greenmile = Greenmile || {};
Greenmile.Date = Greenmile.Date || {};

Greenmile.Date.GeneralFunctions = function () {

	this.validateDate = function (dateInitial, dateFinal) {
		
		var monetFormat = Monet.I18n.locale.dateFormat + " " + Monet.I18n.locale.timeFormat;
		var timeInitial, timeFinal;

		if (dateInitial !== "" && dateFinal !== "") {

			timeInitial = new Date(moment(dateInitial, monetFormat)._d).getTime();
			timeFinal   = new Date(moment(dateFinal, monetFormat)._d).getTime();

			if (timeFinal < timeInitial) {
				return false;
			}
			
			return true;

		} 
		
		return false;

	};
	
	this.endDateIsGreatherThanBeginDate = function (beginDate, endDate) {
        
        var monetFormat = Monet.I18n.locale.dateFormat + " " + Monet.I18n.locale.timeFormat;
        var timeBeginDate, timeEndDate;

        if (beginDate !== "" && endDate !== "") {

            timeBeginDate = new Date(moment(beginDate, monetFormat)._d).getTime();
            timeEndDate   = new Date(moment(endDate, monetFormat)._d).getTime();

            if (timeEndDate > timeBeginDate) {
                return true;
            }
            
            return false;

        } 
        
        return false;

    };

	this.validateDateGreaterOrEqualThan = function (dateInitial, dateFinal) {

		var monetFormat = Monet.I18n.locale.dateFormat + " " + Monet.I18n.locale.timeFormat;
		var timeInitial, timeFinal;
		
		if (dateInitial !== "" && dateFinal !== "") {

			timeInitial = new Date(moment(dateInitial, monetFormat)._d).getTime();
			timeFinal   = new Date(moment(dateFinal, monetFormat)._d).getTime();

			if (timeFinal >= timeInitial) {
				return true;
			}
			
			return false;

		}
		
		return false;

	};

	this.formateDateTimeByLocale = function (dateTime) {

		var valueDate = dateTime.split("T");
		var date = Globalize.format(Date.create(valueDate[0]),
				Monet.I18n.locale.dateFormat);
		var time = Globalize.format(Date.create(valueDate[1]), "t");

		return date + " - " + time;
	};
	
	this.formateDateByLocale = function (date) {

	    var valueDate = date;
        var dateFormated = Globalize.format(Date.create(valueDate), Monet.I18n.locale.dateFormat);
             

        return dateFormated;
    };

	this.formateDateByLocale = function (dateTime) {

		var date = Date.create(dateTime);
		return Globalize.format(date, 'd');

	};

	this.formatTimeByLocale = function (time) {
		return moment(time, Monet.I18n.locale.timeFormat,
				Monet.I18n.locale.language)._i;
	};

	this.formateDateTime = function (dateTime) {

		var data = Date.create(dateTime),
		    dateFormat = Monet.I18n.locale.dateFormat,
		    timeFormat = Monet.I18n.locale.timeFormat,
		    dateFormated = Globalize.format(data, dateFormat),
		    timeFormated = Globalize.format(data, timeFormat);
		
		return dateFormated + " " + timeFormated;

	};

	this.dateTimePickerFormatValue = function (value) {
	    
	    var error = null;

		try {

			var formatedValue = "",
			    dateFormat = Monet.I18n.locale.dateFormat,
			    timeFormat = Monet.I18n.locale.timeFormat,
			    date = Date.create(value);
			

            dateFormat = dateFormat.replace("dd", "{dd}")
                    .replace("MM", "{MM}").replace("yyyy", "{yyyy}");
			
			timeFormat = timeFormat.replace("HH", "{HH}").replace("mm", "{mm}");

			formatedValue = date.format(dateFormat + " " + timeFormat);

			return formatedValue;

		} catch (e) {

			error = new Monet.Exception.ReturnError(this,
					"Error on format value to set datetimepicker.");
			error.console();

		}
	};

	this.validateIfDateIsInFuture = function (date) {
	    
	    var dateTimeFormat = Monet.I18n.locale.dateFormat + " " + Monet.I18n.locale.timeFormat;

		var timeToday = new Date().setHours(0, 0, 0, 0);
		var timeDate = new Date(moment(date, dateTimeFormat)._d).getTime();

		if (timeDate > timeToday) {
			return true;
		}

		return false;
	};
	
	this.checkIfDateIsToday = function (date) {
	    
        var error = null;

        try {
	    
            var timeToday = new Date().setHours(0, 0, 0, 0);
            var timeDate = Date.create(date).getTime();

            if (timeDate === timeToday) {
                return true;
            }

            return false;
        
        } catch (e) {
            
            error = new Monet.Exception.ReturnError(this,
                    "Error on check if date is today.");
            error.console();

        }
        
	};

	this.convertTimeToHoursMinutesAndSeconds = function (timeInMilliSeconds) {
	    
        var error = null;

		try {
		    
		    var keyHourAbreviation = "Greenmile.UnitMetrics.hourAbreviation",
		    keyMinuteAbreviation = "Greenmile.UnitMetrics.minuteAbreviation",
		    keySecondsAbreviation = "Greenmile.UnitMetrics.secondsAbreviation",
		    timeFormated = "",
		    seconds = Math.floor(timeInMilliSeconds / 1000),
		    minutes = Math.floor(seconds / 60),
		    hour = Math.floor(minutes / 60),
		    hourAbreviation = Monet.I18n.getResourcesByKey(keyHourAbreviation),
		    minuteAbreviation = Monet.I18n.getResourcesByKey(keyMinuteAbreviation),
		    secondAbreviation = Monet.I18n.getResourcesByKey(keySecondsAbreviation);

			if (hour > 0) {
				
				timeFormated += hour + " " + hourAbreviation + " ";

			}

			timeFormated += minutes % 60 + " " + minuteAbreviation + " ";

			if (seconds > 0) {

				timeFormated += seconds % 60 + " " + secondAbreviation;

			}

			return timeFormated;

		} catch (e) {
            
			error = new Monet.Exception.ReturnError(this,
                    "Error on convert miliseconds on hour, minutes and seconds.");
            error.console();

		}
	};
	
	this.hourEndIsGreatherOrEqualHourBegin = function (hourBegin, hourEnd) {
        
        var error = null;
        var timeBegin, timeEnd;
        
        try {
            
            if (typeof hourBegin !== "undefined" && typeof hourEnd !== "undefined") {
                
                if (hourBegin !== "" && hourEnd !== "") {
                    
                    timeBegin = Date.create(hourBegin).getTime();
                    timeEnd = Date.create(hourEnd).getTime();
                    
                    if (timeEnd >= timeBegin) {
                        return true;
                    }
                    
                }
            } else {

                error = new Monet.Exception.ReturnError(this,
                        "Parameters is undefined on hour end is greather or equals hour begin.");
                error.console();
                
            }
            
            return false;
            
        } catch (e) {

                        
            error = new Monet.Exception.ReturnError(this,
                    "Error on convert miliseconds on hour, minutes and seconds.");
            error.console();
            
        }
        
    };
	
	this.convertTimeToDaysHoursMinutesAndSeconds = function (timeInMilliSeconds) {
	    
	    var error = null;

		try {
		    var keyHourAbreviation = "Greenmile.UnitMetrics.hourAbreviation",
            keyMinuteAbreviation = "Greenmile.UnitMetrics.minuteAbreviation",
            keySecondsAbreviation = "Greenmile.UnitMetrics.secondsAbreviation",
            keyDayAbreviation = "Greenmile.UnitMetrics.dayAbreviation",
			timeFormated = "",
			seconds = Math.floor(timeInMilliSeconds / 1000),
			minutes = Math.floor(seconds / 60),
			hour = Math.floor(minutes / 60),
			day = Math.floor(hour / 24),
			hourFinal = day % hour,
            dayAbreviation = Monet.I18n.getResourcesByKey(keyDayAbreviation),
            hourAbreviation = Monet.I18n.getResourcesByKey(keyHourAbreviation),
            minuteAbreviation = Monet.I18n.getResourcesByKey(keyMinuteAbreviation),
            secondAbreviation = Monet.I18n.getResourcesByKey(keySecondsAbreviation);
            
			if (hour > 24) {
				

			    timeFormated += day + dayAbreviation + " " + hourFinal + hourAbreviation + " ";

			} else {

                timeFormated += hour + hourAbreviation + " ";			    
			    
			}

			timeFormated += minutes % 60 + minuteAbreviation + " ";

			if (seconds > 0) {

				//timeFormated += seconds % 60 + " " + secondAbreviation;

			}

			return timeFormated;

		} catch (e) {
            
			error = new Monet.Exception.ReturnError(this,
                    "Error on convert miliseconds on hour, minutes and seconds.");
            error.console();

		}
	};
	
	this.createDateByMilisseconds = function (timeInMilisseconds) {
	    
	    var error = null;

        try {

            var formatedValue = "",
                dateFormat = Monet.I18n.locale.dateFormat,
                timeFormat = Monet.I18n.locale.timeFormat,
                date = Date.create(timeInMilisseconds);
            

            dateFormat = dateFormat.replace("dd", "{dd}")
                    .replace("MM", "{MM}").replace("yyyy", "{yyyy}");
            
            timeFormat = timeFormat.replace("HH", "{HH}").replace("mm", "{mm}");

            formatedValue = date.format(dateFormat + " " + timeFormat);

            return formatedValue;

        } catch (e) {

            error = new Monet.Exception.ReturnError(this,
                    "Error on create date from milisseconds.");
            error.console();

        }
	    
	}
	
};