if(typeof(Greenmile) == "undefined") {
	
	var Greenmile = {
		Session: {
			Configurations: {
				MapConfiguration: {}
			}
		}
	};
	
}

var MakeLayouts = {

    addListeners : function() {

        var that = this;
        that.makeScreen();

    },

    makeScreen : function() {
        Monet.TabControl.init();
    },

    makeMapScreen : function() {

              
        MakeLayouts.mapScreenConfiguration();

        $(window).off("resize", function() {
            MakeLayouts.mapScreenConfiguration();
        });

        $(window).on("resize", function() {
            MakeLayouts.mapScreenConfiguration();
            
        });

    },
    
    screenConfigurationFunctions: function() {

        var formFilterHeight;
        
        var barraDeUrgentes    = $(".detailErrorException").attr("visible");
        var eventUrgentBar     = 38;          
        
        var mapScreenContainer = document.getElementById("Maps"), 
            routePanel         = document.querySelector("#Maps .mapPanel"),
            routeList          = document.querySelector("#Maps .mapPanel .well.sidebar-nav"),
            notificationPanel  = document.querySelector("#Maps .notificationPanel"),            
            mapContainer       = document.getElementById("adjustsLayoutContainer"),
            dTablesScrollBody  = document.querySelector("#Maps .dataTables_scrollBody"),
            eventList          = document.querySelector(".notificationPanel #routeListConteiner"),
            erroBar            = document.querySelector(".detailErrorException"),
            secondTitle        = document.querySelector('div.notificationPanel div.well.sidebar-nav div.sideBarTitle:nth-child(3)');

                                                                
        /*
         * Analisa se o painel de notificações está com o elemento hide
         */
        
        this.sizePanelNotification = 0;
        
        App.Views.Map.checkContainerMap();            
            
        if(mapScreenContainer != null) {        
            mapScreenContainer.style.top = "75px";
        }
        
        if(routePanel != null) {
            routePanel.style.top         = "75px";
        }
        
        if(notificationPanel != null) {
            notificationPanel.style.top  = "75px";    
        }
        
        if(mapContainer != null) {
            mapContainer.style.top = "75px";    
        }            
        
        if(routeList != null) {
            routeList.style.top = "75px";    
        }
        
        if(eventList != null) {
            if($("#filterEvents .form-horizontal").is(":visible")){                                            
                secondTitle.style.top   = "260px";        
            }else{
                secondTitle.style.top = "66px";                                                                                            
            }
        }
        
        if(eventList != null) {
            if($("#filterEvents .form-horizontal").is(":visible")){                        
                eventList.style.top = "290px";        
            }else{
                eventList.style.top = "96px";                                                                        
            }                      
        }
        
        if(dTablesScrollBody != null) {
            if(document.querySelector("#Maps .dataTables_scrollBody").style.overflowX !== "hidden") {
                dTablesScrollBody.style.overflowX = "hidden";
                dTablesScrollBody.style.overflowY = "scroll";                
            }
        }
                    
        //$(".notificationPanel").css("left", $(window).width() - parseInt($(".notificationPanel").css("width")) + sizeAdjustment);

        /*
         * Se o container de notificações estiver com display-block: none, 
         * no arquivo Maps_router.js, exatamente na função - renderEventList(), é redefinido o tamanho do mapa
         * 
         * */
         
        /* 
        $("#mapContainer").css("left", parseInt($(".mapPanel").css("width")) + sizeAdjustment);
        $("#mapContainer").css("width", ($(window).width() - parseInt($(".mapPanel").css("width")) - this.sizePanelNotification ) + sizeAdjustment);
                    
        $(".mapContainer").css("left", 260);
        $(".mapContainer").css("width", ($(window).width() - 510) + sizeAdjustment);
        
        $(".mapContainer.mapDetail").css("left", 0);
        $(".mapContainer.mapDetail").css("width", $(window).width() + sizeAdjustment);
        */
        
        //$(".notificationPanel #routeListConteiner").css("height", +$(window).height() - elementHeight);

        //Icons Map Route
        $(".sideBarShow").off("click");
        $(".sideBarHide").off("click");            
        $(".sideBarNewWindow").off("click");
        

        $(".sideBarShow").on("click", function(event) {
            event.preventDefault();
            App.Views.Map.showRoutePanel();
        });

        $(".sideBarHide").on("click", function(event) {
            event.preventDefault();
            App.Views.Map.hideRoutePanel();
        });
        
        $(".sideBarNewWindow").on("click", function(event) {
            window.location = "#/RouteMonitor";
            var routeMonitor = new App.Routers.RouteMonitor();
            routeMonitor.show();
        });
        
        $(".icon_new_window").off("click");
        
        $(".icon_new_window").on("click", function(event) {
            
            if(window.location.hash == "#/RouteMonitor") {
                var routeMonitor = new App.Routers.RouteMonitor();
                routeMonitor.show();                
            } else {
                window.location = "#/RouteMonitor";    
            }

        });        
        
        //Icons EventLog
        $(".notificationPanel .sideBarShowNotification").off("click");
        $(".notificationPanel .sideBarHideEventLog").off("click");            
        $(".notificationPanel .sideBarNewWindow").off("click");
        $(".showSideBarExpandNotification .sideBarShowNotification").off("click");
        
        if($(".notificationPanel").length != 0) {
        
            var mapRight = parseInt($("#Maps #adjustsLayoutContainer").css("right").replace("px",""));
        	
            if(mapRight !== 0) {
                $(".showSideBarExpandNotification").hide();
            };
            
            //ajusta a tela de streetView do google
            $("#Maps .streetView").css("right", mapRight + 10);
            $("#Maps .streetViewCloseBtn").css("right", mapRight + 5);
            
            //ajusta a tela de eventos urgentes
            $("#alertEventUrgentInMap").css("right", mapRight+9);
            $("#mapContainer").css("right", mapRight);
            
        }
        
        $(".sideBarShowNotification").on("click", function(event) {
            event.preventDefault();
            App.Views.Map.toggleNotificationanel();
        });

        $(".notificationPanel .sideBarHideEventLog").on("click", function(event) {
            App.Views.Map.toggleNotificationanel();
        });
        
        if($("#routeTable_filter .form-horizontal").css("height") === "0px" || typeof($("#routeTable_filter .form-horizontal").css("height")) === "undefined") {            
            formFilterHeight = 0;                
        } else {
            formFilterHeight = 170;
        }

        eventUrgentBar = 0;
    
        //controla o height do eventlistcontainner
        var sizeFilterEvents = 0;
        
        if(typeof($("#filterEvents").css("height"))!=="undefined" && typeof($("#filterEvents").css("padding-bottom"))!=="undefined" ){
            
            sizeFilterEvents = parseInt($("#filterEvents").css("height").replace("px",""),10);
            sizeFilterEvents += parseInt($("#filterEvents").css("padding-bottom").replace("px",""),10);
            
       }
       
       //$(".notificationPanel #routeListConteiner").css("height", $(window).height() - (143 + eventUrgentBar) - sizeFilterEvents);

        
        //Barra lateral
        //$(".tableLines").css("height", $(window).height() - (140 + eventUrgentBar + formFilterHeight));
        
        setTimeout(function(){
            $("#routeTable_wrapper .dataTables_scrollBody").css("height", $(window).height() - (230 + formFilterHeight + eventUrgentBar));    
        }, 500);
        
        Monet.Session.Grids.Route.height = $(window).height() - (230 + formFilterHeight + eventUrgentBar);
        
        $("#routeTable_wrapper .dataTables_scrollBody").css("width", 275);
        
        //Área do mapa
        /*
        $(".mapContainer").css("height", $(window).height() - (elementHeight + eventUrgentBar)+6);
        $("#mapContainer").css("height", $(window).height() - (elementHeight + eventUrgentBar)+6);
        $(".mapPanel").css("height", $(window).height() - (elementHeight + eventUrgentBar)+6);
        $(".mapScreen").css("height", $(window).height() - (241 + eventUrgentBar)+6);
        */
        //Lista de notificações
        //$(".notificationPanel").css("height", $(window).height() - (elementHeight + eventUrgentBar));
        //$(".notificationPanel #routeListConteiner").css("height", $(window).height() - (143 + eventUrgentBar));
                
        
        $("#logoutBtn").off("click");
        
        $("#logoutBtn").on("click", function(){
            Monet.authentication.logout();
        });
        
        if(typeof(Monet.Session.User) !== "undefined") {
            $("#logoutBtn strong").html(Monet.Session.User.name);    
        }
        //ajusta o width e os height no detalhe da rota
        if($(".gridStopTable").length>0){
            /**
             * TODO: ajustar o height do grid do detalhe de stop quando reduzir a tela
             * por enquanto está somente o width
             */         
            //$(".gridStopTable").css("width", $(window).width());

        }
        
        //$(".sideBarItem.tableLines.full").css("height", ($(window).height()-60) - (elementHeight + eventUrgentBar));
        
        /*
         * Analisa o radio button marcado anteriormente da toolbar de fornecedores de mapa
         */
        new Greenmile.Storage.StoreMapPosition().checkRadioButtonLayerMap();
                
        
    },

    mapScreenConfiguration : function() {
        
        $(document).ready(function() {
            
            MakeLayouts.screenConfigurationFunctions();

        });
        
        $(window).off("resize", function() {

            MakeLayouts.screenConfigurationFunctions();

        });

        $(window).on("resize", function() {
            
            MakeLayouts.screenConfigurationFunctions();

        });        

    }
};

ManageTemplates = {

    pageLayout : function(f) {

        var pl = $("#page_template");
        var version_template = _.template($("#gm_version").html());
        var page_template;
        
        if (pl.size() == 0) {
            $(document).ready(function() {
            	
            	page_template = _.template(App.Templates.PageTemplate);
            	
                $('#page_container').html(page_template({
                	copywriting: '<p>Copyright &copy; 2012 greenmile.com, inc. <div id="version_footer"></div></p>'
                }));
                
                $('#version_footer').html(version_template({
                    label: "v.",
                    html_before: '',
                    html_after: ''
                }));
                
                document.title = version_template({
                    label: "Greenmile v.",
                    html_before: '',
                    html_after: ''
                });                
                
                $.ajax({
    				url : 'Menu',
    				async: false,
    				type : 'GET',
    				dataType : 'json',
    				success : function(data) {
    					Monet.Session.Menu = data;
    					Greenmile.Generate.Menu();
    				}
    			});                
                
                $.ajax({
                	url: 'GlobalConfiguration',
                	type: 'GET',
                	'contentType' : 'application/json',
                	dataType : 'json',
                	async: false,
                	success: function(data1) {
                		
                		Monet.Session.Configurations = data1[0];
                	}
                });
                
        		$.ajax({
	        		url: 'MapConfiguration',
	        		async: false,
	        		dataType:'json',
	        		success: function(data) {
		        		var mapConfiguration = new App.Collections.MapConfigurations();
		        		
		        		if(data.length != 0) {
			        		mapConfiguration.add(data);
			       			Monet.Session.Configurations["MapConfiguration"] = mapConfiguration;		        			
		        		} else {
		        		
                            Monet.Session.isLogged = false;
                            
                            $.toast({
                                 message:"MapConfiguration is not configured",
                                 displayTime:3000,
                                 inTime:100,
                                 outTime:400,
                                 vPosition: "center",
                                 hPosition: "center"
                            });
                            //corrige o problema de exibicao do toast no IE8 e inferior 
                             if (jQuery.browser.msie&&jQuery.browser.version<9){  
                                $(".toast").css("top",  ($(window).height()/2)-($(".toast").height()+15));
                                $(".toast").css("left",  ($(window).width()/2)-($(".toast").width()/2)-1);
                             }		        			
		        			
		        		}		        		

	        		}
                });
        		
        		Monet.I18n.checkResources();
                Monet.TabControl.init();
                
            });
        }

        $(document).ready(function() {

            $(".nav a").off("click");

            $(".nav a").on("click", function(event) {
                event.preventDefault();
                
                var element = $(this);
                var linkUrl = element.attr("href");
                var url     = window.location.hash;
                var tabName = element.attr("href").replace("/", "");                
                var tab     = $(tabName);
                
                if (linkUrl !== "#") {  
                    
                    if (tab.size() === 0) {
                        
                        if (url == linkUrl) {
                            Backbone.history.fragment = "#";
                            Backbone.history.checkUrl();
                        } else {
                            window.location = linkUrl;    
                        }
                                                
                    } else {
                        $("#tabs").tabs("select", tabName);
                    }                                      
                    
                } 
                
            });
            
            Monet.I18n.translateInterface();

            f();

        });
    }
};

Greenmile.Platform = {
    userAgent : "",
    platform : "",
    browser : {
        language : "",
        version : "",
        name : ""
    },

    check : function() {
        this.userAgent = navigator.userAgent;
        this.so = navigator.platform;
        this.browser.name = this.extractBrowserInformations();
        this.browser.version = this.extractBrowserVersion();

        if (this.browser.name === "MSIE") {
            this.browser.language = navigator.browserLanguage;
        } else {
            this.browser.language = navigator.language;
        }

    },

    extractBrowserInformations : function() {
        var safari = this.userAgent.indexOf("Safari");
        var firefox = this.userAgent.indexOf("Firefox");
        var ie = this.userAgent.indexOf("MSIE");
        var chrome = this.userAgent.indexOf("Chrome");

        if (firefox > 0) {
            return "Firefox";
        }

        if (ie > 0) {
            return "MSIE";
        }

        if (chrome > 0) {
            return "Chrome";
        } else {
            if (safari > 0) {
                return "Safari";
            }
        }
    },

    extractBrowserVersion : function() {

        var version = [];

        switch(this.browser.name) {
            case "Safari":

                version = this.userAgent.match(/Safari\/(.+?)$/);

                if ( typeof (version[1]) !== "undefined") {
                    return version[1].trim();
                }

                break;

            case "Firefox":

                version = this.userAgent.match(/Firefox\/(.+?)$/);

                if ( typeof (version[1]) !== "undefined") {
                    return version[1].trim();
                }

                break;

            case "MSIE":

                version = this.userAgent.match(/MSIE(.+?)\;/);

                if ( typeof (version[1]) !== "undefined") {
                    return version[1].trim();
                }

                break;

            case "Chrome":

                version = this.userAgent.match(/Chrome\/(.+?) Safari/);

                if ( typeof (version[1]) !== "undefined") {
                    return version[1].trim();
                }

                break;
            default:
                return "?";
                break;
        }
    }
};

/*
 * Esse objeto serve apenas como namespace para guardar coisas que deveriam ser globais
 * algumas dessas informações são usadas também para guardar estado de elementos da interface
 * como a ordenação do grid, por exemplo, antes de ele ser remontado a cada atualização
 * de dados.
 * 
 * O desenvolvedor deve adicionar os objetos seguindo a estrutura das telas, exemplo:
 * 
 * é para a ba de mapas:
 * 
 * Monet.Session.Maps = {
 *     routeGrid: {
 *        columnOrder: 1,
 *        orderDirection: 'asc' 
 *     } 
 * }
 * 
 */

Monet.Session = {
    Grids: {
        Route: {
            indexes: {},
            layout: [],
            layoutCompact: [],
            indexesCompact: {},
            status: undefined,
            data: undefined,
            height: undefined,
            table: undefined,
            tableCompact: undefined,
            needAjust: true,
            firstTime: true,
            first: 0,
            max: 101,
            total: 0,
            blocked: false,
            sort: []          
        },
        RouteMonitor: {
            indexes: {},
            layout: [],
            layoutCompact: [],
            indexesCompact: {},
            status: undefined,
            data: undefined,
            height: undefined,
            table: undefined,
            tableCompact: undefined,
            needAjust: true,
            firstTime: true,
            first: 0,
            max: 101,
            total: 0,
            blocked: false,
            sort: []          
        },        
        Stop: {
            indexes: {},
            layout: [],
            status: undefined,
            data: undefined,
            height: undefined,
            table: undefined,
            needAjust: true,
            parentRoute: undefined,
            first: 0,
            max: 101,
            total: 0,
            blocked: false,
            sort: []
        },
        Order: {
            indexes: {},
            layout: [],
            status: undefined,
            data: undefined,
            height: undefined,
            table: undefined,
            needAjust: true,
            parentRoute: undefined,
            first: 0,
            max: 101,
            total: 0,
            blocked: false,
            sort: []             
        },
        LineItems: {
            indexes: {},
            layout: [],
            status: undefined,
            data: undefined,
            height: undefined,
            table: undefined,
            needAjust: true,
            parentRoute: undefined,
            first: 0,
            max: 101,
            total: 0,
            blocked: false,
            sort: []  
        }
    },

    RouteDetail: {
        screensList: {}
    }
};

/**
 * 
 * Método que recebe uma chamada a propriedade ou função através de String com encadeamento, que juntamente com a definição via prototype possibilita a chamada exemplo abaixo.
 *   Ex.: objeto.try('caminho.recurso');
 * Se for um método apenas adicionar a chamada do método ao final
 *   Ex.: objeto.try('caminho.recurso')();
 * 
 */ 
var call = function(property) {
  return (function percorrer(property, objeto){
    var properties = property.split('.');
    objeto = objeto[properties.shift()];
    return (properties.length > 0 && typeof objeto !== 'undefined') ? percorrer(properties.join('.'), objeto) : objeto;
  })(property, this);
};

/**
 * 
 * Funçõa acima definida via 'prototype' no Object do JS com o nome try
 * 
 */

Object.defineProperty(Object.prototype, "call", {value: call});



/*
 * Armazena os retorno do setTimeout() e setInterval() de maneira global
 * para poder cancelar depois.
 */

Monet.Session.Notification = {
    timeout: undefined,
    interval: undefined
    
};

Monet.Session.WindowNotification = {
        selector: undefined
};

Monet.Session.ListaEventosUrgentes = {
        selector: undefined
};

if (!String.prototype.trim) {
 String.prototype.trim = function() {
  return this.replace(/^\s+|\s+$/g,'');
 };
}


/* Greenmile Utils */

Greenmile.Utils = Greenmile.Utils || {};

Greenmile.Utils.generateCoords = function() {
	
	this.odometerMeters = 0;
	this.speedKmh = 30;
	this.date;	
	this.routeId = Monet.Utils.GetTabName().replace("routeMaps_", "");
	
	this.setOdometer = function(odo) {
		this.odometerMeters = odo;
	};
	
	this.setSpeedKmh = function(speedKmh) {
		this.speedKmh = speedKmh;
	};	
	
	this.requestRoute = function() {
		
		var request  = null;
		var url 	 = 'Route/filter?criteria={"filters":["*", "organization.id"]}';		
		var callback = this.requestRouteCallback;
		
		request = new XMLHttpRequest();
		request.open('POST', url, true);
		request.setRequestHeader('Content-Type', 'application/json');
		
		request.onreadystatechange = (function(parentObj) {
			return function() {
				callback(this, parentObj);
			};
		})(this);
		
		request.send('{"id": ' + this.routeId + '}');
		
	};
	
	this.requestRouteCallback = function(xhr, parentObj) {
		
        if(xhr.readyState == 4) {        	
            data = JSON.parse(xhr.responseText);           
            
            if(xhr.status == 200) {
            	parentObj.route = data[0];
            	parentObj.requestRouteEquipment();
            }                            
        }		
		
	};
	
	this.requestRouteEquipment = function() {

		var request  = null;
		var url 	 = 'RouteEquipment/filter?criteria={"filters":["id", "equipment.id"]}';		
		var callback = this.requestRouteEquipmentCallback;
		
		request = new XMLHttpRequest();
		request.open('POST', url, true);
		request.setRequestHeader('Content-Type', 'application/json');
		
		request.onreadystatechange = (function(parentObj) {
			return function() {
				callback(this, parentObj);
			};
		})(this);	
		
		request.send('{"route":{"id": ' + this.routeId + '}}');
		
	};
	
	this.requestRouteEquipmentCallback = function(xhr, parentObj) {
		
        if(xhr.readyState == 4) {        	
            data = JSON.parse(xhr.responseText);           
            
            if(xhr.status == 200) {
            	parentObj.routeEquipment = data[0];
            	parentObj.requestEquipment();
            }                            
        }		
		
	};
	
	this.requestEquipment = function() {
		
		var request  = null;
		var url 	 = 'Equipment/filter?criteria={"filters":["id", "key", "gpsProvider.*", "gpsUnitId"]}';		
		var callback = this.requestEquipmentCallback;
		
		request = new XMLHttpRequest();
		request.open('POST', url, true);
		request.setRequestHeader('Content-Type', 'application/json');
		
		request.onreadystatechange = (function(parentObj) {
			return function() {
				callback(this, parentObj);
			};
		})(this);
		
		request.send('{"id": ' + this.routeEquipment.equipment.id + '}');		
		
	};
	
	this.requestEquipmentCallback = function(xhr, parentObj) {
		
        if(xhr.readyState == 4) {        	
            data = JSON.parse(xhr.responseText);                       
            if(xhr.status == 200) {
            	parentObj.equipment = data[0];
            }                            
        }		

	};
	
	this.getMap = function() {
		this.map = Monet.Session.RouteDetail.screensList[this.routeId].map;
	};
	
	this.addListenersToMap = function() {
		
		var that = this;
		
		this.map.on('click', function(e) {
			that.submitCoords(e, that);
		});
	};
	
	this.onMapClick = function(e) {
	    console.log(e.latlng);
	};
	
	this.submitCoords = function(e, closure) {
		
		var objToSubmit = {
			organizationId: closure.route.organization.id,
			position : {
			    longitude: e.latlng.lng, 
				latitude: e.latlng.lat
			},
			odometerMeters: closure.odometerMeters,
			speedKmh: closure.speedKmh,
			date: Date.create().iso(),
			equipmentGpsUnitId: closure.equipment.gpsUnitId,
			gpsProviderId: closure.equipment.gpsProvider.id
		};
		
		var request  = null;			
		request 	 = new XMLHttpRequest();
		
		request.open('POST', 'Coordinate', true);
		request.setRequestHeader('Content-Type', 'application/json');		
		request.send(JSON.stringify(objToSubmit));		
		
	};
	
	this.refreshMap = function() {
		
		var u = new Monet.Maps.Updater();
		
		u.go();
		
	};
	
	this.go = function() {
		this.requestRoute();		
		this.getMap();
		this.addListenersToMap();
	};
	
	this.go();
	
};