MonetCollection = Backbone.Collection.extend({

    initialize : function (attributes, options) {
        options || (options = {});
        this.init && this.init(attributes, options);
    },

    isEmpty : function () {
        if (this.models.length === 0) {
            return true;
        }

        return false;
    },

    toArray : function () {

        var lines = [];
        var columns = [];
        var key = null;

        $.each(this.models, function (index, model) {

            for (key in model.attributes) {
                if (typeof key !== "function") {
                    columns.push(model.get(key));
                }
            }

            lines.push(columns);

            columns = [];

        });

        return lines;

    },

    toTableData : function (tableColumns, dataMapper) {

        var lines = [];
        var columns = [];
        var columnValue, column;

        $
                .each(
                        this.models,
                        function (index, model) {

                            for ( var i = 0, j = tableColumns.length; i < j; i++) {

                                if (typeof (tableColumns[i].columnName) !== "undefined") {

                                    columnValue = Monet.Format.field(
                                            tableColumns[i].columnName, model,
                                            dataMapper);

                                    column = App.Forms[dataMapper].dataMapper[tableColumns[i].columnName];

                                    if (typeof (column) !== "undefined") {

                                        // valida se o tipo do campo é checkbox
                                        if (column.type === "CHECKBOX") {

                                            // verifica se o valor é false ou
                                            // true
                                        	if (typeof (model.attributes[tableColumns[i].columnName] === "false")) {
                                                columnValue = "<img src='resources/images/grid/false.png'>";
                                            } else {
                                                columnValue = "<img src='resources/images/grid/true.png'>";
                                            }
                                        } else {
                                            columnValue = Monet.Format.field(
                                                    tableColumns[i].columnName,
                                                    model, dataMapper);
                                        }
                                    } else {
                                        columnValue = Monet.Format.field(
                                                tableColumns[i].columnName,
                                                model, dataMapper);
                                    }

                                    columns.push(columnValue);

                                }

                            }

                            lines.push(columns);

                            columns = [];

                        });

        return lines;

    },

    fetchWithCriteria : function (obj) {

        var criteria;

        this.reset();

        var collection = function (collection) {
            return collection;
        }(this);

        if (typeof (obj.criteria) !== "undefined") {
            criteria = obj.criteria;
        }
        
        var asyncValue = true;

        if (typeof (obj.async) !== "undefined") {
            asyncValue = obj.async;
        }

		console.log("1");

        $.ajax({
            url : window.hostConf + "/" + this.url + '?criteria=' + criteria,
            type : 'GET',
            'contentType' : 'application/json',
            dataType : 'json',
            async : asyncValue,
            success : function (data) {

                if (typeof (obj.success) !== "undefined") {

                    var dataLenght = data.length;

                    for (i = 0; i < dataLenght; i++) {

                        var model = new collection.model;
                        model.set(data[i]);

                        try {
                            collection.add(model);
                        } catch (err) {
                            // TODO: Entender porque as vezes ele tenta
                            // adicionar duas vezes o mesmo model
                        }

                    }

                    obj.success(collection);

                }

            }
        });

    },

    filterWithCriteria : function (obj) {

        this.reset();

        var collection = function (collection) {
            return collection;
        }(this);

        if (typeof (obj.criteria) !== "undefined") {
            criteria = obj.criteria;
        }

        if (typeof (obj.filter) !== "undefined") {
            filter = obj.filter;
        }

        var asyncValue = true;

        if (typeof (obj.async) !== "undefined") {
            asyncValue = obj.async;
        }

        $.ajax({
            url : window.hostConf + "/" + this.url + '/filter?criteria=' + criteria,
            type : 'POST',
            headers: {
                "Cookie": window.cookie
            },
            'contentType' : 'application/json',
            dataType : 'json',
            data : filter,
            async : asyncValue,
            success : function (data) {

                if (typeof (obj.success) !== "undefined") {

                    var dataLenght = data.length;

                    for (i = 0; i < dataLenght; i++) {

                        var model = new collection.model;
                        model.set(data[i]);

                        try {
                            collection.add(model);
                        } catch (err) {
                            // ...
                        }

                    }

                    obj.success(collection);

                }

            }
        });

    }

});