/*
 * Copyright 2012 Sagarana Tech.  All rigths reserved.
 *
 * This software is the confidential and proprietary information of
 * Sagarana Tech ("Confidential Information"). You shall not disclose such
 * Confidential Information and shall use it only in accordance with the
 * terms of the license agreement you entered into with Sagarana Tech.
 * 
 */

/**
 * Represents a book.
 * 
 * @constructor
 * @param {string}
 *            title - The title of the book.
 * @param {string}
 *            author - The author of the book.
 */

var Greenmile        = Greenmile || {};
Greenmile.Dashboards = Greenmile.Dashboards || {};

Greenmile.Dashboards.Chart = function () {

    this.el          = null;
    this.type        = null;
    this.title       = null;
    this.subtitle    = null;
    this.legend      = null;
    this.series      = null;
    this.data        = null;
    this.refreshRate = null;
    this.id          = null;
    this.highChart   = null;
    this.filters     = null;
    this.kpiView     = null;        
    this.series      = null;
    this.tooltip     = {};
    this.plotOptions = {};    
    this.topValue    = false;
    this.xAxis = {
            type: null
        };
    
    this.yAxis = {
        title: {
            text: null
        }            
    };
    
    this.func = function (chart) {
        
    };

    this.create = function () {

        $(this.el).highcharts({
            chart : {
                type : this.type,
                reflow: true
            },
            tooltip : this.tooltip,
            plotOptions: this.plotOptions,
            title : {
                text : this.title
            },
            xAxis: this.xAxis,
            yAxis: this.yAxis,
            subtitle : {
                text : this.subtitle
            },
            series : this.series || []
        }, this.func);

        //this.highChart = new Highcharts.Chart();

        this.highChart = $(this.el).highcharts();

        this.highChart.showLoading();

    };

    this.fetch = function () {

        var request = new XMLHttpRequest();
        var url = 'Dashboard/Kpi/' + this.id;
        var now, 
            past, 
            stringifiedParameters;
        
        if (this.filters === null) {

            this.filters = {};

            now  = new Date();
            past = new Date(now.getFullYear(), now.getMonth() - 1, 1);
            
            if (this.topValue) {
                this.filters.topValue = 10;                
            }

            this.filters.startDate = past.toJSON();
            this.filters.endDate   = now.toJSON();

        }

        request.open('post', url, true);

        request.onreadystatechange = (function (parentObj) {
            return function () {
                parentObj.fetchDoneCallback(this, parentObj);
            };
        })(this);

        request.setRequestHeader('Content-Type', 'application/json');
        
        stringifiedParameters = JSON.stringify(
                this.filters, 
                ["endDate", 
                 "startDate", 
                 "driverIdList", 
                 "equipmentIdList", 
                 "organizationIdList", 
                 "locationIdList",
                 "topValue"]
        );
        
        this.highChart.showLoading();
        request.send(stringifiedParameters);

    };

    this.fetchDoneCallback = function (xhr, parentObj) {

        if (xhr.readyState === 4) {

            if (xhr.status === 200) {

                parentObj.data = JSON.parse(xhr.responseText);

                parentObj.process(parentObj.data, parentObj);
                parentObj.highChart.hideLoading();
                parentObj.submitParameterValues(parentObj);

            } else {

                parentObj.callbackError(xhr);

            }
        }

    };

    this.callbackError = function () {

        var monetMessage = new Monet.Form.Messages.AlertMessage();

        monetMessage.setInfoType("error");
        monetMessage.setMessage(JSON.parse(this.responseText));
        monetMessage.triggerMessage();

    };
    
    this.submitParameterValues = function (scope) {
        
        var chart = Greenmile.Dashboards.Charts[scope.kpiView.id];
        var paramsToSend = [], 
            filterName = "", 
            filterValue = "";
        var request;
        
        for (var i = 0; i < chart.params.length; i++) {
            
            filterName = scope.resolveFilterNameByFieldName(
                    chart.params[i].field.name
            );
            
            if (typeof chart.filters[filterName] === "undefined") {
                filterValue = "";
            } else {
                filterValue = chart.filters[filterName];
            }
            
            paramsToSend.push({
                kpiparameterid: chart.params[i].id,
                kpidashboardid: Monet.Session.Dashboards.id,
                userid: Monet.Session.User.id,
                value: filterValue
            }); 
            
        }
        
        chart.lastSentParams = paramsToSend;
        
        request = new XMLHttpRequest();
        request.open('post', 'KpiParameterValue/batch', true);
        request.setRequestHeader('Content-Type', 'application/json');
        request.onreadystatechange = function (closure) {
            return function () {
                if (this.readyState === 4) {                        
                    if (this.status !== 200) {
                        closure.submitParameterValuesErrorCallback();
                    }
                }
            };
        }(this);
        
        //request.send(JSON.stringify(paramsToSend));
        
    };
    
    this.submitParameterValuesErrorCallback = function () {
        console.log(this.responseText);
    };    
    
    this.resolveFilterNameByFieldName = function (fieldName) {
        
        switch (fieldName) {
        case "intervalStart":
            return "startDate";
        case "intervalEnd":
            return "endDate";
        case "equipment":
            return "equipmentIdList";
        case "driver":
            return "driverIdList";
        case "organization":
            return "organizationIdList";
        default:
            return "startDate";
        }
        
    };
    
    this.format = function () {
        // to be overwrited
    };    

    this.process = function (data, parentObj) {
        this.format();
        // to be overwrited
    };

    this.getFormValues = function () {

        var lists = document.querySelectorAll(
                "#Dashboard .container_lookuplist_added"
        );
        
        var startDate  = document.getElementsByName("intervalStart")[0];
        var endDate    = document.getElementsByName("intervalEnd")[0];
        var topValue   = document.getElementById("topValue");
        var formValues = {};
        var groupId, listItem;

        for (var i = 0; i < lists.length; i++) {

            groupId  = lists[i].id.replace("_list", "IdList");
            listItem = lists[i].querySelectorAll("div.zebrado");

            formValues[groupId + "-description"] = formValues[groupId + "-description"] || [];

            for (var j = 0; j < listItem.length; j++) {

                if (typeof listItem[j] !== "undefined") {

                    formValues[groupId + "-description"].push(listItem[j]
                            .querySelector(".title_item_added").innerText);

                    formValues[groupId] = formValues[groupId] || [];

                    formValues[groupId].push(listItem[j]
                            .querySelector("input[type='hidden']").value);
                }

            }

        }

        if (startDate.value) {

            formValues.startDate = moment(startDate.value,
                    Monet.I18n.locale.dateFormat + " " + Monet.I18n.locale.timeFormat
            )._d.iso();

        }

        if (endDate.value) {

            formValues.endDate = moment(endDate.value,
                    Monet.I18n.locale.dateFormat + " " + Monet.I18n.locale.timeFormat
            )._d.iso();
        }
        
        if (topValue) {
            if (topValue.value) {
                formValues.topValue = parseInt(topValue.value, 10);
            }
        }

        return formValues;

    };

    this.setFormValues = function () {

        var hasDescription = false, 
            elementId, 
            descriptionE, 
            element, 
            intervalEnd, 
            intervalStart;

        var filters = this.filters;

        if (filters !== null) {
            
            for (var item in filters) {

                if (typeof filters[item] !== "function") {

                    elementId = item.replace("IdList", "");
                    descriptionE = item.replace("IdList-description", "");
                    hasDescription = elementId.indexOf('-description');

                    if (hasDescription > 0) {

                        element = document.getElementById(descriptionE + "_list");

                        for (var x = 0; x < filters[item].length; x++) {

                            new Monet.Form.LookupList("Dashboard", descriptionE)
                                .addItemLookupList({
                                    content : {
                                        id : filters[descriptionE + "IdList"][x],
                                        index : filters[descriptionE + "IdList"][x],
                                        title : filters[descriptionE + "IdList-description"][x]
                                    }
                                });

                        }

                    }

                }
            }

            intervalEnd   = document.getElementsByName("intervalEnd")[0];
            intervalStart = document.getElementsByName("intervalStart")[0];
            topValue      = document.getElementsByName("topValue")[0];

            if (typeof intervalEnd !== "undefined") {
                intervalEnd.value = Globalize.format(new Date(filters.endDate),
                        'd');
            }

            if (typeof intervalStart !== "undefined") {
                intervalStart.value = Globalize.format(new Date(
                        filters.startDate), 'd');
            }
            
            if (topValue) {
                topValue.value = filters.topValue;
            }

        }

    };
    
    this.makeRequestString = function (parametersObj) {
        return JSON
                .stringify(parametersObj, [ "organizationidList",
                        "equipmentidList", "driveridList", "startDate",
                        "endDate" ]);

    };

    this.validation = function (formValues) {

        var isValid = true;

        var error = {
            errorMessages : []
        };

        if (typeof formValues.startDate === "undefined") {

            isValid = false;

            error.errorMessages
                .push({
                    name : "startDate",
                    label : "",
                    message : Monet.I18n
                            .getResourcesByKey("Dashboard.Kpi.Error.starDateRequired")
                });

        }

        if (typeof formValues.endDate === "undefined") {

            isValid = false;

            error.errorMessages
                .push({
                    name : "endDate",
                    label : "",
                    message : Monet.I18n
                            .getResourcesByKey("Dashboard.Kpi.Error.endDateRequired")
                });

        }

        if (!isValid) {

            var monetMessage = new Monet.Form.Messages.InlineMessage();

            monetMessage.setScope(".popupFormContainer");
            monetMessage.setInfoType("error");
            monetMessage.setMessage(error);
            monetMessage.triggerMessage();

            return false;

        }

        return true;

    };
    
};

Greenmile.Dashboards.Chart.Factory = function (kpiType) {

    return new Greenmile.Dashboards.Chart[kpiType]();

};

Greenmile.Dashboards.Chart.Regular = (function () {

    RegularChart.prototype = new Greenmile.Dashboards.Chart();

    function RegularChart() {
        
        this.formatPie = function (data) {
            
            this.yAxis.title.text = Monet.I18n.getResourcesByKey(data.yAxis);
            this.plotOptions = {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        color: '#000000',
                        connectorColor: '#000000',
                        formatter: function () {
                            return '<b>' + Monet.I18n.getResourcesByKey(this.point.name) + '</b>: ' + this.percentage.toFixed(2) + ' %';
                        }
                    }
                }
            };
            
            this.tooltip = {
                    formatter: function () {
                        return '<b>'+ Monet.I18n.getResourcesByKey(this.point.name) +'</b>: '+ this.percentage.toFixed(2) +' %';
                    }
                };            
            
        };
        
        this.formatBars = function (data) {
            
            this.yAxis.title.text = data.yAxis;
            this.plotOptions = {};
                
            this.tooltip =  {
                    headerFormat: ' ',
                    pointFormat: '<b>{series.name}:</b> {point.y:.2f}',                    
                    useHTML: true
                };             
            
        };        
        
        this.processToPie = function (data, parentObj) {

            var values = [], 
                chart = null;
            
            parentObj.formatPie(data);
            parentObj.create();
            chart = parentObj.highChart;            
            
            if (typeof data.kpiSimpleValues !== "undefined") {

                for (var i = 0; i < data.kpiSimpleValues.length; i++) {

                    parentObj.yAxis.title.text = data.yAxis;
                    parentObj.create();
                    chart = parentObj.highChart;
                    
                    values.push([
                        data.kpiSimpleValues[i].name,
                        data.kpiSimpleValues[i].percentageValue                        
                    ]);

                }

            }
            
            chart.addSeries({
                type: 'pie',                     
                data : values
            });                     
            
        };        

        this.processToBars = function (data, parentObj) {

            var chart;
            
            if (typeof data.kpiSimpleValues !== "undefined") {

                parentObj.formatBars(data);
                parentObj.create();
                chart = parentObj.highChart;
                
                for (var i = 0; i < data.kpiSimpleValues.length; i++) {

                    if (typeof chart.series[i] === "undefined") {

                        chart.addSeries({
                            name : Monet.I18n.getResourcesByKey(data.kpiSimpleValues[i].name),
                            data : [data.kpiSimpleValues[i].percentageValue]
                        });

                    } else {
                        chart.series[i].setData(
                                [data.kpiSimpleValues[i].percentageValue]
                        );
                    }

                }

            }

        };
        
        this.process = function (data, parentObj) {
            
            switch (this.type) {
            case "pie":
                this.processToPie(data, parentObj);
                break;
            case "column":
                this.processToBars(data, parentObj);
                break;
            case "bar":
                this.processToBars(data, parentObj);
                break;

            default:
                this.processToBars(data, parentObj);                
                break;
            }

        };        
        
        this.allowTypes = function () {
            
            var types;
            
            types = [{
                value: "bar", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.bar")
            }, {
                value: "column", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.column") 
            }, {
                value: "pie", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.pie")
            }];
            
            return types;
            
        };        
    }

    return RegularChart;

})();

Greenmile.Dashboards.Chart.Irregular = (function () {

    IrregularChart.prototype = new Greenmile.Dashboards.Chart();

    function IrregularChart() {

        this.process = function (data, parentObj) {

            var values, chart;
            
            parentObj.format(data);
            parentObj.create();

            if (typeof data.kpiSeries !== "undefined") {

                for (var i = 0; i < data.kpiSeries.length; i++) {

                    chart = Greenmile.Dashboards.Charts[parentObj.kpiView.id].highChart;

                    values = [];

                    for (var cont = 0; cont < data.kpiSeries[i].values.length; cont++) {

                        for (var x in data.kpiSeries[i].values[cont]) {
                            if (typeof x !== "function") {
                                values.push([ x,
                                        data.kpiSeries[i].values[cont][x] ]);
                            }
                        }

                    }

                    if (typeof chart.series[i] === "undefined") {

                        chart.addSeries({
                            name : Monet.I18n.getResourcesByKey(data.kpiSeries[i].name),
                            data : values
                        });

                    } else {
                        chart.series[i].setData(values);
                    }

                }

            }

        };
        
        
        this.allowTypes = function () {
            
            var types;
            
            types = [{
                value: "spline", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.spline")
            }, {
                value: "area", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.area")
            }, {
                value: "scatter", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.scatter")
            }];
            
            return types;
            
        };

    }

    return IrregularChart;

})();

Greenmile.Dashboards.Chart.NumberOf = (function () {

    NumberOf.prototype = new Greenmile.Dashboards.Chart();

    function NumberOf () {
        
        this.format = function (data) {
            
            this.yAxis.title.text = Monet.I18n.getResourcesByKey(data.yAxis);
            this.plotOptions = {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            color: '#000000',
                            connectorColor: '#000000',
                            formatter: function () {
                                return '<b>' + Monet.I18n.getResourcesByKey(this.point.name) + '</b>: ' + this.percentage.toFixed(2) +' %';
                            }
                        }
                    }
                };
                
            this.tooltip = {
                    formatter: function () {
                        return '<b>'+ Monet.I18n.getResourcesByKey(this.point.name) +'</b>: '+ this.percentage.toFixed(2) +' %';
                    }
                };
            
        };
        
        this.processToPie = function (data, parentObj) {

            var values = [], chart, sugar_date, sugar_format, columnFormattedValue;

            if (typeof data.countSeries !== "undefined") {

                for (var i = 0; i < data.countSeries.length; i++) {

                    parentObj.format(data);
                    parentObj.create();
                    chart = parentObj.highChart;
            
                    sugar_date   = Date.create(data.countSeries[i].date);
                    sugar_format = Monet.I18n.locale.dateFormat.replace("dd", "{dd}")
                                        .replace("MM", "{MM}")
                                        .replace("yyyy", "{yyyy}"); 
                    
                    columnFormattedValue = sugar_date.format(sugar_format);
                    
                    values.push([
                        columnFormattedValue,
                        data.countSeries[i].countValue                        
                    ]);

                }

            }
            
            chart.addSeries({
                type: 'pie',                     
                data : values
            });                     
            
        };
        
        this.formatBars = function (data) {
            
            this.xAxis = {
                    type: 'datetime',
                    labels: {
                        formatter: function () {
                            return  " ";
                        }
                    }
                };
                
            this.yAxis = {
                    title: {
                        text: data.yAxis
                    },
                    min: 0
                };
                
            this.tooltip =  {
                        headerFormat: ' ',
                        pointFormat: '<b>{series.name}:</b> {point.y}',                    
                        useHTML: true
                    };                
        };        
        
        this.processToBars = function (data, parentObj) {
            
            var sugar_date, sugar_format, columnFormattedValue, chart;
            
            if (typeof data.countSeries !== "undefined") {
                                   
                parentObj.formatBars(data);
                parentObj.create();
                chart = parentObj.highChart;
                
                for (var i = 0; i < data.countSeries.length; i++) {

                    if (typeof chart.series[i] === "undefined") {
                        
                        sugar_date   = Date.create(data.countSeries[i].date);
                        sugar_format = Monet.I18n.locale.dateFormat.replace("dd", "{dd}")
                                            .replace("MM", "{MM}")
                                            .replace("yyyy", "{yyyy}");
                        
                        columnFormattedValue = sugar_date.format(sugar_format);
                        
                        chart.addSeries({
                            name : columnFormattedValue,
                            data : [data.countSeries[i].countValue]
                        });

                    } else {
                        chart.series[i].setData(
                                [data.countSeries[i].countValue]
                        );
                    }

                }

            }            
            
        };
        
        this.formatLine = function (data) {
            
            this.xAxis = {
                    labels: {
                        formatter: function () {
                            
                            var dateFunc = new Greenmile.Date.GeneralFunctions();
                            var formattedValue = dateFunc.formateDateByLocale(this.value);    
                            return  formattedValue;
                        }
                    }                        
                };             
                
            this.yAxis = {
                    title: {
                        text: data.yAxis
                    },
                    labels: {
                        formatter: function () {
                            return  this.value + " ";
                        }
                    },
                    min: 0
                };
                
            this.tooltip =  {
                    headerFormat: ' ',
                    pointFormat: '<b>{series.name}:</b> {point.y}',                    
                    useHTML: true
                };                
        };         
        
        this.processToLine = function (data, parentObj) {

            var values = [], chart, sugar_date, sugar_format, series;

            if (typeof data.countSeries !== "undefined") {

                parentObj.formatLine(data);                
                parentObj.xAxis.categories = [];                
                
                for (var i = 0; i < data.countSeries.length; i++) {

                    sugar_date   = Date.create(data.countSeries[i].date);
                    sugar_format = Monet.I18n.locale.dateFormat.replace("dd", "{dd}")
                                        .replace("MM", "{MM}")
                                        .replace("yyyy", "{yyyy}"); 
                    
                    columnFormattedValue = sugar_date.format(sugar_format);
                    
                    parentObj.xAxis.categories.push(columnFormattedValue);
                    
                    values.push(
                        data.countSeries[i].countValue                        
                    );

                }

            }
            
            parentObj.create();
            chart = parentObj.highChart;            
            
            chart.addSeries({
                name: data.yAxis,
                data : values
            });                     
            
        };        

        this.process = function (data, parentObj) {
            
            switch (this.type) {
            case "spline":
                this.processToLine(data, parentObj);
                break;            
            case "pie":
                this.processToPie(data, parentObj);
                break;
            case "column":
                this.processToBars(data, parentObj);
                break;
            case "bar":
                this.processToBars(data, parentObj);
                break;

            default:
                this.processToBars(data, parentObj);                
                break;
            }

        };
        
        this.allowTypes = function () {
            
            var types;
            
            types = [{
                value: "spline", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.spline")
            }, {
                value: "bar", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.bar")
            }, {
                value: "column", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.column") 
            }, {
                value: "pie", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.pie")
            }];
            
            return types;
            
        };        
    }

    return NumberOf;

})();

Greenmile.Dashboards.Chart.TopResults = (function () {

    TopResults.prototype = new Greenmile.Dashboards.Chart();

    function TopResults() {
        
        this.formatPie = function (data) {
          
            this.yAxis.title.text = Monet.I18n.getResourcesByKey(data.yAxis);
            
            this.xAxis = {
                    labels: {
                        formatter: function () {                                
                            return  " ";
                        }
                    }                        
            };

            this.tooltip = {
                formatter: function () {
                    return '<b>'+ Monet.I18n.getResourcesByKey(this.point.name) +'</b>: '+ this.percentage.toFixed(2) +' %';
                }
            };
            
            this.plotOptions = {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            color: '#000000',
                            connectorColor: '#000000',
                            formatter: function () {
                                return '<b>'+ Monet.I18n.getResourcesByKey(this.point.name) +'</b>: '+ this.percentage.toFixed(2) +' %';
                            }
                        }
                    }
                };             
            
        };
        
        this.processToPie = function (data, parentObj) {

            var values = [], chart;

            if (typeof data.topResults !== "undefined") {
                
                this.formatPie(data);

                for (var i = 0; i < data.topResults.length; i++) {

                    parentObj.format(data);
                    parentObj.create();
                    chart = parentObj.highChart;
                    
                    values.push([
                        data.topResults[i].description,
                        data.topResults[i].value                        
                    ]);

                }

            }
            
            chart.addSeries({
                type: 'pie',                     
                data : values
            });                        
            
        };   
        
        this.formatBar = function (data) {
            
            this.yAxis.title.text = Monet.I18n.getResourcesByKey(data.yAxis);
            
            this.xAxis = {
                    labels: {
                        formatter: function () {                                
                            return  " ";
                        }
                    }                        
            };             
            
            this.tooltip =  {
                headerFormat: ' ',
                pointFormat: '<b>{series.name}:</b> {point.y}',                    
                useHTML: true
            };            
            
        };

        this.processToBars = function (data, parentObj) {

            var chart;
            
            if (typeof data.topResults !== "undefined") {
                
                this.formatBar(data);                
                
                parentObj.create();
                chart = parentObj.highChart;
                
                for (var i = 0; i < data.topResults.length; i++) {

                    if (typeof chart.series[i] === "undefined") {

                        chart.addSeries({
                            name : Monet.I18n.getResourcesByKey(
                                data.topResults[i].description
                            ),
                            data : [data.topResults[i].value]
                        });

                    } else {
                        chart.series[i].setData(
                                [data.topResults[i].value]
                        );
                    }

                }

            }

        };
        
        this.process = function (data, parentObj) {
            
            switch (this.type) {
            case "pie":
                this.processToPie(data, parentObj);
                break;
            case "column":
                this.processToBars(data, parentObj);
                break;
            case "bar":
                this.processToBars(data, parentObj);
                break;

            default:
                this.processToBars(data, parentObj);                
                break;
            }

        };        
        
        this.allowTypes = function () {
            
            var types;
            
            types = [{
                value: "bar", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.bar")
            }, {
                value: "column", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.column") 
            }, {
                value: "pie", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.pie")
            }];
            
            return types;
            
        };        
    }

    return TopResults;

})();

Greenmile.Dashboards.Chart.CountSeries = (function () {

    CountSeries.prototype = new Greenmile.Dashboards.Chart();

    function CountSeries() {

        this.process = function (data, parentObj) {

            var chart;
            
            if (typeof data.countSeries !== "undefined") {
                
                parentObj.yAxis.title.text = data.yAxis;
                parentObj.create();
                chart = parentObj.highChart;
                
                for (var i = 0; i < data.countSeries.length; i++) {

                    if (typeof chart.series[i] === "undefined") {

                        chart.addSeries({
                            name : Monet.I18n.getResourcesByKey(data.countSeries[i].description),
                            data : [data.countSeries[i].value]
                        });

                    } else {
                        chart.series[i].setData(
                                [data.countSeries[i].value]
                        );
                    }

                }

            }

        };
        
        this.allowTypes = function () {
            
            var types;
            
            types = [{
                value: "line", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.line")
            }, {
                value: "area", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.area")
            }, {
                value: "bar", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.bar")
            }, {
                value: "column", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.column") 
            }, {
                value: "pie", 
                description: Monet.I18n.getResourcesByKey("Dashboard.Kpi.pie")
            }];
            
            return types;
            
        };        
    }

    return CountSeries;

})();

Greenmile.Dashboards.Chart.YearTo = (function () {

    YearTo.prototype = new Greenmile.Dashboards.Chart();

    function YearTo() {
        
        this.formatValue = function (value) {
            return value;
        };
        
        this.process = function (data, parentObj) {
            
            var container      = document.getElementById("chartBox_" + this.kpiView.id);
            var textContainer  = document.querySelector("#chartBox_" + this.kpiView.id + " .chartBoxValue");
            var formattedValue = this.formatValue(this.data.countValue);
            var loading        = document.querySelector(
                    "#chartBox_" + this.kpiView.id + " .highcharts-loading"
            );
            
            var chartBoxValue;
            
            if (textContainer) {
                textContainer.innerHTML = formattedValue;
            } else {
                
                chartBoxValue = document.createElement("div");
                chartBoxValue.className = "chartBoxValue";
                chartBoxValue.innerHTML = formattedValue;
                
                container.appendChild(chartBoxValue);

            }
            
            loading.removeChild(loading.firstChild);
            
        };        
        
        this.allowTypes = function () {
            
            return false;
            
        };
        
    }

    return YearTo;

})();

Greenmile.Dashboards.Chart.DISTANCE_DEVIATION = (function () {

    DistanceDeviation.prototype = new Greenmile.Dashboards.Chart.Irregular();

    function DistanceDeviation() {
        
        this.format = function (data) {
          
            this.xAxis = {
                    labels: {
                        formatter: function () {
                            
                            var dateFunc = new Greenmile.Date.GeneralFunctions();
                            var formattedValue = dateFunc.formateDateByLocale(this.value);    
                            return  formattedValue;
                        }
                    }                        
            };                 
            
            this.yAxis = {
                title: {
                    text: Monet.I18n.getResourcesByKey(data.yAxis)
                },     
                labels: {
                    formatter: function () {

                        var formattedValue = "";
                        var calcs = new Greenmile.Calculos.GeneralFunctions();

                        if (Monet.Session.User.unitSystem === "NON_METRIC") {
                            formattedValue = calcs.convertMettersToMilles(this.value);
                            formattedValue += " " + Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.miles");
                        } else {
                            formattedValue = calcs.convertMettersToKilometters(this.value);
                            formattedValue += " " + Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.kilometers");
                        }

                        return  formattedValue;
                    }
                }
            };
            
            this.tooltip =  {
                headerFormat: ' ',
                formatter: function () {
                    
                    var formattedValue = "";
                    var calcs = new Greenmile.Calculos.GeneralFunctions();

                    if (Monet.Session.User.unitSystem === "NON_METRIC") {
                        formattedValue = calcs.convertMettersToMilles(this.y);
                        formattedValue += " " + Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.miles");
                    } else {
                        formattedValue = calcs.convertMettersToKilometters(this.y);
                        formattedValue += " " + Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.kilometers");
                    }
                    
                    return Monet.I18n.getResourcesByKey(this.series.name) + '<b> ' + formattedValue + '</b>';
                },
                useHTML: true
            };            
                        
            
        };
        
    }

    return DistanceDeviation;

})();

Greenmile.Dashboards.Chart.SERVICE_TIME_DEVIATION = (function () {

    ServiceTimeDeviation.prototype = new Greenmile.Dashboards.Chart.Irregular();

    function ServiceTimeDeviation() {
        
        this.process = function (data, parentObj) {

            var values, chart;

            if (typeof data.kpiSeries !== "undefined") {
                
                parentObj.yAxis = {
                        title: {
                            text: Monet.I18n.getResourcesByKey(data.yAxis)
                        },     
                        labels: {
                            formatter: function () {
                                
                                var dateFunc = new Greenmile.Date.GeneralFunctions();
                                var formattedValue = dateFunc.convertTimeToDaysHoursMinutesAndSeconds(this.value*60000);    
                                return  formattedValue;
                            }
                        }
                };
                                
                parentObj.xAxis = {
                        labels: {
                            formatter: function () {
                                
                                var dateFunc = new Greenmile.Date.GeneralFunctions();
                                var formattedValue = dateFunc.formateDateByLocale(this.value);    
                                return  formattedValue;
                            }
                        }                        
                }; 
                
                parentObj.tooltip =  {
                        headerFormat: ' ',
                        formatter: function () {
                            
                            var dateFunc   = new Greenmile.Date.GeneralFunctions();
                            var formattedY = dateFunc.convertTimeToDaysHoursMinutesAndSeconds(this.y*60000);
                            var formattedX = dateFunc.formateDateByLocale(this.x);
                            
                            formattedValue = formattedX + " <b>" + formattedY + "</b>";
                            
                            return formattedValue;
                        },
                        useHTML: true
                };                
                
                parentObj.series = [];                
                parentObj.create();
                
                chart = parentObj.highChart;

                for (var i = 0; i < data.kpiSeries.length; i++) {

                    values = [];

                    for (var cont = 0; cont < data.kpiSeries[i].values.length; cont++) {

                        for (var x in data.kpiSeries[i].values[cont]) {
                            
                            if (typeof x !== "function") {
                            
                                for (z in data.kpiSeries[i].values[0]) {
                                    
                                    if (typeof z !== "function") {

                                        values.push([
                                             new Date(
                                                     Object.keys(data.kpiSeries[i].values[cont])[0]
                                             ).getTime(), 
                                             Object.values(data.kpiSeries[i].values[cont])[0] 
                                        ]);
                                    
                                    }
                                }
                            }
                        }

                    }

                    if (typeof chart.series[i] === "undefined") {

                        chart.addSeries({
                            name : Monet.I18n.getResourcesByKey(data.kpiSeries[i].name),
                            data : values
                        });

                    } else {
                        chart.series[i].setData(values);
                    }

                }

            }

        };
    }

    return ServiceTimeDeviation;

})();

Greenmile.Dashboards.Chart.TRAVEL_TIME_DEVIATION = (function () {

    TravelTimeDeviation.prototype = new Greenmile.Dashboards.Chart.Irregular();

    function TravelTimeDeviation() {
        
        this.process = function (data, parentObj) {

            var values, chart;

            if (typeof data.kpiSeries !== "undefined") {
                
                parentObj.yAxis = {
                        title: {
                            text: Monet.I18n.getResourcesByKey(data.yAxis)
                        },     
                        labels: {
                            formatter: function () {
                                
                                var dateFunc = new Greenmile.Date.GeneralFunctions();
                                var formattedValue = dateFunc.convertTimeToDaysHoursMinutesAndSeconds(this.value*60000);    
                                return  formattedValue;
                            }
                        }
                };
                                
                parentObj.xAxis = {
                        labels: {
                            formatter: function () {
                                
                                var dateFunc = new Greenmile.Date.GeneralFunctions();
                                var formattedValue = dateFunc.formateDateByLocale(this.value);    
                                return  formattedValue;
                            }
                        }                        
                }; 
                
                parentObj.tooltip =  {
                        headerFormat: ' ',
                        formatter: function () {
                            
                            var dateFunc   = new Greenmile.Date.GeneralFunctions();
                            var formattedY = dateFunc.convertTimeToDaysHoursMinutesAndSeconds(this.y*60000);
                            var formattedX = dateFunc.formateDateByLocale(this.x);
                            
                            formattedValue = formattedX + " <b>" + formattedY + "</b>";
                            
                            return formattedValue;
                        },
                        useHTML: true
                };                
                
                parentObj.series = [];                
                parentObj.create();
                
                chart = parentObj.highChart;

                for (var i = 0; i < data.kpiSeries.length; i++) {

                    values = [];

                    for (var cont = 0; cont < data.kpiSeries[i].values.length; cont++) {

                        for (var x in data.kpiSeries[i].values[cont]) {
                            
                            if (typeof x !== "function") {
                            
                                for (z in data.kpiSeries[i].values[0]) {
                                    
                                    if (typeof z !== "function") {

                                        values.push([
                                             new Date(
                                                     Object.keys(data.kpiSeries[i].values[cont])[0]
                                             ).getTime(), 
                                             Object.values(data.kpiSeries[i].values[cont])[0] 
                                        ]);
                                    
                                    }
                                }
                            }
                        }

                    }

                    if (typeof chart.series[i] === "undefined") {

                        chart.addSeries({
                            name : Monet.I18n.getResourcesByKey(data.kpiSeries[i].name),
                            data : values
                        });

                    } else {
                        chart.series[i].setData(values);
                    }

                }

            }

        };
    }

    return TravelTimeDeviation;

})();

Greenmile.Dashboards.Chart.DELIVERY_STATUS = (function () {

    DeliveryStatus.prototype = new Greenmile.Dashboards.Chart.Regular();

    function DeliveryStatus() {
        
        this.formatBars = function (data) {
            
            this.xAxis = {
                    labels: {
                        formatter: function () {                                
                            return  " ";
                        }
                    }                        
            };            
            
            this.yAxis = {
                    title: {
                        text: Monet.I18n.getResourcesByKey(data.yAxis)
                    },     
                    labels: {
                        formatter: function () {
                            return  this.value + "%";
                        }
                    }
            };

            this.plotOptions = {};
                
            this.tooltip =  {
                    headerFormat: ' ',
                    pointFormat: '<b>{series.name}:</b> {point.y:.2f} %' ,                    
                    useHTML: true
                };             
            
        }; 
        
    }

    return DeliveryStatus;

})();

Greenmile.Dashboards.Chart.STOPS_IN_SEQUENCE = (function () {

    StopsInSequence.prototype = new Greenmile.Dashboards.Chart.Regular();

    function StopsInSequence() {

        this.formatBars = function (data) {
            
            this.xAxis = {
                    labels: {
                        formatter: function () {                                
                            return  " ";
                        }
                    }                        
            };            
            
            this.yAxis = {
                    title: {
                        text: Monet.I18n.getResourcesByKey(data.yAxis)
                    },     
                    labels: {
                        formatter: function () {
                            return  this.value + "%";
                        }
                    }
            };
            
            this.plotOptions = {};
                
            this.tooltip =  {
                    headerFormat: ' ',
                    pointFormat: '<b>{series.name}:</b> {point.y:.2f} %' ,                    
                    useHTML: true
                };             
            
        };         
        
    }

    return StopsInSequence;

})();

Greenmile.Dashboards.Chart.TOP_UNDELIVERABLE_CODE = (function () {

    TopUndeliverableCode.prototype = new Greenmile.Dashboards.Chart.TopResults();

    function TopUndeliverableCode() {
        this.topValue = true;
    }

    return TopUndeliverableCode;

})();

Greenmile.Dashboards.Chart.TOP_CANCEL_CODE = (function () {
    
    TopCancelCode.prototype = new Greenmile.Dashboards.Chart.TopResults();

    function TopCancelCode() {        
        this.topValue = true;
    }

    return TopCancelCode;

})();

Greenmile.Dashboards.Chart.TOP_REDELIVERY_CODE = (function () {
    
    TopRedeliveryCode.prototype = new Greenmile.Dashboards.Chart.TopResults();

    function TopRedeliveryCode() {
        this.topValue = true;
    }

    return TopRedeliveryCode;

})();

Greenmile.Dashboards.Chart.TOP_CUSTOMERS_DEVIATION = (function () {
    
    TopCustomersDeviation.prototype = new Greenmile.Dashboards.Chart.Regular();
    
    function TopCustomersDeviation() {
        this.topValue = true;
    }

    return TopCustomersDeviation;

})();

Greenmile.Dashboards.Chart.NUMBER_OF_ROUTES = (function () {

    NumberOfRoutes.prototype = new Greenmile.Dashboards.Chart.NumberOf();

    function NumberOfRoutes() {
        // do something
    }

    return NumberOfRoutes;

})();

Greenmile.Dashboards.Chart.NUMBER_OF_STOPS = (function () {

    NumberOfStops.prototype = new Greenmile.Dashboards.Chart.NumberOf();

    function NumberOfStops() {
        // do something
    }

    return NumberOfStops;

})();

Greenmile.Dashboards.Chart.NUMBER_OF_ORDERS = (function () {

    NumberOfOrders.prototype = new Greenmile.Dashboards.Chart.NumberOf();

    function NumberOfOrders() {
        // do something
    }

    return NumberOfOrders;

})();

Greenmile.Dashboards.Chart.YTN_DISTANCE = (function () {

    YtnDistance.prototype = new Greenmile.Dashboards.Chart.YearTo();

    function YtnDistance() {
        
        this.formatValue = function (value) {
            
            var calcs = new Greenmile.Calculos.GeneralFunctions();
            var formattedValue = null;
            
            if (Monet.Session.User.unitSystem === "NON_METRIC") {
                formattedValue = calcs.convertMettersToMilles(value);
                formattedValue += " " + Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.miles");
            } else {
                formattedValue = calcs.convertMettersToKilometters(value);
                formattedValue += " " + Monet.I18n.getResourcesByKey("Greenmile.UnitMetrics.kilometers");
            }
            
            return formattedValue;
        };
    }

    return YtnDistance;

})();

Greenmile.Dashboards.Chart.YTN_CUSTOMERS_SERVICED = (function () {

    YtnCustomersServiced.prototype = new Greenmile.Dashboards.Chart.YearTo();

    function YtnCustomersServiced() {
        // do something
    }

    return YtnCustomersServiced;

})();

Greenmile.Dashboards.Chart.YTN_STOPS = (function () {

    YtnStops.prototype = new Greenmile.Dashboards.Chart.YearTo();

    function YtnStops() {
        // do something
    }

    return YtnStops;

})();

Greenmile.Dashboards.Chart.YTN_ORDERS = (function () {

    YtnOrders.prototype = new Greenmile.Dashboards.Chart.YearTo();

    function YtnOrders() {
        // do something
    }

    return YtnOrders;

})();