/*
 * Utiliza o Globalize para obter o resource da lista de resources e quando a tradução pedir
 * subistituições as fará respeitando seus formatos
 *
 * @params {string} resource
 * @params {array} values, na mesma ordem das variáveis da string
 *
 * ex: "Essa parada tem %s pedidos, vindos de %s stops, que totalizam %f kilos e foram emitidos em %D"
 *
 * [String, String, Decimal Float, Date]
 *
 */

Monet.I18n = {

    locale : {},

    resources : {},

    translateInterface : function() {

        /*
         * Pesca jquery
         *
         * por ID $("#page_container")
         *
         * por class $(".i18nResource")
         *
         * por estrutura mais complexa: $(".ui-tabs-nav li a")
         *
         */

        var that = this;

        //buscando os labels do pagelayout
        $.each($(".i18nResource"), function(index, elementToTranslate) {
        	
        	that.getResourceValues(elementToTranslate);

        });

        //buscando os botoes do pagelayout
        $.each($(".ui-tabs-nav li a"), function(index, elementToTranslate) {

            that.getResourceValues(elementToTranslate);

        });
        
        //buscando os elementos options de um select(combo box) do pagelayout
        $.each($("option.i18nResource"), function(index, elementToTranslate) {

            that.getResourceValues(elementToTranslate);

        });

        //buscando os elementos do grid
        $.each($(".DataTables_sort_wrapper"), function(index, elementToTranslate) {

            var translatedResource = "";
            var resourceKey = "";
            var htmlHeader = "";
            var innerHMTL;
            
            innerHMTL = elementToTranslate.innerHTML.toLocaleLowerCase();

            resourceKey = elementToTranslate.innerHTML.substring(0, innerHMTL.indexOf("<span"));

            htmlHeader = elementToTranslate.innerHTML.substring(innerHMTL.indexOf("<span"));

            if (resourceKey !== "") {

            	translatedResource = Monet.I18n.resources[resourceKey];

            	if ( typeof (translatedResource) !== "undefined") {
            	
            		if (translatedResource.match(/{.*}/) != null ) {
                    	
            			originalTranslate = Monet.I18n.resources[resourceKey];
                    	miolo = translatedResource.match(/{.*}/);
                    	key = miolo[0].replace("{", "").replace("}", "");
                    	translation = originalTranslate.replace("{"+ key +"}", Monet.Session.Configurations[key]);
                    	elementToTranslate.innerHTML = translation + htmlHeader;
                    	
                    } else {
                    	elementToTranslate.innerHTML = translatedResource + htmlHeader;
                    }
            		
            	}

            }

        });
        
        $.each($(".dataTable tr th"), function(index, elementToTranslate){
            
            var translatedResource = "";
            var resourceKey = elementToTranslate.innerHTML;
            var htmlHeader = "";
            
            if(elementToTranslate.innerHTML !== "") {
               
               translatedResource = Monet.I18n.resources[elementToTranslate.innerHTML];
            	
               if (typeof (translatedResource) !== "undefined") {
               
            	   if(translatedResource.match(/{.*}/) != null) {
            		   
            		   miolo = translatedResource.match(/{.*}/);
            		   key = miolo[0].replace("{", "").replace("}", "");
            		   translation = translatedResource.replace("{"+ key +"}", Monet.Session.Configurations[key]);
            		   elementToTranslate.innerHTML = translation;
            		   
            	   } else {
            		   elementToTranslate.innerHTML = translatedResource;
            	   }
            	   
               }
                
            }            
                
        });
        
        //buscando os elementos do submenu
        $.each($(".nav li ul#menu1 li a"), function(index, elementToTranslate) {

        	var translatedResource = "";
            var resourceKey = "";
            var htmlHeader = "";
            var innerHMTL;
            
            innerHMTL = elementToTranslate.innerHTML.toLocaleLowerCase();

            resourceKey = elementToTranslate.innerHTML.substring(0, innerHMTL.indexOf("<i class"));

            htmlHeader = elementToTranslate.innerHTML.substring(innerHMTL.indexOf("<i class"));

            if (resourceKey !== "") {

                translatedResource = Monet.I18n.resources[resourceKey];
                
                if (typeof (translatedResource) !== "undefined") {
                    elementToTranslate.innerHTML = translatedResource + htmlHeader;
                }

            }

        });
        
        $.each($("li[librarycheckid] a"), function(index, elementToTranslate) {
        	var html = elementToTranslate.innerHTML;
        	var resKey = html.substring(html.indexOf("/ins>")+5);
        	var value = Monet.I18n.resources[resKey];
        	
        	if (value !== undefined) {
	        	html = html.replace(resKey, value);
	        	elementToTranslate.innerHTML = html;
        	}
        });
        
        $.each($("li[libraryactionid] a"), function(index, elementToTranslate) {
        	var html = elementToTranslate.innerHTML;
        	var resKey = html.substring(html.indexOf("/ins>")+5);
        	var value = Monet.I18n.resources[resKey];
        	
        	if (value !== undefined) {
	        	html = html.replace(resKey, value);
	        	elementToTranslate.innerHTML = html;
        	}
        });
        
        $.each($("li[libraryid] a"), function(index, elementToTranslate) {
        	var html = elementToTranslate.innerHTML;
        	var resKey = html.substring(html.indexOf("/ins>")+5);
        	var value = Monet.I18n.resources[resKey];
        	
        	if (value !== undefined) {
	        	html = html.replace(resKey, value);
	        	elementToTranslate.innerHTML = html;
        	}
        });

        //buscando os elementos do menu
        $.each($(".nav li a"), function(index, elementToTranslate) {

            that.getResourceValues(elementToTranslate);

        });
        
        //buscando os elementos do dropdwond de lingua
        $.each($("a.ui-corner-all"), function(index, elementToTranslate) {

            that.getResourceValues(elementToTranslate);

        });
        
        //buscando os elementos do dropdwond de lingua
        $.each($("#preferedLocale_description"), function(index, elementToTranslate) {

            if(	Monet.I18n.resources[$(elementToTranslate).val()] != undefined ) {	            	
            	$(elementToTranslate).val(Monet.I18n.resources[$(elementToTranslate).val()]);            	
            }            

        });
        
        $.each($(".ui-tooltip-title"), function(index, elementToTranslate){
            $(elementToTranslate).html(Monet.I18n.resources[$(elementToTranslate).html()]);
        });
        
        
        $("div[action=previous]").html(Monet.I18n.resources["Grid.pagination.previous"]);
        $("div[action=next]").html(Monet.I18n.resources["Grid.pagination.next"]);
        
        $.each($(".i18nResourceImage"), function(index, elementToTranslate){
            $(elementToTranslate).attr("alt", Monet.I18n.resources[$(elementToTranslate).attr("alt")]);
            $(elementToTranslate).attr("title", Monet.I18n.resources[$(elementToTranslate).attr("title")]);
        });        
        
        
    },
    
    getResourceValues : function(elementToTranslate) {

        var translation = "";

        switch (elementToTranslate.tagName) {
            case "INPUT":

                translation = Monet.I18n.resources[$(elementToTranslate).val()];
                
                placeHolder = Monet.I18n.resources[$(elementToTranslate).attr("placeholder")];
                
                //analisa se o tipo do botao est√° definido
                if ( typeof (translation) !== "undefined") {
                    $(elementToTranslate).val(translation);
                    
                }
                
                if(typeof(placeHolder) !== "undefined") {
                    $(elementToTranslate).attr("placeholder", placeHolder);    
                }                
                break;

            case "SPAN":

                //analisa se o tipo do elemento html est√° definido
                translation = Monet.I18n.resources[$(elementToTranslate).html()];
                
                originalTranslate = Monet.I18n.resources[$(elementToTranslate).html()];
                
                if ( typeof (translation) !== "undefined") {
                	
                	if (translation.match(/{.*}/) != null ) {
                    	
                		Monet.I18n.changeResource(translation, elementToTranslate);
                    	
                    } else {
                	
                    	$(elementToTranslate).html(translation);
                    	
                    }
                }
                break;

            case "DIV":

                //analisa se o tipo do elemento html est√° definido
                translation = Monet.I18n.resources[$(elementToTranslate).html().trim()];
                
                if ( typeof (translation) !== "undefined") {
                    $(elementToTranslate).html(translation);
                }
                break;

            case "A":

                //analisa se o tipo do elemento html est√° definido
            	translation = Monet.I18n.resources[$.trim($(elementToTranslate).html())];

            	if ( typeof (translation) !== "undefined") {
                    $(elementToTranslate).html(translation);
                }
                break;
                
            case "OPTION":

                //analisa se o tipo do elemento html est√° definido
                translation = Monet.I18n.resources[$.trim($(elementToTranslate).html())];
                
                if ( typeof (translation) !== "undefined") {
                    $(elementToTranslate).html(translation);
                }
                break;
            
            default:
            	$(elementToTranslate).html(Monet.I18n.resources[$.trim($(elementToTranslate).html())]);
            	break;
        }
    },

    checkResources : function() {
        
        if(Monet.I18n.locale != null) {
            if(typeof(Monet.I18n.locale.id) === "undefined") {
                Monet.I18n.getFullData();   
            }            
        }
        
        Monet.I18n.translateInterface();                  
        
    },
    
    changeResource : function(translation, elementToTranslate) {
    	
    	originalTranslate = Monet.I18n.resources[$(elementToTranslate).html()];
    	miolo = translation.match(/{.*}/);
    	key = miolo[0].replace("{", "").replace("}", "");
    	
    	if(key === "distance") {
    	    
            if( Monet.Session.User != undefined && Monet.Session.User["unitSystem"] != "METRIC"){
                translation = originalTranslate.replace(
                    "{"+ key +"}", 
                    Monet.I18n.getResourcesByKey("UnitSystems.Miles.abbreviation"
                ));
            } else {
                translation = originalTranslate.replace(
                    "{"+ key +"}", 
                    Monet.I18n.getResourcesByKey("UnitSystems.Meters.abbreviation"
                ));
            }
    	    
    	} else {
    	   translation = originalTranslate.replace("{"+ key +"}", Monet.Session.Configurations[key]);    
    	}
    	
    	
    	$(elementToTranslate).html(translation);
    	
    },

    getResource : function() {

        var keys = Object.keys(Monet.I18n.resources);
        var that = this;
        
        if (typeof(Monet.I18n.locale.id) !== "undefined") {
            
            $.ajax({
                url: 'I18NResource/filter?criteria={"filters":["key", "value"]}',
                type: 'POST',
                data: '{"i18nlocale": {"language":"' + Monet.I18n.locale.language +'"}, "module": {"key":"GreenMileTrack"}}',
                async : false,
                dataType: 'json',
                'contentType': 'application/json',
                success: function(data) {

                	$.each(data, function(index, resource) {

                        Monet.I18n.resources[resource.key] = resource.value;

                    });
                    
                    that.createDatePikerTranslates();

                },
                
                error: function() {
                    
                    window.location = "#";
                }
            });
            
        }

    },

    getLocales : function() {

        var request = function() {
            
                $.ajax({
                    url : "I18NLocale/byUser",
                    type : 'GET',
                    async : false,
                    dataType : 'json',
                    success : function(data) {
    
                        Monet.I18n.locale = data;
                        
                        if(Monet.I18n.locale != null) {
                            Globalize.culture(Monet.I18n.locale.language);    
                        }
                        
                        Monet.I18n.getResource();
    
                    }
                });            
            
        };

        if(Monet.Session.isLogged) {

            if(Monet.I18n.locale === null) {
             
                request();
                
            } else {
                
                if(typeof(Monet.I18n.locale.id) === "undefined") {
                    
                    request();
                    
                }
                
            }
            
        }    

    },

    getFullData : function() {
        
    	Monet.I18n.getLocales();        

    },
    
    getResourcesByKey : function(key){
		
		var value = Monet.I18n.resources[key];
		
		if(typeof(value)!=="undefined"){
			return value;
		}
		
		return key;
	},

	createDatePikerTranslates: function() {
	    
        $.timepicker.regional[Monet.I18n.locale.language] = {
            timeOnlyTitle: 'Choose Time',
            timeText: Monet.I18n.getResourcesByKey("DateTimePicker.Time"),
            hourText: Monet.I18n.getResourcesByKey("DateTimePicker.Hour"),
            minuteText: Monet.I18n.getResourcesByKey("DateTimePicker.Minute"),
            secondText: Monet.I18n.getResourcesByKey("DateTimePicker.Second"),
            millisecText: 'Millisecond',
            timezoneText: 'Time Zone',
            currentText: Monet.I18n.getResourcesByKey("DateTimePicker.Now"),
            closeText: Monet.I18n.getResourcesByKey("DateTimePicker.Done"),
            timeFormat: 'hh:mm',
            amNames: ['AM', 'A'], 
            pmNames: ['PM', 'P']
        };
        
        $.timepicker.setDefaults($.timepicker.regional[Monet.I18n.locale.language]);	    
	    
	}

};