Monet.Maps = {
    defaults: {
        serverUrl: "GetWMSMap",
        format : 'image/png8',
        resolutions: [0.3515625, 0.17578125, 0.087890625, 0.0439453125, 0.02197265625
                       , 0.010986328125, 0.0054931640625, 0.00274658203125, 0.001373291015625
                       , 6.866455078125E-4, 3.4332275390625E-4, 1.71661376953125E-4
                       , 8.58306884765625E-5, 4.291534423828125E-5, 2.1457672119140625E-5
                       , 1.0728836059570312E-5, 5.364418029785156E-6, 2.682209014892578E-6],
        open_layers : {
            dotsPerInch: 90.71428571428572,
            onImageLoadErrorColor: 'transparent'
            
        }
        
    }
};

/**
 * function marker(settings)
 * @params {Object} settings.latitude,
 *                  settings.longitude,
 *                  settings.map,
 *                  settings.projection,
 *                  settings.stop,
 *                  settings.type
 * @returns {Marker}
 *
 * Cria um Marker pronto para adicionar no mapa
 *
 */
Monet.Maps.Marker = function(settings) {

    if (settings != undefined) {
        this.settings = settings;
    } else {
        return false;
    }

    /**
     * function getIcon(type)
     * @params {String} type
     * @returns {String}
     *
     * Valores possíveis "STOP", "ORIGIN", "DESTINATION", "TRUCK"
     *
     * Dependendo do valor passado, será devolvido a URL correta para a imagem do Marker
     */

    this.getIcon = function(type) {

        switch (type) {
            case "STOP":
                return 'resources/images/map/markers/marker_stop_unvisited.png';
                break;
            case "ORIGIN":
                return 'resources/images/map/markers/origin.png';
                break;
            case "DESTINATION":
                return 'resources/images/map/markers/marker.png';
                break;
            case "TRUCK":
                return 'resources/images/map/markers/marker.png';
                break;
            case "PENDING_STOP":
                return 'resources/images/map/markers/marker_stop_visited.png';
                break;                                
            default:
                return 'resources/images/map/markers/marker.png';
        };

    };

    var mkr = new OpenLayers.Marker(
        new OpenLayers.LonLat(
            this.settings.longitude, this.settings.latitude
        ).transform(
            new OpenLayers.Projection(
                this.settings.projection
            ), this.settings.map.getProjectionObject()
        ), new OpenLayers.Icon(
            this.getIcon(this.settings.type), 
            this.settings.size, this.settings.offset));

    return mkr;

};

/**
 * function addMarkerToMap(settings)
 *
 * @params {Object} settings
 * @returns {This}
 *
 * Instancia um novo Marker, adiciona ao layer passado e atribui ações a ele
 */
Monet.Maps.addMakerToMap = function(settings) {

    if (settings == undefined) {
        return false;
    };

    marker = Monet.Maps.Marker({
        size : settings.size,
        latitude : settings.latitude,
        longitude : settings.longitude,
        offset : settings.offset,
        projection : settings.projection,
        stop : settings.stop,
        map : settings.map,
        type : settings.type
    });

    settings.layer.addMarker(marker);

    marker.events.register('mouseover', marker, function(evt) {

        settings.callback(settings.stop);

        OpenLayers.Event.stop(evt);
    });

    return this;

};

Monet.Maps.Updater = function() {

    var table, tabelOrder;
    var tableViewMonitor = App.Views.RouteMonitor;
    var tableView        = App.Views.Map;
    var mapsRouteView    = App.Views.MapsRoute;
    var mapCentral       = new App.Routers.Maps();
    var routeRouter      = new App.Routers.RouteMonitorRoute();
    var stopRouter       = new App.Routers.RouteMonitorStops();
    var orderRouter      = new App.Routers.RouteMonitorOrders();
    var lineItemRouter   = new App.Routers.RouteMonitorLineItems();
    var mainMapLatLng, mainMapZoom, mainMapLatLng;

    this.go = function(){

        App.Objects.RouteDetails.processMapUpdates();
        
        if($("#RouteMonitor").size() != 0) {
            
            tableType = tableViewMonitor.tableChecker();
            
            if(tableType === "RouteMonitorRoute") {
                this.route();    
            } else {
                if(tableType === "RouteMonitorStop") {
                    this.stop();
                } else {
                    if(tableType === "RouteMonitorOrders") {
                        this.order();
                    } else {
                        this.lineItem();
                    }
                }
            }
        }
        
        if($("#Maps").size() != 0) {

            if(Monet.Session.mainMap.map !== "") {
                
                if($("#Maps").parent().find("li:first").hasClass("ui-state-active")) {

                	mainMapZoom   = Monet.Session.mainMap.map.getZoom();
                    mainMapLatLng = Monet.Session.mainMap.map.getCenter();
                    
                    var mapStorage = new Greenmile.Storage.StoreMapPosition();
                    mapStorage.setPosition(mainMapLatLng, mainMapZoom);
    
                    mapCentral.getEquipmentPositions();
                    
                }
            }
            
            this.map();
            
            MakeLayouts.screenConfigurationFunctions();    
            
        }        
        

    };   

    this.map = function() {
        
        if(!App.Forms["RouteTracker"].pagination.blocked) {
            
            if($(".ui-state-default[aria-selected=true]").attr("aria-controls") === "Maps") {

                var filter = Monet.Session.Maps.mainMap.filters;
                App.Objects["RouteTracker"].filterGrid(filter);

            }
        }
        
    };

    this.route = function() {
        
        if(!App.Forms["RouteMonitorRoute"].pagination.blocked) {
            
            if($(".ui-state-default[aria-selected=true]").attr("aria-controls") === "RouteMonitor") {

                $("#" + $('.ui-tabs-panel:not(.ui-tabs-hide)').attr("id") + " .gridLoader").show();

                var filter = "%" + $("#routeMonitorTable_filter input").val() + "%";

                App.Objects["RouteMonitorRoute"].filterGrid(filter);

            }
        }
    };
    
    this.stop = function(){

        stopRouter.refreshRoutes();
                
    };
    
    this.order = function(){

        orderRouter.refreshRoutes();
        
    };
    
    this.lineItem = function() {

        lineItemRouter.refreshRoutes();
                
    };

};

