/**
 * Cria um filtro padrão para que o programador possa obter os many mais facilmente e não
 * repetir tanto código
 *
 * @params {object} {
 *     criteria: {string} define o critério da projection,
 *     entity: {string} é a entidade que é filha do model atual,
 *     entityId: {integer} é o id do model atual que será usado para compor o filtro
 * }
 *
 */

Monet.Model = {

    hasMany : function(obj) {

        var criteria = "";
        var parent = obj.parent;
        var success, entity, service;

        if ( typeof (obj) !== "undefined") {

            if ( typeof (obj.collection) === "undefined") {
                return false;
            }

            if ( typeof (obj.model) === "undefined") {
                return false;
            }

            if ( typeof (obj.parent) === "undefined") {
                return false;
            } else {
                entity = obj.parent.url().replace("/" + obj.parent.id, "").toLowerCase();
            }

            service = new obj.model().url().replace("/", "")

            if ( typeof (obj.options) !== "undefined") {

                if ( typeof (obj.options.criteria) !== "undefined") {
                    criteria = "?criteria=" + obj.options.criteria;
                }

                if ( typeof (obj.options.success) !== "undefined") {

                    successWrapper = (function(success, collection, model) {

                        return function(data) {

                            var col = new collection();

                            $.each(data, function(index, item) {

                                var mod = new model();

                                mod.set(item);
                                col.add(mod);

                            });

                            success(col);

                        };

                    })(obj.options.success, obj.collection, obj.model);

                }

            }

        }

        $.ajax({
            url : window.hostConf + "/" + service + '/filter' + criteria,
            type : 'POST',
            'contentType' : 'application/json',
            dataType : 'json',
            headers: {
               "Cookie": window.cookie
            },
            data : '{"' + entity + '":{"id": ' + obj.parent.id + '}}',
            success : function(data) {
                if ( typeof (successWrapper) !== "undefined") {
                    successWrapper(data);
                }
            }
        });
    },
    
    fetchWithCriteria: function(objParameter) {
        
        var model    = objParameter.model;
        var obj      = objParameter.options;         
        var modelId  = model.id;
        var service  = model.url().split("/")[0];
        var criteria = "?criteria=" + obj.criteria;
        var asyncValue 	 = true;
        
        if( typeof(obj.async) !== "undefined"){
        	asyncValue =  obj.async;
        }
        
        if(typeof(obj) !== "undefined") {
            
            if (typeof(obj.criteria) !== "undefined") {
                
                $.ajax({
                    url : window.hostConf + service + '/filter' + criteria,
                    type : 'POST',
                    'contentType' : 'application/json',
                    dataType : 'json',
                    data : '{"id": ' + modelId + '}',
                    async : asyncValue,
                    success : function(data) {
                        if(typeof(obj.success) !== "undefined") {
                            
                            model.set(data[0]);
                            
                            obj.success(model);
                        }
                    },
                    error : function(e, jqxhr, settings, exception){
                    	if(typeof(obj.error)!=="undefined"){
                    		obj.error(e, jqxhr, settings, exception);
                    	}
                    }
                });
                                
            } else {
                return false;
            }
                        
        } else {
            return false;
        }
        
    },

    searchWithCriteria: function(objParameter){

        var model          = objParameter.model;
        var obj            = objParameter.options;
        var searchJsonStr  = JSON.stringify(obj.searchJson);
        var service        = model.url().split("/")[0];
        var criteria       = "?criteria=" + obj.criteria;

        if(typeof(obj) !== "undefined") {

            if (typeof(obj.criteria) !== "undefined") {

                $.ajax({
                    url : window.hostConf + service + '/filter' + criteria,
                    type : 'POST',
                    'contentType' : 'application/json',
                    dataType : 'json',
                    data : searchJsonStr,

                    success : function(data) {
                        if(typeof(obj.success) !== "undefined") {

                            model.set(data[0]);

                            obj.success(model);
                        }
                    }
                });

            } else {
                return false;
            }

        } else {
            return false;
        }
    },
    searchAllWithCriteria: function(objParameter){
    	
    	var model          = objParameter.model;
    	var obj            = objParameter.options;
    	var searchJsonStr  = JSON.stringify(obj.searchJson);
    	var service        = model.url().split("/")[0];
    	var criteria       = "?criteria=" + obj.criteria;
    	
    	if(typeof(obj) !== "undefined") {
    		
    		if (typeof(obj.criteria) !== "undefined") {
    			
    			$.ajax({
    				url : window.hostConf + service + '/filter' + criteria,
    				type : 'POST',
                    headers: {
                        "Cookie": window.cookie
                    },
    				'contentType' : 'application/json',
    				dataType : 'json',
    				data : searchJsonStr,
    				
    				success : function(data) {
    					if(typeof(obj.success) !== "undefined") {
    						
    						model.set(data);
    						
    						obj.success(model);
    					}
    				}
    			});
    			
    		} else {
    			return false;
    		}
    		
    	} else {
    		return false;
    	}
    }
}; 