var Monet = Monet || {};
Monet.Session = Monet.Session || {};

Monet.Validators = {
    isEmail : function(email) {
        if (!email) {
            return true;
        }

        var emailRegex = /^([0-9a-zA-Z]+([_.-]?[0-9a-zA-Z]+)*@[0-9a-zA-Z]+[0-9,a-z,A-Z,.,-]*(.){1}[a-zA-Z]{2,4})+$/;
        return email.search(emailRegex) != -1;
    },
    
    isNumeric : function(numero) {
        
        if(!numero) {
            return true;
        }
        
        var numeroRegex = /^[0-9]+$/;
        return numero.search(numeroRegex) != -1;
    },

    isURL : function(url) {
        var urlRegex = /(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;
        return url.search(urlRegex) != -1;
    }
};

Monet.loginChecker = {

    isLogged : function() {

        $.ajax({
            url : 'LocationType',
            async: false,
            success : function() {
                Monet.Session.isLogged = true;
            },
            error : function() {
                Monet.Session.isLogged = false;
            }
        });
    }
};

Monet.navigation = {
    goTo : function(entity, action) {
        window.location = "#/" + entity + "/" + action;
    },
    openChild : function(e) {

        var link = "#/" + $("#" + e).parents(".ui-tabs-panel").attr("id") + "/" + model.id + "/" + $("#" + e).attr("entity");

        window.location = link;
    },
    openNewWithParentId : function() {
        window.location = window.location + "/new";
    }
};

/*
 * Controla o cache dos JSONs que descrevem os layouts dos formulários
 * @param {object}
 * @params {object} entity: A entidade a qual esse formulário faz referência
 * @params {string} crudStation: Em que etapa o cadastro está, pode ser list, new e edit

 cached: function(entity) {
 // O que fazer caso o formulário esteja em cache
 },
 notcached: function(entity) {
 // O que fazer caso não
 }
 *
 */

Monet.Cache = {

    check : function(settings) {

        if (settings != undefined) {
            this.settings = settings;
        } else {
            return false;
        }

        var that = this;
        var crudStation = that.settings.crudStation;

        Monet.DataMapper.checkNameSpace(this.settings.entity, ["layout", crudStation], function() {
            if (App.Forms[that.settings.entity]['layout'][that.settings.crudStation] != "") {
                if (that.settings.cached != undefined) {
                    that.settings.cached(that.settings.entity);
                }
            } else {
                if (that.settings.notcached != undefined) {
                    that.settings.notcached(that.settings.entity);
                }
            }
        });
    }
};

Monet.DataMapper = {
    map : {},
    push : function(field, value) {
        this.map[field] = value;
    },
    checkNameSpace : function(entity, group, callback_f) {
        if (App.Forms[entity] == undefined) {
            App.Forms[entity] = {};
        }

        $.each(group, function(i, space) {
            if (i != group.length - 1) {
                if (i > 0) {
                    if (App.Forms[entity][group[i-1]][space] == undefined) {
                        App.Forms[entity][group[i-1]][space] = {};
                    }
                } else {
                    if (App.Forms[entity][space] == undefined) {
                        App.Forms[entity][space] = {};
                    }
                }
            } else {
                if (i > 0) {
                    if (App.Forms[entity][group[i-1]][space] == undefined) {
                        App.Forms[entity][group[i-1]][space] = "";
                    }
                } else {
                    if (App.Forms[entity][space] == undefined) {
                        App.Forms[entity][space] = "";
                    }
                }
            }
        });

        callback_f();
    }
};

Monet.authentication = {

    login : function(callbackError) {

        var loginData = {};
        var user;
        var that = this;
        
        Monet.Session.targetUrl = null;

        loginData.j_password = $("#login_password").val();
        loginData.j_username = $("#login_username").val();

        $.ajax({
            url : "login",
            "dataType" : "json",
            type : "POST",
            data : loginData,
            success : function(data) {
                
                Monet.Session.isLogged = true;
                Monet.Session.targetUrl = data.targetUrl;                
                
                Monet.I18n.getLocales();
                
                that.getUserLoggedInfo();
                
            },
            
            error : function(e) {
                that.loginErrorCallback(e, callbackError);        
            }
        });
    },
    
    loginErrorCallback: function(e, callbackError){

        Monet.Session.isLogged = false;
        
        $.toast({
             message:"The username or password you entered is incorrect.",
             displayTime:3000,
             inTime:100,
             outTime:400,
             vPosition: "center",
             hPosition: "center"
        });
        
        //corrige o problema de exibicao do toast no IE8 e inferior 
         if (jQuery.browser.msie&&jQuery.browser.version<9){  
            $(".toast").css("top",  ($(window).height()/2)-($(".toast").height()+15));
            $(".toast").css("left",  ($(window).width()/2)-($(".toast").width()/2)-1);
         }
         
         callbackError();
        
    },
    
    getUserLoggedInfo: function() {
      
        var that = this;
      
        //Pega os dados do usuário logado
        $.ajax({
            url : "Users/logged",
            type : 'GET',
            dataType : 'json',
            success : function(data) {
        
                Monet.Session.User = data;
                
                if(Monet.Session.User["unitSystem"] == undefined){
                    Monet.Session.User["unitSystem"] = "NON_METRIC";
                }
                
                that.loadGlobalConfigurations();
        
            }
        });      
        
    },
    
    loadGlobalConfigurations: function() {
        
        var that = this;
      
        //Pega os dados da GlobalConfiguration
        $.ajax({
            url: 'GlobalConfiguration',
            type: 'GET',
            'contentType' : 'application/json',
            dataType : 'json',
            async : false,
            success: function(data1) {
                
                that.setAppconfigurations(data1);
                
            }
        });      
        
    },
    
    setAppconfigurations: function(data) {
      
        // Se não tiver sido configurada ainda, volta pra tela de login
        // e mostra um toast informando o problema
        if(typeof(data[0]) === "undefined") {
            
            Monet.Session.isLogged = false;
            
            $.toast({
                 message:"GlobalConfiguration is not configured",
                 displayTime:3000,
                 inTime:100,
                 outTime:400,
                 vPosition: "center",
                 hPosition: "center"
            });
            
            //corrige o problema de exibicao do toast no IE8 e inferior 
             if (jQuery.browser.msie&&jQuery.browser.version<9){  
                $(".toast").css("top",  ($(window).height()/2)-($(".toast").height()+15));
                $(".toast").css("left",  ($(window).width()/2)-($(".toast").width()/2)-1);
             }
             
             callbackError();                                   
            
        } else {
        
            Monet.Session.Configurations = data[0];
            Greenmile.Datepicker.LocationFormat();
                
              //Recupera os dados da MapConfiguration  
              $.ajax({
                url: 'MapConfiguration',
                dataType:'json',
                async : false,
                success: function(data) {
                    
                    var mapConfiguration = new App.Collections.MapConfigurations();
                    mapConfiguration.add(data);
                    Monet.Session.Configurations["MapConfiguration"] = mapConfiguration;
                    
                }
            });
            
            if(Monet.Session.targetUrl === null) {
                window.location = "#/welcome";    
            } else {
                
                var currentLocation = window.location.href.replace("/#", "");
                
                if(currentLocation !== Monet.Session.targetUrl) {
                    window.location = Monet.Session.targetUrl;    
                } else {
                    window.location = "#/welcome";
                }
                
                
            }
            
        }      
        
    },

    isLogged : function() {

    },
    
    logout: function(){
        
        $.ajax({
            url: "logout", 
            type: "GET", 
            success: function(){
                
                Monet.Session.Grids.Route.data     = undefined;
                Monet.Session.Grids.Order.data     = undefined;
                Monet.Session.Grids.Stop.data      = undefined;
                Monet.Session.Grids.LineItems.data = undefined;
                Monet.Session.User                 = undefined;
                Monet.Session.Configurations       = undefined;
                Monet.I18n.locale                  = {};
                Monet.I18n.resources               = {};
                Monet.Session.isLogged             = false;
                
                window.location.href               = "#";
            }
        });     
    }
};

Monet.Toast = {
     // Type do toast 
        inlineToast: function (type, message, delayTime){
            
            $.toast({
                 message:message,
                 displayTime:delayTime,
                 inTime:100,
                 outTime:400,
                 vPosition: "center",
                 hPosition: "center",
                 className: type
            });
            
            //corrige o problema de exibicao do toast no IE8 e inferior 
             if (jQuery.browser.msie&&jQuery.browser.version<9){  
                $(".toast").css("top",  ($(window).height()/2)-($(".toast").height()+15));
                $(".toast").css("left",  ($(window).width()/2)-($(".toast").width()/2)-1);
             }  
        },  
        
        typeToast : function() {
            obj = {
                    alert : "toastAlert",
                    info : "toastInfo"
            };
            
            return obj;
        },
};

/**
 * Faz a checagem de novas atualizações que ocorrem na página de maps
 *
 */

Monet.CheckerUpdate = {

    checkUpdateEvents : function() {

        var activeTab = Monet.Utils.GetTabName();

        if (activeTab === "Maps") {
            
          new  App.Routers.EventNotifications().getEventsByTime();
          
        };

    }
};

Monet.projectionBuilder = function(dataMapper, paginationNameSpace) {

    var projection = '{"filters":["id", ';
    var mapKeys = [];
    var paginationStrig = "";

    // Example: '{"filters":["*", "origin.*"]}'

    for (i in dataMapper) {

        if(dataMapper[i].type !== "LINK") {
            mapKeys.push(i);
        }

    }

    for (i in mapKeys) {

        var s = '';

        if(typeof(mapKeys[i]) === "string") {

            s = s + '"' + mapKeys[i];

            if( typeof(dataMapper[mapKeys[i]]) !== "undefined" ) {
                if ( typeof (dataMapper[mapKeys[i]].lookupEntity) !== "undefined" ) {
                    s = s + '.*';
                };
            };

            if (i != (mapKeys.length - 1)) {
                s = s + '", ';
            } else {
                s = s + '"';
            }

            projection = projection + s + '';
                    
        }

    }

    if(typeof(paginationNameSpace) !== "undefined") {
        paginationStrig = '],"firstResult":'+paginationNameSpace.first+',"maxResults":'+paginationNameSpace.max+'}';
    } else {
        paginationStrig = ']}';
    }

    projection = projection + paginationStrig;

    return projection;

};

Monet.Backgrounder = function(initialFunc) {
    
  this.timeout = null;
  
  this.schedule = function (func) {
    var self = this;
    this.timeout = setTimeout(function () {
      self.execute(func);
    }, 0);
  };
  
  this.execute = function (func) {
    this.timeout = null;
    if (!this.aborted) {
      func();
    }
  };
  
  this.interrupt = function () {
    clearTimeout(this.timeout);
    this.timeout = null;
  };
  
  this.finished = function () {
    this.abort();
  };
  
  if (initialFunc != undefined) {
    initialFunc(this);
  }
  
};

Monet.Utils = {};
Monet.Utils.GetTabName = function() {
    
    var tabName = $(".ui-state-default[aria-selected=true]").attr("aria-controls");
    return tabName;
    
};

/**
 * Classes de tratamento de erro do Monet.
 * 
 */

Monet.Exception = {};
Monet.Exception.Base = function(closure, message) {

    this.closure = closure;
    this.message = message;
    
    this.errorObj = {
        "closure": this.closure,
        "message": this.message
    };
    
};

Monet.Exception.ReturnError = (function() {

    ReturnError.prototype = new Monet.Exception.Base();

    function ReturnError() {
        
        Monet.Exception.Base.apply(this, arguments);
        
        this.console = function() {
            
            if(typeof(this.errorObj) === "undefined") {
                return false;
            } else {
                console.log(this.errorObj);    
            }

        };
        
        this.returnObj = function() {
            
            if(typeof(this.errorObj) === "undefined") {
                return false;
            } else {
                return this.errorObj;    
            }            
            
        };
        
    }    

    return ReturnError;

})();