/**
 * Classe main necessária ao backbone;
 * @author: Adalto Junior
 * DATE: 22/01/2013 
 */

var App = {
	Views:{},
	Models:{},
	Collections:{},
	Routers:{},
	Templates:{},
	Forms:{},
	Objects: {},
	init : function(){
		
		Greenmile = Greenmile || {};
		Monet.Session = Monet.Session || {};
		Monet.Session.Configurations = Monet.Session.Configurations || {};
		
		Greenmile.MapMobile = {
			actual : undefined,
			stops : undefined,
		 	map : undefined,
		 	timeouts : [],
		 	markerFocus : undefined,
		 	canRequestMobile : true
		};		
				
	}
};

GMInitialize = {
	
	getConfs: function (callback) {

		GMInitialize.callback = callback;
		
		GMInitialize.getLoggedUser();
	},
	
	getLoggedUser: function () {

        var request       = new Ro.Ajax();

        request.url       = window.hostConf + "/Users/logged";
        request.method    = 'get';

        request.ontimeout = loginViewDoLoginTimeoutCallback;
        request.success   = function (response, xhr) {

            Monet.Session.User = response;

            if(Monet.Session.User["unitSystem"] == undefined){
                Monet.Session.User["unitSystem"] = "METRIC";
            }

            GMInitialize.getGlobalConfiguration();

        };

        request.error = loginViewDoLoginErrorCallback;

        request.send();

	}, 

	getGlobalConfiguration: function () {

        var request       = new Ro.Ajax();

        request.url       = window.hostConf + "/GlobalConfiguration";
        request.method    = 'get';

        request.ontimeout = loginViewDoLoginTimeoutCallback;
        request.success   = function(configurationData) {

            var resources = Monet.I18n.resources;

            Monet.Session.Configurations = configurationData[0];

            for (var i in resources) {

                if (typeof resources[i] !== "function") {

                    if(resources[i].match('{size1Alias}')){
                        resources[i] = resources[i].replace(
                            "{size1Alias}", Monet.Session.Configurations.size1Alias
                        )
                    }

                    if(resources[i].match('{size2Alias}')){
                        resources[i] = resources[i].replace(
                            "{size2Alias}", Monet.Session.Configurations.size2Alias
                        )
                    }

                    if(resources[i].match('{size3Alias}')){
                        resources[i] = resources[i].replace(
                            "{size3Alias}", Monet.Session.Configurations.size3Alias
                        )
                    }

                }

            }

            window.localStorage.resources = JSON.stringify(resources);

            GMInitialize.getMapConfiguration();
        };

        request.error = loginViewDoLoginErrorCallback;

        request.send();

	}, 
	
	getMapConfiguration: function () {

        var request = new Ro.Ajax();

        request.url = window.hostConf + '/MapConfiguration';
        request.success = function(mapConfigurationData) {

            var mapConfiguration = new App.Collections.MapConfigurations();
            mapConfiguration.add(mapConfigurationData);
            Monet.Session.Configurations["MapConfiguration"] = mapConfiguration;

            GMInitialize.getServerVersion();

        };

        request.error = loginViewDoLoginErrorCallback;

        request.send();
		
	},
    getServerVersion: function () {

        var request = new Ro.Ajax();

        request.url = window.hostConf + '/ServerVersion';
        request.success = function (data) {

            Monet.Session.Configurations["ServerInformation"] = data;
            GMInitialize.callback();

        };

        request.error = loginViewDoLoginErrorCallback;

        request.send();
    }

};


$(document).ready(function () {

    App.init();
     
});

function goToPreview(){

	var v = App.Views.MobileMap;
	v.goToPreviewStop();

}

function goToNext(){

	var v = App.Views.MobileMap;
	v.goToNextStop();

}

function goToTruck(){

    var v = App.Views.MobileMap;
    v.goToTruckPosition();

}

