/**
 * Classe que gerencia a criação e exibição dos formulários, bem como o métodos de crud.
 * 
 * @author Adalto Junior
 * Date: 22/02/2013
 */

App.Routers.BaseRoute = Backbone.Router.extend({

    model : '',
    collection : '',
    entity : '',
    base_url : 'form',
    local_collection: "",
    urlArguments : [],

    /*
     * @params {string} entity: É a entidade a qual a tela terá relacionamento
     * @params {object} model: É o model que será utilizado na tela
     * @params {object} collection: É o collection que será utilizado na tela
     * @params {string} urlPrefix: Sereve para sobrescrever a url padrão criada pelo base_router
     * @params {string} tabSelector: É o identificador da aba, se for para abrir a nova tela
     * na mesma aba, usar o mesmo nome da tela anterior, se não, muda para forçar uma aba nova.  
     * */
    
    init : function(entity, model, collection, urlPrefix, tabSelector) {

        var that = this;
        that.model = model;
        that.collection = new collection;
        that.entity = entity;
        that.tabSelector = tabSelector;
        
        
        if(typeof(urlPrefix) === "undefined"){
            urlPrefix = '/' + entity;
        }
        
        var actions = [urlPrefix, urlPrefix+'/new', urlPrefix+'/create',
                       urlPrefix+'/edit/:id', urlPrefix+'/update', urlPrefix+'/destroy/:id'];
        
        var methods = ['list', 'form_new', 'create', 'edit', 'update', 'destroy'];

        $.each(actions, function(index, action) {

            that.route(action, methods[index]);

        });

        if(typeof(App.Objects) !== "undefined") {
            App.Objects[entity] = this;
        } else {
            App.Objects = {};
            App.Objects[entity] = this;
        }

    },
    
    list : function() {

    	var that = this;
    	this.urlArguments = this.list.arguments;
        
        ManageTemplates.pageLayout(function() {

            Monet.Cache.check({
                entity : that.entity,
                crudStation : 'index',
                
                /**
                 * Testar se existe layout no cache com o namespace especificado 
                 * @param {String} entity 
                 */
                
                cached : function(entity) {

                	that.makeListScreen(App.Forms[entity].layout["index"]);

                	if( typeof that.afterPopulateGrid !== "undefined" ) {
                		that.afterPopulateGrid(that);
                	}

                },
                
                /**
                 * Se não tiver no cache, faz a requisição para obter o layout
                 * @param {String} entity
                 */

                notcached : function(entity) {
                    $.ajax({
                        url : that.base_url + '/' + that.entity + '/new',
                        dataType : 'json',
                        success : function(data) {

                            /*
                             * Adiciona o layout ao cache
                             */

                            App.Forms[entity].layout["new"] = data;
                            
                            /*
                             * Chama o FormBuilder e não renderiza em lugarnenhum,
                             * isso serve para criar o dataMapper desse formulário
                             */

                            new Monet.FormBuilder(
                                data, 
                                "new", 
                                "#nowhere", 
                                that.getTabIdSelector()
                            ).renderForm();

                             /*
                              * Agora chama o layout da tela de index propriamente dita,
                              * não é tanto problema fazer duas requisições pois elas ficam
                              * no cache depois disso.
                              */   

                            $.ajax({
                                url : that.base_url + '/' + entity + '/index',
                                dataType : 'json',
                                success : function(data) {

                                	if( typeof that.afterPopulateGrid !== "undefined" ) {
                                    	that.afterPopulateGrid(that);
                                	}
                                	
                                	/*
                                     * Adiciona o layout ao nameSpace do cache
                                     */

                                    App.Forms[entity].layout["index"] = data;
                                    that.makeListScreen(App.Forms[entity].layout["index"]);
                                    
                                    if( typeof that.afterPopulateForm !== "undefined" ) {
                                    	that.afterPopulateForm(that.urlArguments[0]);
                                	}

                                }
                            });

                        }
                    });

                }
            });

        });

    },

    form_new : function() {
    	
    	this.urlArguments = this.form_new.arguments;
    	var that = this;
        
        
        /*
         * Testa se o html base para criação do formulário foi carregado
         */

        ManageTemplates.pageLayout(function() {

            Monet.Cache.check({
                entity : that.entity,
                crudStation : 'new',
                cached : function(entity) {
                    
                    /*
                     * Renderiza o formulário e adiciona à aba correta, o nome da aba
                     * é sempre o nome da Entity
                     */

                    that.renderForm(that.entity, App.Forms[entity].layout["new"], "new");

                    if( typeof that.afterPopulateGrid !== "undefined" ) {
                    	that.afterPopulateGrid(that.urlArguments[0]);
                	}


                },
                notcached : function(entity) {

                    /*
                     * Se o formulário não estiver no cache, faz a requisição pra chamar ele.
                     */
            

                    $.ajax({
                        url : that.base_url + '/' + that.entity + '/new',
                        dataType : 'json',
                        success : function(data) {
                            
                            /*
                             * Adiciona o layout do formulário ao cache
                             */

                            App.Forms[entity].layout["new"] = data;
                            
                            /*
                             * Renderiza o formulário
                             */

                            that.renderForm(that.entity, App.Forms[entity].layout["new"], "new");

                            if( typeof that.afterPopulateGrid !== "undefined" ) {
                            	that.afterPopulateGrid(that.urlArguments[0]);
                        	}

                        }
                    });
                }
            });
        });
    },

    create : function(callback) {
    	
        var that = this;

        /*
         * Chama a função que valida se todos os campos pre-requisitos estão preenchidos
         */
        
        this.allow_submit = Monet.Form.Validation.isMandatory("#" + that.getTabIdSelector());
        
        //executa a validação
        if(typeof(that.onValidate)!== "undefined"){
        	this.onValidate();
        }
        
        /*
         * Se tudo estiver preenchido, pode submeter
         */

        if (this.allow_submit.status) {

            model_to_create = new that.model;
            
            /*
             * Transforma os dados do formulário em um Json
             * 
             * @params entity: É a entidade relacionada ao formulário atual.
             * @params scapeEmpty: True, não enviará os campos em branco no json.
             * 
             */

            var form = Monet.Form.formToJson(that.entity, true);
            
            /*
             * Seta o json ao model preenchendo seus atributos
             */

            model_to_create.set(form);

            /*
             * Com o model populado chama o post para submeter os dados para o servidor
             */
            
            if(typeof(this.beforeCreate) !== "undefined") {
                this.beforeCreate(model_to_create);
            }

            model_to_create.save(model_to_create, {
                
                success : function(model, response) {


                	if (response) {

                        if (response.errorMessages == undefined) {
                        	
                        	if(typeof(callback)!=="undefined"){
                    			callback(model);
                    		}else{
                    		
                            	if(typeof(that.afterCreate) !== "undefined") {
                            		that.afterCreate(model_to_create);
                            	} else {
                            	window.location = "#/" + that.entity;
                            	}
                            
                    		}
                        	
                        } else {
                            
                            that.createAndUpdateErrorHandler(response, true);
                            
                        }                		
                		
                	} else {
                		
                		if(typeof(that.afterCreate) !== "undefined") {
                        	that.afterCreate(model_to_create);
                        } else {
                        	window.location = "#/" + that.entity;
                        }                		
                	} 

                },
                error: function(model, response) {
                    that.createAndUpdateErrorHandler(JSON.parse(response.responseText), true);
                }
            });
        } else {
            this.createAndUpdateErrorHandler(this.allow_submit, false);
        }

        return this;
    },
    
    createAndUpdateErrorHandler: function(response, needLabelTranslation, scope_entity){
        
        var monetMessage = new Monet.Form.Messages.InlineMessage();
        
        if(this.entity != "") {
        	if( typeof(this.entity) !== "undefined" ) {
        	//	monetMessage.setScope("#" + this.entity);
        		if(this.entity == "Stop"){
            		monetMessage.setScope("#Route");
        		}else{
            		monetMessage.setScope("#" + this.entity);
        		}
        	}
        } else {
        	monetMessage.setScope("#" + scope_entity);
        }
        
        monetMessage.setInfoType("error");
        
        if(typeof(response.errorMessage) !== "undefined") {
            monetMessage.setMessage(response);
        } else {            
            if(needLabelTranslation) {
                response = this.translateLabels(response);
                monetMessage.setMessage(response);
            } else {
                monetMessage.setMessage(response);    
            }    
        }
        
        monetMessage.triggerMessage();        
        
    },
    
    translateLabels: function(response) {
        
        var messages = response.errorMessages;
        var originalMsg, translatedMsg, slicer;
        
        if(typeof(messages) !== "undefined") {
            for(var i=0,j = messages.length; i<j; i++){
                
              slicer        = messages[i].message.replace(messages[i].label, "");
              originalMsg   = messages[i].message.replace(slicer, "");
              translatedMsg = Monet.I18n.resources[originalMsg] + " " + slicer;   
                
              messages[i].message = translatedMsg;
              
            };            
        }  
        
        return response;
            
    },

    edit : function(parentId, id) {

    	this.urlArguments = this.edit.arguments;
    	this.editModel = new this.model;
    	this.identity_attribute_fields = {};

        if(typeof id === "undefined") {
        	id = parentId;
        }    	
    	
        var that = this;
        
        /*
         * Testa se o html base para criação do formulário foi carregado
         */        

        ManageTemplates.pageLayout(function() {

            /*
             * Testa se o formulário no cache
             */

            Monet.Cache.check({
                entity : that.entity,
                crudStation : 'edit',
                cached : function(entity) {

                    that.renderForm(that.entity, App.Forms[entity].layout["edit"], "edit");

                    that.identity_attribute_fields = $("#"+entity + " .modelAttribute");

                    var callSetValuesToFormInputs = function(model){
                        
                    	return function() {
                    	    
                            if(typeof(that.beforePopulateForm) !== "undefined") {
                                that.beforePopulateForm();
                            }                    	    
                    	    
                    		Monet.Form.setValuesToFields(that.identity_attribute_fields, model);
                    		
                            if(typeof(that.afterPopulateForm) !== "undefined") {
                            	that.afterPopulateForm();
                            }                    		
                    		
                    	}();
                    };                           

                    that.checkLocalCollection(
                    		id,
                    		callSetValuesToFormInputs
                    );
                    
                },
                notcached : function(entity) {
                            
                    $.ajax({

                        url : that.base_url + '/' + that.entity + '/edit',
                        dataType : 'json',
                        success : function(data) {

                            App.Forms[entity].layout["edit"] = data;

                            that.renderForm(that.entity, App.Forms[entity].layout["edit"], "edit");
                            
                            that.identity_attribute_fields = $("#"+entity + " .modelAttribute");
                            
                            var callSetValuesToFormInputs = function(model){
                            	return function() {
                            		
                            		if(typeof(that.beforePopulateForm) !== "undefined") {
                                        that.beforePopulateForm();
                                    }
                            		
                            		Monet.Form.setValuesToFields(that.identity_attribute_fields, this.model);
                            		
                                    if(typeof(that.afterPopulateForm) !== "undefined") {
                                    	that.afterPopulateForm();
                                    }                            		
                            		
                            	};
                            }(that.editModel);                            

                            that.checkLocalCollection(
                            		id,
                            		callSetValuesToFormInputs
                            );

                        },
                        error : function(e) {

                            this.createAndUpdateErrorHandler(response);

                        }
                    });
                }
            });
        });

    },
    
    /**
     * 
     * @param {Integer} id ID do elemento a ser recuperado no Collection
     * @param {Function} callback Função que será executada depois de chacagem
     */
    
    checkLocalCollection: function(id, callback) {
    	
    	var that = this;
    	
    	/*
    	 * Checa se já existe um collection instanciado na memória
    	 */
    	
        if (this.collection.isEmpty() === false) {
            
            /*
             * Recupera o model pelo ID passado na URL.
             */
            
            model = this.collection.get(id);
            
            /*
             * chama a função de callback.
             */
            
callback(model);
            
            if(typeof(that.afterLoadData) !== "undefined") {
            	that.afterLoadData();
            }            
                
        } else {

            /*
             * Cria uma projection usando o DataMapper como gabarito.
             */

            projection = Monet.projectionBuilder(App.Forms[this.entity].dataMapper);

            /*
             * Recupera os dados model com o ID passado no URL.
             */

            var getId = function(collection, id){

                    return function() {
                        return model = collection.get(id);
                    };

            }(this.collection, id);

            this.collection.reset();
            
            this.collection.filterWithCriteria({
                criteria: projection,
                filter: '{"id":' + id + '}',
                success : function(result) {    
                    callback(getId());
                    
                    if(typeof(that.afterLoadData) !== "undefined") {
                    	that.afterLoadData();
                    }
                    
                }
            });
            
        
        }    	
    	
    },
    
    populateLocalCollection: function(id, callback, collection, closure) {
      
        /*
         * Cria uma projection usando o DataMapper como gabarito.
         */

        projection = Monet.projectionBuilder(App.Forms[this.entity].dataMapper);

        /*
         * Recupera os dados model com o ID passado no URL.
         */

        var getId = function(collection, id){

                return function() {
                    return model = collection.get(id);
                };

        }(collection, id);

        collection.reset();
        
        collection.filterWithCriteria({
            criteria: projection,
            filter: '{"id":' + id + '}',
            success : function(result) {
                
                callback(getId());
                
                if(typeof(closure.afterLoadData) !== "undefined") {
                    closure.afterLoadData();
                }
                
            }
        });
                   
        
    },

    update : function(callback) {
    	
       var that = this;
       
       this.updateModel = new that.model();
        
       this.allow_submit = Monet.Form.Validation.isMandatory("#" + that.getTabIdSelector());
       
       var form = Monet.Form.formToJson(that.entity, true);
       
       //executa a validação
       if(typeof(this.onValidate)!== "undefined"){
    	  this.onValidate();
       }

       if (this.allow_submit.status) {
        	        	        	
            //TODO GM-1854
            for ( var key in this.updateModel.attributes) {
                if(!(_.has(form, key)) && key != "id"){
                    this.updateModel.unset(key);
                }
            }
    
            if(typeof(this.beforeUpdate) !== "undefined") {
                this.beforeUpdate(form);
            }
            
            this.updateModel.set("id", $("#"+Monet.Utils.GetTabName() + " #identity_id").val());    
    
            this.updateModel.save(
                    form, {
                    success : function(model, response) {
                        
                    	if (response) {

                            if (typeof response.errorMessages === "undefined") {
                            	
                            	if(typeof(callback) !== "undefined"){
                            		callback(model);
                            	}else{
                            		
                                    if(typeof(that.afterCreate) !== "undefined") {
                                    	that.afterCreate(model);
                                    } else {
                                    	window.location = "#/" + that.entity;
                                    }
                                    
                            	}
                            	
                            } else {
                                
                                that.createAndUpdateErrorHandler(response, true);
                                
                            }                		
                    		
                    	} else {
                    		
                    		if(typeof(that.afterCreate) !== "undefined") {
                            	that.afterCreate(model);
                            } else {
                            	window.location = "#/" + that.entity;
                            }                		
                    	}
                    },
                    error: function(model, response) {
                        that.createAndUpdateErrorHandler(JSON.parse(response.responseText), true);
                    },
                    error: function(model, response) {
                        that.createAndUpdateErrorHandler(JSON.parse(response.responseText), true);
                    }
                });
            
        } else {
            this.createAndUpdateErrorHandler(this.allow_submit);
        }
        
        return this;        

    },

    destroy : function(parentId, id) {

        var that         = this;
        var allowDestroy = true;
        
        if(typeof id === "undefined") {
        	id = parentId;
        }
        
        this.checkLocalCollection(
        		id, function(model) {

                    if(typeof(that.beforeDestroy) !== "undefined") {
                    	allowDestroy = that.beforeDestroy(that, id);
                    }
        			
                    if ( allowDestroy ) {
	        	        model.destroy({
	        	        	
	                        success : function(model, response) {
	                        	
	                        	if (response) {

	                                if (typeof response.errorMessages === "undefined") {
	                                	
	                                	if(typeof(callback) !== "undefined"){
	                                		callback(model);
	                                	}else{
	                                		
	                                        if(typeof(that.afterDestroy) !== "undefined") {
	                                        	that.afterDestroy();
	                                        } else {
	                                        	window.location = "#/" + that.entity;
	                                        }
	                                        
	                                	}
	                                	
	                                } else {
	                                    
	                                    that.createAndUpdateErrorHandler(response, true);
	                                    
	                                }                		
	                        		
	                        	} else {
	                        		
	                        		if(typeof(that.afterDestroy) !== "undefined") {
	                                	that.afterDestroy(model_to_create);
	                                } else {
	                                	window.location = "#/" + that.entity;
	                                }                		
	                        	} 

	                        },
	                        error: function(model, response) {
	                            that.createAndUpdateErrorHandler(JSON.parse(response.responseText), true);
	                        }
	        	        });
        			}
        	        
        		}        		
        );

        return this;
    },
    
    destroyErrorHandler: function(model, response, obj) {
        
        var monetMessage = new Monet.Form.Messages.InlineMessage();
        
        monetMessage.setScope("#" + obj.entity);
        monetMessage.setInfoType("error");
        monetMessage.setMessage(response);
        
        monetMessage.triggerMessage();

    },
    
    tabControl: function(tabSelector, formData,  callback) {
    	
    	var nameSelectorTab = tabSelector;
        
        if(typeof(this.beaforeCreateTab) != "undefined") {
            this.beaforeCreateTab(tabSelector, formData);
        }

        Monet.TabControl.addNewTab(
        	nameSelectorTab, 
            formData, 
            callback
        );
        
    },
    
    renderForm : function(entity, formData, crudStage) {

        this.tabIdSelector = this.getTabIdSelector(); 
                
        this.tabControl(this.tabIdSelector, formData.userInterfaceAction.userInterface.description, function(){});

        Monet.Form.checkFormTemplate(this.tabIdSelector);
        
        if(typeof(this.beforeCreateForm) !== "undefined") {
            this.beforeCreateForm(entity, formData, crudStage);    
        }        
                
        new Monet.FormBuilder(formData, crudStage, "#" + this.tabIdSelector + " #form_and_grid", this.tabIdSelector).renderForm();
        
        if(typeof(this.afterCreateForm) !== "undefined") {
            this.afterCreateForm(entity, formData, crudStage);    
        }       

    },

    makeListScreen : function(data) {

        var that = this;
        var table_layout;
        this.collectionFilter = '{}';
        this.collectionCriteria = null;

        if (data != undefined && data != "") {
        	
        	var tabIdSelector = that.getTabIdSelector();
            that.tabControl(tabIdSelector, data.userInterfaceAction.userInterface.description, function() {});
            
            Monet.Form.checkFormTemplate(tabIdSelector);

            table_layout = Monet.Grid.getGridLayout(data);

            local_collection = that.collection;                         
                
            new Monet.FormBuilder(data, "index", "#" + tabIdSelector + " #form_and_grid", tabIdSelector).renderForm();    

            this.collectionCriteria = Monet.projectionBuilder(
                    App.Forms[this.entity].dataMapper,
                    App.Forms[this.entity].pagination
            );
            
            // Recupera todos os registros da Entidade a qual essa tela faz refer√™ncia
            App.Forms[that.entity].pagination.blocked = true;

            if(typeof(this.beforeList) !== "undefined") {
                this.beforeList();
            }
            
            local_collection.reset();
            local_collection.filterWithCriteria({
                filter: this.collectionFilter,
                criteria: this.collectionCriteria,
                success : function(result) {

                        /*
                         *  Chama a função que constroe a tabela
                         * 
                         *  layout: A estrutura do json do monet que tem as colunas da tabela
                         *  scope: O nome da aba
                         *  elementId: o ID do elemento que receberá a tabela
                         *  postColumns: Caso deseje inserir alguma coisa na tabela, depois das
                         *  colunas que vem no layout, você usa essa função
                         */

                        App.Forms[that.entity].pagination.blocked = false;
                        App.Forms[that.entity].pagination.total = result.length;

                        if(typeof(App.Forms[that.entity].table) !== "undefined") {

                            App.Forms[that.entity].table.fnClearTable();

                            var nNext     = $("#" + that.entity + " div[entity='" + that.entity +"'][action='next']")[0];
                            var nPrevious = $("#" + that.entity + " div[entity='" + that.entity +"'][action='previous']")[0];

                            Monet.Grid.pagination.enablingControl(
                                    App.Forms[that.entity].pagination, nNext, nPrevious
                            );
                         
                            Monet.Grid.generateTable({
                                layout: table_layout,
                                data: result,
                                scope: data.userInterfaceAction.userInterface.key,
                                element: $("#" + that.entity + ' .display') ,
                                postColumns: function(columns, column) {
                                    columns.push(null);
                                    columns.push(null);
                                    columns.push(column.get("id"));
                                }
                            });
                            
                            App.Forms[that.entity].table.fnSetFilteringDelay();                            
                        	
                        }
                        
                        if(typeof(that.afterList) !== "undefined") {
                        	that.afterList();
                        }

                }
            
            });
        } else {
            alert("Sem informa√ß√£o de layout, verifique se o servidor est√° funcionando corretamente");
        }

        return this;
    },

    updateGrid: function(){

        var local_collection = new this.collection();
        var projection       = Monet.projectionBuilder(
                App.Forms[this.entity].dataMapper,
                App.Forms[this.entity].pagination

        );
        var table_layout     = Monet.Grid.getGridLayout(App.Forms[this.entity].layout["index"]);
        var that             = this;

        local_collection.reset();
        local_collection.fetchWithCriteria({
            criteria: projection,
            success : function(result) {

                /*
                 *  Chama a função que constroe a tabela
                 *
                 *  layout: A estrutura do json do monet que tem as colunas da tabela
                 *  scope: O nome da aba
                 *  elementId: o ID do elemento que receberá a tabela
                 *  postColumns: Caso deseje inserir alguma coisa na tabela, depois das
                 *  colunas que vem no layout, você usa essa função
                 */

                App.Forms[that.entity].pagination.blocked = false;
                App.Forms[that.entity].pagination.total = result.length;

                //App.Forms[that.entity].table.fnClearTable();

                var nNext     = $("#" + that.entity + " div[entity='" + that.entity +"'][action='next']")[0];
                var nPrevious = $("#" + that.entity + " div[entity='" + that.entity +"'][action='previous']")[0];

                Monet.Grid.pagination.enablingControl(
                        App.Forms[that.entity].pagination, nNext, nPrevious
                );

                Monet.Grid.generateTable({
                    layout: table_layout,
                    data: result,
                    scope: App.Forms[that.entity].layout["new"].userInterfaceAction.userInterface.key,
                    element: $("#" + that.entity + ' .display') ,
                    postColumns: function(columns, column) {
                        columns.push(null);
                        columns.push(null);
                        columns.push(column.get("id"));
                    }
                });

                $("#" + that.entity + " .gridLoader").hide();

            }
        });
    },

    filterGrid: function(filter){

        var local_collection = this.collection;
        var projection       = Monet.projectionBuilder(
                App.Forms[this.entity].dataMapper,
                App.Forms[this.entity].pagination

        );
        
        var table_layout     = Monet.Grid.getGridLayout(
            App.Forms[this.entity].layout["index"]
        );
        
        var that             = this;

        local_collection.reset();

        local_collection.filterWithCriteria({
            criteria: projection,
            filter: filter,
            success : function(result) {

                /*
                 *  Chama a função que constroe a tabela
                 *
                 *  layout: A estrutura do json do monet que tem as colunas da tabela
                 *  scope: O nome da aba
                 *  elementId: o ID do elemento que receberá a tabela
                 *  postColumns: Caso deseje inserir alguma coisa na tabela, depois das
                 *  colunas que vem no layout, você usa essa função
                 */

                App.Forms[that.entity].pagination.blocked = false;
                App.Forms[that.entity].pagination.total   = result.length;
                //App.Forms[that.entity].table.fnClearTable();

                var nNext     = $("#" + that.entity + " div[entity='" + that.entity +"'][action='next']")[0];
                var nPrevious = $("#" + that.entity + " div[entity='" + that.entity +"'][action='previous']")[0];

                Monet.Grid.pagination.enablingControl(
                        App.Forms[that.entity].pagination, nNext, nPrevious
                );

                Monet.Grid.generateTable({
                    layout: table_layout,
                    data: result,
                    scope: App.Forms[that.entity].layout["new"].userInterfaceAction.userInterface.key,
                    element: $("#" + that.entity + ' .display') ,
                    postColumns: function(columns, column) {
                        columns.push(null);
                        columns.push(null);
                        columns.push(column.get("id"));
                    }
                });

                $("#" + that.entity + " .gridLoader").hide();

            }
        });

    },
    
    getTabIdSelector : function(){
    	var that = this;
    	var idSelector = "";
    	
    	if(typeof(that.tabSelector)!== "undefined"){
    		idSelector = that.tabSelector;
    	}else{
    		idSelector = that.entity;
    	}
    	
    	return idSelector;
    }
});