/**
 * Classe que gerencia as requisições para o mapa mobile
 * @author adalto.junior
 * Date 22/01/2013
 */

App.Routers.MobileMap = {

	 serverUrl: Monet.Maps.defaults.serverUrl + '/',
	 format : Monet.Maps.defaults.format,
	 routes : {
		  "/MobileMap/:routeId" : "show"               	
	 },

	 show : function(routeId, mapContainer){
		 
		 $.ajax({
             url : window.hostConf + "/Route/" + routeId + "/GeneratePath",
             headers: {
                "Cookie": window.cookie
             }
		 });
         
         this.createMap(routeId, mapContainer);

	 },

	 createMap : function(routeId, mapContainer){

	     var mapConfiguration = Monet.Session.Configurations.MapConfiguration.models[0],
	     wmsRouteLayerWorkspace = mapConfiguration.get("wmsRouteLayerWorkspaceName"),
	     wmsRouteLayerName = mapConfiguration.get("wmsRouteLayer");
	     
		 var options = {
				center : [-15.792254, -48.001464],
			 	zoom : 18,
			 	crs: L.CRS.EPSG4326,
	            zoomAnimation: false,
	            markerZoomAnimation: false,
	            zoomsliderControl: false
		 };
		 
		 var map = new L.Map(mapContainer, options);
		 
		 L.TileLayer.prototype._tileOnError = function() {

			 if(Greenmile.MapMobile.canRequestMobile){
				   Greenmile.MapMobile.canRequestMobile = false;
			 }
			 
		 };

		 var baseLayer = L.tileLayer.wms(window.hostConf + "/" + this.serverUrl + "Cached", {
	            layers:  Monet.Session.Configurations.MapConfiguration.models[0].get("wmsLayer"), //'brasil',
	            format: this.format,
	            transparent: true,
	            crs: L.CRS.EPSG4326.code
	        }).addTo(map);
		 
		 baseLayer.bringToBack();


	     var routeLayer = L.tileLayer.wms(window.hostConf + "/" + this.serverUrl, {
            layers : wmsRouteLayerWorkspace + ':' + wmsRouteLayerName,
            format : this.format,
            transparent : true,
            reuseTiles : true,
            unloadInvisibleTiles : true,
            cql_filter : "route_id=" + routeId,
            crs : L.CRS.EPSG4326.code
	     });
	        
	     routeLayer.kind = "PLANNED_ROUTE";
	        
	     routeLayer.addTo(map);
	     
	     var zoom = new L.Control.Zoom('bottomleft');
	     
	     zoom.addTo(map);
	        
		 this.getStops(routeId, map);
         this.getCoordinates(routeId, map);
		 
	 },

     getCoordinates: function (routeId, map) {

         $.ajax({
             url: window.hostConf + "/Route/" + routeId + "/Coordinates",
             type: 'GET',
             headers: {
                 "Cookie": window.cookie
             },
             'contentType' : 'application/json',
             dataType : 'json',
             success: function (data) {

                 var truckBtnIcon = document.querySelector("#Truck .btnIcon");

                 if (data && data.length) {
                     App.Routers.MobileMap.putTruckOnMap(map, data);
                     truckBtnIcon.style.backgroundImage = "url(images/truck.png)";
                 } else {
                     Greenmile.MapMobile.truckPosition = false;
                     truckBtnIcon.style.backgroundImage = "url(images/truck_disabled.png)";
                 }

             }
         })

     },

     putTruckOnMap: function (map, coordinates) {

         if (coordinates) {

             var lastCoordinate = coordinates[coordinates.length-1];

             Greenmile.MapMobile.truckPosition = lastCoordinate;

             var marker = L.marker([lastCoordinate.position.latitude, lastCoordinate.position.longitude], {
                 icon : new L.Icon({
                     iconUrl : 'images/truck_marker.png'
                 })
             });

             marker.kind = "TRUCK";

             marker.addTo(map);

         } else {

            Ro.UIComponents.ToastNotification("Map.noCoordinateMessage");

         }

     },

	 getStops : function(routeId, map){
		 var that = this;
		 
		 var route = new App.Collections.Routes();
         var filter = '{"filters":["id","plannedDistance","plannedArrival","plannedDeparture", "origin.*", "destination.*","origLatitude","origLongitude","destLatitude","destLongitude"]}';

         if (serverIsOldVersion()) {
             filter = '{"filters":["id","plannedDistance","plannedArrival","plannedDeparture", "origin.*", "destination.*"]}';
         }

		 route.filterWithCriteria({
             filter : '{"id":' + routeId + '}',
             criteria : filter,
             success : function(data) {
            	 
            	 var refer = that;
            	 var route = data.models[0];
            	 
            	 route.stops({
            		criteria : '{"filters":["id","plannedArrival","plannedDeparture", "plannedDistance", "plannedSequenceNum","actualSequenceNum","plannedSize1","cancelCode","actualArrival","actualDeparture","cancelCode.*","redeliveryStop.*","redeliveryStop.location.key*","undeliverableCode.*","location.*"]}',
            		success : function(data) {
        		    	 refer.drawStops(route,data, map);
        		     }
        		 });
             }
         });	          
		 
	 },

	 drawStops : function(route, stops, map){
		 
         var originIcon = 'live_files/images/map/markers/origin_location.png';
         var destinationIcon = 'live_files/images/map/markers/destination.png';
         var stopsLength = stops.length;
         var points = [];
         var bounds = [];
         var sumPlannedSize1 = 0;

         var origin = function (route) {

             var latlng = {
                 latitude: null,
                 longitude: null
             };

             if (route.get('origLatitude') && route.get('origLongitude')) {

                 latlng.latitude = route.get('origLatitude');
                 latlng.longitude = route.get('origLongitude');

             } else if (route.get('origin')) {

                 latlng.latitude = route.get('origin').latitude;
                 latlng.longitude = route.get('origin').longitude;

             }

             return latlng;

         }(route);

         var destination = function (route) {

             var latlng = {
                 latitude: null,
                 longitude: null
             };

             if (route.get('destLatitude') && route.get('destLongitude')) {

                 latlng.latitude = route.get('destLatitude');
                 latlng.longitude = route.get('destLongitude');

             } else if (route.get('destination')) {

                 latlng.latitude = route.get('destination').latitude;
                 latlng.longitude = route.get('destination').longitude;

             }

             return latlng;

         }(route);

         if (origin.latitude && origin.longitude) {

             var position = [origin.latitude, origin.longitude];
				
             var marker = L.marker(position, {
                 icon : new L.Icon({
                     iconUrl : originIcon
                 })
             });
			
             marker.kind = "STOP";
			
             marker.addTo(map);
			
             var location = route.attributes.origin;
             var plannedArrival = route.get("plannedArrival");
             var plannedDeparture = route.get("plannedDeparture");
             var plannedDistance = route.get("plannedDistance");
							
             points.push({
                 latlng : position,
                 location : location,
                 plannedArrival: plannedArrival,
                 plannedDeparture: plannedDeparture,
                 isDepot : true,
                 plannedDistance : plannedDistance
             });
			
             bounds.push(position);
		
         }

         for (var i = 0, j = stopsLength; i < j; i++) {

             var plannedSequenceNum = stops.models[i].get("plannedSequenceNum");
             var actualSequenceNum  = stops.models[i].get("actualSequenceNum");
             var cancelCode         = stops.models[i].get("cancelCode");
             var undeliverableCode  = stops.models[i].get("undeliverableCode");
             var redeliveryStop     = stops.models[i].get("redeliveryStop");
             var actualArrival      = stops.models[i].get("actualArrival");
             var actualDeparture    = stops.models[i].get("actualDeparture");
             var point              = new L.Point(45, -5);
             var cor                = '';

             var labelText = "";
	
             if (actualSequenceNum !== "" && typeof (actualSequenceNum) !== "undefined") {
	
                 labelText = "<strong>" + plannedSequenceNum + "</strong>/" + actualSequenceNum;
	
             } else {
	
                 labelText = "<strong>" + plannedSequenceNum + "</strong>";
	
             }

             L.NumberedDivIcon = L.Icon.extend({
	
                 options : {
                     cor : '',
                     number : '',
                     iconUrl : '',
                     shadowUrl : null,
                     iconAnchor : new L.Point(-8, 7),
                     popupAnchor : new L.Point(0, 0),
                     className : 'greenmileMarkerIcon'
                 },
	
                 createIcon : function() {
	
                     var div = document.createElement('div');
                     var img = this._createImg(this.options['iconUrl']);
                     var numdiv = document.createElement('div');
	
                     numdiv.setAttribute("class", "markerLabel");
	
                     divMarkerText = "";
	
                     divMarkerText += '<div class="markerRouteStops">';
                     divMarkerText += '<div class="spaceText ' + this.options["cor"] + '" style="opacity: 1;">';
                     divMarkerText += this.options['number'] || '';
                     divMarkerText += '</div>';
                     divMarkerText += '</div>';
	
                     numdiv.innerHTML = divMarkerText;
	
                     div.appendChild(numdiv);
	
                     this._setIconStyles(div, 'icon');
	
                     return div;
                 }

             });

             if (actualSequenceNum !== "" && typeof (actualSequenceNum) !== "undefined") {
                 cor = 'green';
             }

             if ( typeof (redeliveryStop) !== "undefined") {
                 cor = 'yellow';
             } else {
                 if ( typeof (cancelCode) !== "undefined") {
                     cor = 'red';
                 } else {
                     if ( typeof (undeliverableCode) !== "undefined") {
                         cor = 'yellow';
                     } else {
                         if ( typeof (actualArrival) !== "undefined" && typeof (actualDeparture) !== "undefined") {
                             cor = 'green';
                         } else {
                             cor = 'gray';
                         }
                     }
                 }
             }

             if ( typeof (stops.models[i].get("location").latitude) !== "undefined") {
	
                 var marker = L.marker([stops.models[i].get("location").latitude, stops.models[i].get("location").longitude], {
                     icon : new L.NumberedDivIcon({
                         number : labelText,
                         cor : cor
                     })
                 });
	
                 marker.id = stops.models[i].id;
                 marker.kind = "STOP";
	            
                 var latlng = [stops.models[i].get("location").latitude, stops.models[i].get("location").longitude];
                 var location = stops.models[i].get("location");
                 var plannedArrival = stops.models[i].get("plannedArrival");
                 var plannedDeparture = stops.models[i].get("plannedDeparture");
                 var plannedDistance = stops.models[i].get("plannedDistance");
                 var plannedSize1 = stops.models[i].get("plannedSize1");
				
                 if(typeof(plannedSize1)!=="undefined"){
                     sumPlannedSize1 += plannedSize1;
                 }


                 points.push({
                     latlng : latlng,
                     location : location,
                     plannedArrival: plannedArrival,
                     plannedDeparture: plannedDeparture,
                     plannedDistance : plannedDistance,
                     plannedSize1 : plannedSize1
                 });
	            
                 bounds.push(latlng);
				
                 marker.addTo(map);
             }
		
         }
	     
         //adiciona a soma do plannedSize para o ponto de origem
         var ponto = points[0];
         ponto["plannedSize1"] = sumPlannedSize1;
	     
         if (destination.latitude && destination.longitude) {

             var position = [destination.latitude, destination.longitude];

             var marker = L.marker(position, {
                 icon : new L.Icon({
                     iconUrl : destinationIcon
                 })
             });
                 
             marker.kind = "STOP";
                 
             marker.addTo(map);
                 
             var location = route.attributes.destination;
             var plannedArrival = route.get("plannedArrival");
             var plannedDeparture = route.get("plannedDeparture");
             var plannedDistance = route.get("plannedDistance");
             var plannedSize1 = sumPlannedSize1;
                 
             points.push({
                 latlng : position,
                 location : location,
                 plannedArrival: plannedArrival,
                 plannedDeparture: plannedDeparture,
                 isDepot : true,
                 plannedDistance : plannedDistance,
                 plannedSize1 : plannedSize1
             });
                 
             bounds.push(position);
             
         }
	     
         map.fitBounds(bounds);
	     
         Greenmile.MapMobile.stops = points;
         Greenmile.MapMobile.map = map;
	     
         var mobileMapView = App.Views.MobileMap;
         mobileMapView.addEventListenner();
	     
     }

};