/**
 * Classe que gerencia os eventos de view da tela MobileMap
 * @author: Adalto Junior
 * DATE: 23/01/2013
 * 
 */

App.Views.MobileMap = {
	addEventListenner : function(){
		var that = this;
		$(".detailStop").off("click");
		$(".detailStop").on("click", function(){
			var detailStop = document.querySelector(".infoDetailStop");
			var index = detailStop.getAttribute("stop");
			that.showStopOnMap(Greenmile.MapMobile.stops[index]);
		});
		
		var closeDetailStop = document.querySelector(".closeUrgentNotificationPanel");
		
		closeDetailStop.onclick = function(event) {
			
			var detailStop = document.querySelector(".detailStop");
			detailStop.style.display = "none";
			closeDetailStop.style.display = "none";
		
		};
		
	},
	
	goToPreviewStop : function(){
		
		var actual = Greenmile.MapMobile.actual;
		var stop = Greenmile.MapMobile.stops;

		if(actual > 0 && typeof(actual) !=="undefined"){
			
			actual--;
			this.showStopOnMap(stop[actual]);
			Greenmile.MapMobile.actual = actual;
			this.showInfoStop(stop[actual]);
			this.setAttributeStopToDiv(actual);
			
		}
		

		
	},
	
	goToNextStop : function(){
		
		var actual = Greenmile.MapMobile.actual;
		var stop = Greenmile.MapMobile.stops;
		var last = stop.length - 1;

		if(typeof(actual) === "undefined"){
		
			actual = 0;
		
		}else if(actual < last && typeof(actual) !=="undefined"){
			
			actual++;
			
		}else{
			
			return false;
		}
		
		this.showStopOnMap(stop[actual]);		
		this.showInfoStop(stop[actual]);
		this.setAttributeStopToDiv(actual);
		
		Greenmile.MapMobile.actual = actual;


		
	},

    goToTruckPosition: function(){

        var truckPosition = Greenmile.MapMobile.truckPosition;
        var map           = Greenmile.MapMobile.map;

        if (truckPosition) {

            var markerFocusIcon = L.divIcon({
                className:"markerDetailRoute",
                html: '<div class="greenmileMarkerFocusIcon"></div>',
                iconAnchor: [12, 12]
            });

            var markerFocus = new L.marker(
                [truckPosition.position.latitude, truckPosition.position.longitude],
                {
                    icon: markerFocusIcon,
                    zIndexOffset: -1
                }
            );

            this.controlShowStop(map);

            markerFocus.addTo(map);

            Greenmile.MapMobile.markerFocus = markerFocus;

            map.setZoom(18);
            map.panTo([truckPosition.position.latitude, truckPosition.position.longitude]);

        } else {

            Ro.UIComponents.ToastNotification(
                Monet.I18n.getResourcesByKey("Map.noCoordinateMessage")
            );

        }

    },
	
	showStopOnMap : function(stop){
		
		var map = Greenmile.MapMobile.map;
        
        if (typeof stop.latlng !== "undefined") {

            var latlng = stop.latlng;
            var valuesIconAnchor;
            
            if(stop.isDepot){
                
                valuesIconAnchor = [16,18];
                
            }else{
                
                valuesIconAnchor = [6,24];
                
            }
            
            var markerFocusIcon = L.divIcon({className:"markerDetailRoute",html: '<div class="greenmileMarkerFocusIcon"></div>', iconAnchor: valuesIconAnchor});
            var markerFocus = new L.marker(latlng, { icon: markerFocusIcon, zIndexOffset: -1 });
            
            this.controlShowStop(map);
            
            markerFocus.addTo(map);
            
            Greenmile.MapMobile.markerFocus = markerFocus;
            
            map.setZoom(18);
            map.panTo(latlng);
            
        }
		
	},

	controlShowStop : function(map){
				
		var clearTimeouts = function(){
			var timeOuts = Greenmile.MapMobile.timeouts;
			var timeOutsLenth = timeOuts.length;
			for ( var i = 0; i < timeOutsLenth; i++) {
				clearTimeout(timeOuts[i]);
			}
			Greenmile.MapMobile.timeouts = [];
		};
		
	    var dismissFocus = function(){
            map.removeLayer(Greenmile.MapMobile.markerFocus);
            clearTimeouts();
	    };
	   
		if(typeof(Greenmile.MapMobile.markerFocus) !== "undefined"){
			dismissFocus();
		}
		
		if(Greenmile.MapMobile.timeouts.length > 0){
			clearTimeouts();
		}
        
        var timeout = setTimeout(function(){
            dismissFocus();
        }, 4000);
        
        Greenmile.MapMobile.timeouts.push(timeout);
	},
	
	showInfoStop : function (stop){
		
		var template = _.template($("#stopDetailMapMobile").html());
		var templateHtml = "";
		var stopDetail = new Greenmile.RouteDetail.StopDetailPopup(stop.id, null);
		var dateFunctions = new Greenmile.Date.GeneralFunctions();
		var address = [];
		var planneds = [];
		var distancePlanned;
		var plannedSize1;
		var labelDistancePlanned = Monet.I18n.getResourcesByKey("Greenmile.MobileMapResources.resPlannedDistance");
		var labelSize1 = "";
		
		if(typeof(stop.location) !== "undefined"){
			address = stopDetail.getItensOfAddres(stop.location);
		}
		
		if(stop.isDepot){
			
			if(typeof(stop.plannedDeparture) !== "undefined"){
				planneds.push(dateFunctions.formateDateTimeByLocale(stop.plannedDeparture));
			}	
			
			if(typeof(stop.plannedArrival) !== "undefined"){
				planneds.push(dateFunctions.formateDateTimeByLocale(stop.plannedArrival));
			}
			
		}else{
			
			if(typeof(stop.plannedArrival) !== "undefined"){
				planneds.push(dateFunctions.formateDateTimeByLocale(stop.plannedArrival));
			}
			
			if(typeof(stop.plannedDeparture) !== "undefined"){
				planneds.push(dateFunctions.formateDateTimeByLocale(stop.plannedDeparture));
			}			
		
		}
		
		if(typeof(stop.plannedDistance)!== "undefined" && stop.plannedDistance > 0){
			distancePlanned = this.formatPlannedDistance(stop.plannedDistance);
		}
		
		if(typeof(stop.plannedSize1)!== "undefined" && stop.plannedSize1 > 0){
			plannedSize1 = stop.plannedSize1.toFixed(3);
		}
		
		if(typeof(Monet.Session.Configurations.size1Alias) !== "undefined"){
			labelSize1 = Monet.Session.Configurations.size1Alias;
		}
		
		templateHtml = template({
			infoLocation : stop.location,
			address: address,
			planneds : planneds,
			labelDistancePlanned: labelDistancePlanned,
			distancePlanned : distancePlanned,
			labelSize1 : labelSize1,
			plannedSize1 : plannedSize1
		});
		
		var infoDetailStop = document.querySelector(".infoDetailStop");
		var close = document.querySelector(".closeUrgentNotificationPanel");
		var detailStop = document.querySelector(".detailStop");

		infoDetailStop.innerHTML = templateHtml;
		infoDetailStop.setAttribute("stop", stop.id);
		
		close.style.display = "block";
		detailStop.style.display = "block";
		
		
	},
	//TODO funçao similar a formatDistanceTotal em Greenmile.Calculos.GeneralFunctions
	formatPlannedDistance : function(metters){
    	
    	var result = 0;
    	var unitSystemStr =  Monet.I18n.getResourcesByKey("Greenmile.MobileMapResources.resMeters");
    	var generalFunctions = new Greenmile.Calculos.GeneralFunctions();
    	var unitSystem = Monet.Session.User.unitSystem;
		var isKm = metters >= 1000;
		var isMille = metters >= 1609.344;

    	
    	if(typeof(metters) !== "undefined"){
    		
    		if(unitSystem == "METRIC"){
    			   			
    			if(isKm){
    				
    				result = generalFunctions.convertMettersToKilometters(metters);
    				unitSystemStr = Monet.I18n.getResourcesByKey("Greenmile.MobileMapResources.resKilometers");
    				
    			}else{
    				result = Math.ceil(metters);
    			};
    			
    		}else{
    			
    			if(isMille){
    				
    				result = generalFunctions.convertMettersToMilles(metters);
    				unitSystemStr = Monet.I18n.getResourcesByKey("Greenmile.MobileMapResources.resMiles");
    				
    			}else{
    				result = generalFunctions.convertMettersToFeets(metters);
    				unitSystemStr = Monet.I18n.getResourcesByKey("Greenmile.MobileMapResources.resFeet");
    			};
    			
    		};
    	}else{
        	if(unitSystem == "NON_METRIC" ){
        		unitSystemStr = Monet.I18n.getResourcesByKey("Greenmile.MobileMapResources.resFeet");
        	}
    	}

    	
    	return result + " "+ unitSystemStr;
    },
    
    setAttributeStopToDiv : function(index){
    	
    	var detailStop = document.querySelector(".infoDetailStop");
		detailStop.setAttribute("stop", index);
    	
    }
};