/**
 * Classe que gerencia os popups com o detalhe do stop!
 * @author: Adalto Junior adaltojunior@sagaranatech.com
 * DATE: 07/01/2013
 * TIME: 14:08 
 */

var Greenmile = Greenmile || {};
Greenmile.RouteDetail = Greenmile.RouteDetail || {};

Greenmile.RouteDetail.StopDetailPopup = function(stopId, routeId){
	
	this.show = function() {
		return function(context){
			$.ajax({
	            url : "Stop/" + stopId,
	            'contentType' : 'application/json',
	            dataType : 'json',
	            success : function(stop) {

	                var renderedTemplate = "";
	                var timeWindow;
	                var objDistArriveClient;
	                var arrayAddress = [];
	                var objServiceTime = "";
	                var objPercent = "";


	                if ( typeof (stop) !== "undefined") {

	                    var statusType = "";
	                    var motivo = "";

	                    template = _.template($("#stopLeafletPopup").html());

	                    arrayAddress = context.getItensOfAddres(stop.location);

	                    if ((typeof (stop.plannedDeparture) !== "undefined" && typeof (stop.actualDeparture) != "undefined") && ( typeof (stop.plannedArrival) !== "undefined" && typeof (stop.actualArrival) !== "undefined")) {

	                        objPercent = context.getPercentBetwenArrivalAndDeparture(stop.plannedArrival, stop.actualArrival, stop.plannedDeparture, stop.actualDeparture);

	                    }

	                    if ( typeof (stop.actualDeparture) != "undefined" && typeof (stop.actualArrival) !== "undefined") {

	                        objServiceTime = context.getServiceTime(stop.actualService, stop.actualDeparture);

	                    }

	                    /*format depart*/
	                    if ( typeof (stop.plannedDeparture) !== "undefined" && typeof (stop.actualDeparture) != "undefined") {

	                        stop.plannedDeparture = context.formatDate(stop.plannedDeparture);
	                        stop.actualDeparture = context.formatDate(stop.actualDeparture);

	                    } else {

	                        stop.plannedDeparture = "";
	                        stop.actualDeparture = "";

	                    }
	                    /*end format depart*/

	                    /*format arrival*/
	                    if ( typeof (stop.plannedArrival) !== "undefined" && typeof (stop.actualArrival) !== "undefined") {

	                        stop.plannedArrival = context.formatDate(stop.plannedArrival);
	                        stop.actualArrival = context.formatDate(stop.actualArrival);

	                    } else {

	                        stop.plannedArrival = "";
	                        stop.actualArrival = "";

	                    }
	                    /*end format arrival*/

	                    /*format service*/
	                    if ( typeof (stop.plannedService) !== "undefined" && typeof (stop.actualService) !== "undefined") {

	                        stop.plannedService = context.formatDate(stop.plannedService);
	                        stop.actualService = context.formatDate(stop.actualService);

	                    } else {

	                        stop.plannedService = "";
	                        stop.actualService = "";

	                    }
	                    /*end format service*/

	                    if ( typeof (stop.location.timeWindowType) !== "undefined") {
	                        
	                    	if ( typeof (stop.location.timeWindowType.timeWindowTypeDayss) !== "undefined") {
	                        
	                    		timeWindow = context.getTimeWindow(stop.location.timeWindowType.timeWindowTypeDayss);
	                        
	                    	}
	                    	
	                    }

	                    if (( typeof (stop.location.latitude) !== "undefined" && typeof (stop.location.longitude) !== "undefined") && ( typeof (stop.arrivalLatitude) !== "undefined" && typeof (stop.arrivalLongitude) !== "undefined")) {
	                        
	                    	var lat1 = stop.location.latitude;
	                        var lgn1 = stop.location.longitude;
	                        var lat2 = stop.arrivalLatitude;
	                        var lgn2 = stop.arrivalLongitude;

	                        objDistArriveClient = context.getDistanceBetweenTwoPoints(lat1, lgn1, lat2, lgn2);
	                    }

	                    //adiciona o status do stop
	                    statusType = context.getStatusStops(stop.redeliveryStop, stop.cancelCode, stop.undeliverableCode, stop.actualArrival, stop.actualDeparture);
	                    
	                    //adiciona motivo do stop
	                    motivo = context.getMotivoByStopStatus(stop, statusType);

	                    renderedTemplate = template({
	                        info : stop,
	                        status : statusType,
	                        motivo : motivo,
	                        windows : timeWindow,
	                        address : arrayAddress,
	                        serviceTime : objServiceTime.trim(),
	                        percent : objPercent,
	                        distArriveClient : objDistArriveClient
	                    });

	                    $(".leaflet-popup-content").css("height", context.adjustHeightBaloon(routeId));
	                    $(".leaflet-popup-content").css("overflow-x", "scroll");
	                    $(".leaflet-popup-content").html(renderedTemplate);

	                }

	            }
	        });

		}(this);
        
    };
	

    this.getStatusStops = function(redeliveryStop, cancelCode, undeliverableCode, actualArrival, actualDeparture) {
        
        var statusStop = "";

        if ( typeof (redeliveryStop) !== "undefined") {
            if (redeliveryStop.description !== "") {

                statusStop = "statusStopRedelivery";
            }

        } else {

            if ( typeof (cancelCode) !== "undefined") {
                if (cancelCode.description !== "") {

                    statusStop = "statusStopCanceled";

                }

            } else {

                if ( typeof (undeliverableCode) !== "undefined") {
                    if (undeliverableCode.description !== "") {

                        statusStop = "statusStopPedidoRetornado";

                    }
                } else {

                    if (actualArrival !== "" && actualDeparture !== "") {

                        statusStop = "statusStopOk";

                    } else {

                        statusStop = "statusStop";

                    }

                }

            }

        }

        return statusStop;
    };

    this.getMotivoByStopStatus = function(stop, stopStatus) {
        
        var motivo = "";

        if (stopStatus == "statusStopRedelivery" || stopStatus == "statusStopPedidoRetornado") {

            motivo = stop.undeliverableCode.description;

        } else if (stopStatus == "statusStopCanceled") {

            motivo = stop.cancelCode.description;

        }

        return motivo;
    };

    this.getItensOfAddres = function(location) {
        
        var itensAddress = [];
        
        for (key in location) {
            if (key == "addressLine1" || key == "addressLine2" || key == "district" || key == "city" || key == "state" || key == "country" || key == "zipcode") {
            	if(key == "addressLine1" && location[key] != ""){
            		itensAddress[0] = location[key];
            	}
            	if(key == "addressLine2" && location[key] != ""){
            		itensAddress[1] = location[key];
            	}
            	if(key == "district" && location[key] != ""){
            		itensAddress[2] = location[key];
            	}
            	if(key == "zipcode" && location[key] != ""){
            		itensAddress[3] = location[key];
            	}
            	if(key == "city" && location[key] != ""){
            		itensAddress[4] = location[key];
            	}
            	if(key == "state" && location[key] != ""){
            		itensAddress[5] = location[key];
            	}
                if(key == "country" && location[key] != ""){
                	itensAddress[6] = location[key];
                }
            }
        }
        
        //remove os itens do array que estão undefined
        itensAddress = itensAddress.filter(
        	function (item) {
        		return item != undefined;
        	}
        );

        return itensAddress;
    };
    /*
     * TODO: Mover para uma classe utilitária ou internacionalização. 
     */
    this.converMilisecondsToSeconds = function(miliseconds) {

        return miliseconds / 1000;

    };

    this.adjustHeightBaloon = function(routeId) {

        var routeView = App.Views.RouteDetails;
        var height    = routeView.getHeightGridStop(routeId);

        return height;
    };

    this.getPercentBetwenArrivalAndDeparture = function(plannedArrival, actualArrival, plannedDeparture, actualDeparture) {
        
    	var planArrival   = Date.create(plannedArrival).getTime();
    	var actArrival    = Date.create(actualArrival).getTime();
    	var planDeparture = Date.create(plannedDeparture).getTime();
    	var actDeparture  = Date.create(actualDeparture).getTime();
        var seconds       = "";
        var minutes       = "";
        var hora          = "";        
        var result;

        var resAct = Math.abs((actArrival - actDeparture));
        var resPla = Math.abs((planArrival - planDeparture));
        
        result = ( resPla - resAct ) / 1000;
        if(result < 0)
        	result = Math.abs(result);
        
        seconds = result % 60;
        
        if(seconds !== 0) {
          seconds += "s";        
        } else {
          seconds = "";  
        }

        if (result > 60) { //minutos

            minutes = parseInt((result % 3600) / 60, 10);
            minutes += "m";

            if (result > 3600) { //hora

                hora = parseInt(result / 3600, 10);
                
                if(hora !== 0) {
                    hora += "h";    
                } else {
                    hora = "";
                }

            }

        }
           
        
        return hora + " " + minutes + " " + seconds;     
        
    };
   
    this.getServiceTime = function(actualService, actualDeparture) {
    	
        var actualService   = Date.create(actualService).getTime();
        var actDeparture = Date.create(actualDeparture).getTime();
        var result;
        var seconds = "";
        var minutes = "";
        var hora = "";

        var actual = actDeparture - actualService;

        var result = this.converMilisecondsToSeconds(actual);

        if (result > 0) {
            seconds = result % 60;
            seconds += "s";

            if (result > 60) {//minutos

                minutes = parseInt((result % 3600) / 60, 10);
                minutes += "m";

                if (result > 3600) {//hora

                    hora = parseInt(result / 3600, 10);
                    hora += "h";

                }

            }
        }

        return hora + " " + minutes + " " + seconds;

    };
    //TODO: mover para uma classe utilitária
    this.getTimeWindow = function(timeWindow) {
        var window = [];

        for (item in timeWindow) {
            var days = [];
            var ocTime = "";
            var tw1 = "";
            var tw2 = "";
            var timeWindows = "";

            for (key in timeWindow[item]) {

            	if ((key == "sunday" || key == "monday" || key == "tuesday" || key == "wednesday" || key == "thursday" || key == "friday" || key == "sunday") && (timeWindow[item][key] == true)) {

                    days.push('Greenmile.Data.WeekDays.' + key.substr(0, 3));

                }
            }

            ocTime = timeWindow[item]["openTime"] + " - " + timeWindow[item]["closeTime"];
            tw1 = timeWindow[item]["tw1Open"] + " " + timeWindow[item]["tw1Close"];
            tw2 = timeWindow[item]["tw2Open"] + " " + timeWindow[item]["tw2Close"];
            timeWindows = tw1 + " - " + tw2;

            window[item] = {
                days : days,
                timeWindow : timeWindows,
                openClose : ocTime
            };
        }

        return window;

    };
    
    /*
     * TODO: Mover para uma classe de mapas ou utilitária. 
     */
    this.getDistanceBetweenTwoPoints = function(lat1, lng1, lat2, lng2) {

        var r = 6371.0;
        var pI = Math.PI;
        var result = "";

        var p1Lat = lat1 * pI / 180;
        var p1Lng = lng1 * pI / 180;
        var p2Lat = lat2 * pI / 180;
        var p2Lng = lng2 * pI / 180;

        var diffLat = p2Lat - p1Lat;
        var diffLng = p2Lng - p1Lng;

        var a = Math.sin(diffLat / 2) * Math.sin(diffLat / 2) + Math.cos(p1Lat) * Math.cos(p2Lat) * Math.sin(diffLng / 2) * Math.sin(diffLng / 2);
        var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));

        result = Math.round(r * c * 1000);
        
        var generalFunctions = Greenmile.Grid.GeneralFunctions;
        result = generalFunctions.formatUnitSystem(result);

        return result;
    };
    /*
     * TODO: Mover para uma classe utilitária ou internacionalização de datas. 
     */
    this.formatDate = function(data) {

        var date = data.split("T")[0];
        var time = data.split("T")[1];

        return Globalize.format(Date.create(date), Monet.I18n.locale.dateFormat) + " " + Globalize.format(Date.create(time), Monet.I18n.locale.timeFormat);

    };
    
    init = function(self){
    	return function(){
    		
    	};
    };
    
   init(this);
	
};
