$(document).ready(function(){
	//get List
	getList();
 
	$("#btnAddNote").click(function(){
		  //Change to the add-notes
		  $("#noteTitle").val("");
		  $("#noteDetails").val("");
		  $("#noteTitle").focus();
		  $('#add-title').html("Add product");
		  $("#noteTitle").removeAttr('disabled');
		  $("#home").attr('aria-hidden', 'true');
		  $("#view-notes").attr('aria-hidden', 'true');
		  $("#add-notes").removeAttr('aria-hidden');
		  $("#view-settings").attr('aria-hidden', 'true');
	});

	$("#home").click(function(){
	  	//Change to the add-notes
		$("#home").attr('aria-hidden', 'true');
          	$("#view-notes").removeAttr('aria-hidden');
		$("#add-notes").attr('aria-hidden', 'true');
		$("#view-settings").attr('aria-hidden', 'true');
		getList(); 
    	});

	$("#btnViewNotes").click(function(){
	  	//Change to the add-notes
		$("#home").attr('aria-hidden', 'true');
		$("#add-notes").attr('aria-hidden', 'true');
		$("#view-settings").attr('aria-hidden', 'true');
		$("#view-notes").removeAttr('aria-hidden');
		getList(); 
    	});

	$(".back").click(function(){
	  	//Change to the add-notes
		$("#home").attr('aria-hidden', 'true');
		$("#add-notes").attr('aria-hidden', 'true');
		$("#view-settings").attr('aria-hidden', 'true');
		$("#view-notes").removeAttr('aria-hidden');
		getList(); 
    	});

	$("#btnViewSettings").click(function(){
	  	//Change to the view-settings
		$("#home").attr('aria-hidden', 'true');
		$("#add-notes").attr('aria-hidden', 'true');
		$("#view-notes").attr('aria-hidden', 'true');
          	$("#view-settings").removeAttr('aria-hidden');
    	});
		
	//Click Handlers for Add Notes page
	$("#btnSaveNote").click(function(){
		 var data = {
		 	"desc" : $("#noteDetails").val(),
		 	"status" : 0
	         }
		 noteTitle   = $("#noteTitle").val();
		 //Save it in local storage
		 if (window.localStorage) {
		      localStorage.setItem(noteTitle, JSON.stringify(data));
		      alert("Your product has been saved");
		 }
		 //empty values
		 $("#noteTitle").val("");
		 $("#noteDetails").val("");
		 $("#noteTitle").focus();
		 //change page
		 $("#home").attr('aria-hidden', 'true'); 
		 $("#add-notes").attr('aria-hidden', 'true');
		 $("#view-settings").attr('aria-hidden', 'true');
		 $("#view-notes").removeAttr('aria-hidden');
		 //get list
		 getList();		  
	});

	//Click Handlers for Settings page
	$("#btnSaveSettings").click(function(){
		 window.localStorage.removeItem('settings');	
		 var data = {
		 	"bgcolor" : $("#noteBackground").val()
	         }
		 noteSettings   = 'settings';
		 //Save it in local storage
		 if (window.localStorage) {
		      localStorage.setItem(noteSettings, JSON.stringify(data));
		      alert("Your settings has been saved");
		 }
		 //reload
		 document.location.href="index.html";		  
	});

	//Clear individual item
	$("#btnClearNote").click(function(){
		var item = $("#noteTitle").val();
		if(confirm('Are you sure you want to delete this note?') === true) {
			 window.localStorage.removeItem(item);			 
		}
		$("#home").attr('aria-hidden', 'true');
          	$("#view-notes").removeAttr('aria-hidden');
		$("#view-settings").attr('aria-hidden', 'true');
		$("#add-notes").attr('aria-hidden', 'true');
		getList();	   
	});
		
	//Clear all list
	$("#clearAllNotesBtn").click(function() {
		 if(confirm('Are you sure you want to reset the application?') === true) {
			 localStorage.clear();
			 //Set title
			 $('#list-title').html("Grocery list (0)");
	 		 $("#note-list").html("");
			 alert("All products have got cleared");
		 }
		 //reload
		 document.location.href="index.html";	   
	});
});

function setTitle() {
	var data = JSON.parse(localStorage.getItem('settings'));
	//alert(data);
	var counter = localStorage.length;
	if(data != null) {
		if(data['bgcolor'] !== "") {
			counter -= 1;
		}
	}
	return counter;
}

function getList() {
	//Empty the list first
	$("#note-list").html("");
	//Set title
	$('#list-title').html("Grocery list ("+setTitle()+")");
	//Read the notes
	for (i = 0; i <= localStorage.length-1; i++)  
	{  
		var key  = localStorage.key(i);  
		var data = JSON.parse(localStorage.getItem(key));
    		if(key !== 'settings') {
			var noteElement = '<li role="listitem"><label><input onclick="checkItem('+i+');" type="checkbox" name="checkbox-'+i+'" id="checkbox-'+i+'" > <span id="note-title'+i+'">'+key+' <small>'+data["desc"]+'</small></span></label><button onclick="editNote('+i+');" class="btn edit"><span>Edit</span></button></li>';
		}
		$("#note-list").append(noteElement);

		if(data["status"] === 1) { 
			 $("#checkbox-"+i).attr('checked' ,true);
			 StrikeThrough(i);
		} else {
			 $("#checkbox-"+i).attr('checked' , false);
			 UnStrikeThrough(i);
		}
	} 
	
}

//edit note
function editNote(i){
    	var key  = localStorage.key(i);  
	var data = JSON.parse(localStorage.getItem(key));
	$("#noteTitle").val(key);
	$("#noteTitle").attr('disabled', 'true');
	$("#noteDetails").val(data['desc']);
	$('#add-title').html("Edit product");
	$("#home").attr('aria-hidden', 'true');
	$("#view-notes").attr('aria-hidden', 'true');
	$("#view-settings").attr('aria-hidden', 'true');
	$("#add-notes").attr('aria-hidden', 'false');
}

//check item
function checkItem(i) { 
    	var key    = localStorage.key(i);  
    	var data   = JSON.parse(localStorage.getItem(key));
	if(data["status"] === 0) { 
		 $('#checkbox-'+i).attr('checked' , true); 
		 var status = 1;
		 document.getElementById('sound-cash').play();
		 StrikeThrough(i);
	} else {
		 $('#checkbox-'+i).attr('checked' , false);
		 var status = 0;
		 document.getElementById('sound-erase').play();
		 UnStrikeThrough(i);
	}
	var item = {
		 	"desc" : data["desc"],
		 	"status" : status
	         }
	 //Save it in local storage
	 if (window.localStorage) {
	      localStorage.setItem(key, JSON.stringify(item));
	 }
}

//set background color
function setColor(color) {
	$('#green').css('border', '1px solid #fff');
	$('#orange').css('border', '1px solid #fff');
	$('#black').css('border', '1px solid #fff');
	$('#blue').css('border', '1px solid #fff');
	$('#noteBackground').val(color);
	$('#'+color).css('border', '2px solid #fff');
}

function StrikeThrough(i) {
    $("#note-title"+i).addClass('strike');
}
function UnStrikeThrough(i) {
    $("#note-title"+i).removeClass('strike');
}
