/**
 * funciones.js funciones de appbasica
 * 
 * @projectDescription     Libreria para la aplicación de appbasica.
 * @author Juan Luis Estevez juanlu@mosaico-web.com
 * @version 1.0
 * @copyright mosaico-web. 
 */
$(document).on("mobileinit", function() {
    $.mobile.defaultPageTransition = 'none';
    $.mobile.allowCrossDomainPages = true;
    jQuery.support.cors = true;
    console.log('entramosen mobilinit');
});
google.load("feeds", "1");
$(document).on("pageshow", "#dondeEstamos", creaMapa);
$(document).on("pagehide", "#leeNoticias", vaciaNoticia);
$(document).on("pageshow", "#verTwitter", creaListaTwitter);
$(document).on("pageshow", "#verFacebook", creaListaFacebook);
$(document).on("pageshow", "#quienesSomos", crearQuienesomos);
$(document).on("pageshow", "#contacta", cargaContacta);
$(document).on("pageshow", "#acercaDe", adaptaAcercaDe);
$(document).on("pageshow", "#leeNoticias", rellenaNoticia);

// Datos de la aplicacion
var titulo = "Grupo Pantoja - Div Transporte";
var app = 1;
var urlServicio = "http://sac.grupopantoja.com/app/servicio/servicio.php?";
var dispositivo;
var plataforma;
var modelo;
var versionSo;
var registrado = false;

//datos rss
var urlRss = "http://grupopantoja.com/feed/"; //Url del rss a leer
var numeroRss = 10; //numero de noticias
var contenidoRss; //varible que almecena el contenido rss

//Datos de la pagina noticias
var noticia;

//Datos quienes somos
var quienesSomosUrl = 'http://grupopantoja.com/transporte/transporte-por-carretera/'; // dirección de la pagina de quines somos
var selectroInicio = '<p>Con el fin de poder ofrecer un servicio integral a nuestros'; //Inicio de la captura de la página
var selectorFin = '<div class="clear-both"></div></div><div class="page"><div style="float: left; width: 192px; height: 500px; margin-right: 15px; margin-bottom: 10px;">'; //Final de la captura
var selectorTitulo = ""; // selector titulo de quienes somos, esn su pagina
var selectorContenido = ""; // selector del conetenido de quines somos.
var contenidoQuienesSomos;
var enIframe = true; //boleano que indica si la pagina se carga via ajax o via iframe.

//datos mapa
/**
 * array con la posiciones del mapa
 * @param {decimal} lat latitud del punto
 * @param {decimal} lon longitud del punto
 * @param {string} direcion dirección postal del punto
 * @param {sting} etiqueta texto del globo del mapa
 * @param {array} telefono es un array por si hay mas de uno
 * @param {string} titulo texto del telefono
 * @param {string} numero numero del telefono
 * @param {array} email es un array por si hay mas de un correo
 * @param {string} nombre texto del correo
 * @param {string} correo email.
 * */
var posicionesMapa = [
    {nombre: "", lat: 37.426726, lon: -5.978223, zoom: 17, direccion: '', etiqueta: '', telefono: ''},
    {nombre: "Sevilla", lat: 37.426726, lon: -5.978223, zoom: 17, direccion: 'Parq empres. Nuevo Torneo, edificio Vilamar 1, Plta 3 41015 Sevilla - ESPAÑA', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]},
    {nombre: "Santiponce", lat: 37.4418, lon: -6.0322, zoom: 17, direccion: 'Camino de la Encinilla s/n, 41970, Santiponce Sevilla - ESPAÑA', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]},
    {nombre: "Tenerife", lat: 28.467538, lon: -16.250368, zoom: 17, direccion: 'Calle Bethencourt Alfonso, 23 2º Planta,38002, Santa Cruz de Tenerife - ESPAÑA', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]},
    {nombre: "Coruña", lat: 43.27191, lon: -8.40944, zoom: 17, direccion: 'C.L. Ledoño. C/ Recreativa Ledoñesa parc. 61-66, Culleredo, 15159 A Coruña - ESPAÑA', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]},
    {nombre: "Murcia", lat: 38.0347, lon: -1.1892, zoom: 17, direccion: 'Polígono Ind. La Polvorista, Manz. B, parc. B17-2, 30500, Molina de Segura. Murcia - ESPAÑA', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]},
    {nombre: "Guadalajara", lat: 40.60692, lon: -3.21552, zoom: 17, direccion: 'C/Francisco Medina y Mendoza. Parcela 23 P.I. Nº 2, 19171, Cabanillas del Campo - ESPAÑA', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]},
    {nombre: "Málaga", lat: 36.69800, lon: -4.49901, zoom: 17, direccion: 'Polígono Ind. Santa Teresa. C/Valleniza, 32-34, 29004, Malaga - ESPAÑA', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]},
    {nombre: "Sabadell", lat: 41.537245, lon: 2.162627, zoom: 17, direccion: ' C/Guifre i pilos s/n. Esquina Roguer de Flor. Naveº 5, 08130, Santa Perpetua de Mogada, Sabadell - ESPAÑA', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]},
    {nombre: "Oporto", lat: 41.24802, lon: -8.63106, zoom: 17, direccion: 'Z.I. da Maia I, Sector 9, Lote 228, 4470 Maia, Porto - Portugal', etiqueta: 'Grupo Pantoja División de Transportes', telefono: [{titulo: 'telefono1', numero: '+34 955996216'}], email: [{nombre: 'email', correo: 'comercial@grupopantoja.com'}]}
];
var mapa; //contenedor de mapa

//Datos twitter
//var nombreTwitter = "charovera"; //usuario de twitter
//var numeroTwitter = 10; //numero de twitter a mostrar 
//var contenidoTwitter; //resultado de los twit

// datos facebook
//var idFacebook = "10151544977814012"; //Id de facebook
//var tokenFacebook = "637019456324890|roWhKM-0F85xNJSaGaOidnKKkBo"; //Token fijo de Facebook
//var contenidoFacebook; //Objeto que almacena el contenido del facebbok

// datos pinterest
//var idPinterest = 'charovera';

//Configuración de paginas, aqui se marca que paginas se ven y cuales no
/**
 * Objeto entrada de menu
 * @param {string} titulo Texto del titulo
 * @param {string} icono string del icono
 * @param {int} orden oden de muestra
 * @param {sting} enlace a que pagina enlaza
 * @param {boolean} visible si esta visible o no 
 * @param {boolean} marcado si esta marcado o no
 * @returns {entradaMenu} 
 */
var entradaMenu = [
    {titulo: "Quienes Somos", icono: "group", enlace: "quienesSomos", funcion: false, orden: 1, visible: true},
    {titulo: "Donde estamos", icono: "globe", enlace: "dondeEstamos", funcion: false, orden: 2, visible: true},
    {titulo: "Noticias", icono: "eye-open", enlace: "verNoticias", funcion: false, orden: 3, visible: true},
    //{titulo: "Facebook", icono: "facebook", enlace: "verFacebook", funcion: false, orden: 4, visible: true},
    //{titulo: "Twitter", icono: "twitter", enlace: "verTwitter", funcion: false, orden: 5, visible: true},
    //{titulo: "Pinterest", icono: "pinterest", enlace: "verPinterest", funcion: false, orden: 6, visible: true},
    {titulo: "Social", icono: "thumbs-up", enlace: "social", funcion: false, orden: 7, visible: true},
    {titulo: "Cliente", icono: "truck", enlace: "misServicios", funcion: false, orden: 8, visible: true},
    {titulo: "Contacta", icono: "envelope", enlace: "contacta", funcion: false, orden: 9, visible: true},
    {titulo: "Acerca de", icono: "info", enlace: "acercaDe", funcion: false, orden: 10, visible: true},
    {titulo: "Salir", icono: "off", enlace: "salirApp", funcion: true, orden: 11, visible: true}
];


var barra; // tamaño de la barra superior
var pantalla; //tamaño de la pantalla.

//Datos de notificaciones push real
var tienePush = false; //indica si la aplicación tiene notificaciones o no
//var notificacionesPush; //Objeto de notificaciones
//var idPush = "963218987371-j4i03dqgdr3uhk9fjjha7cmcmpmgsoi0.apps.googleusercontent.com"; // String con el ide de la aplicación para hacer puhs

/**
 * Esta función se dispara desde las funciones nativas he inicia la plicación
 * @returns {Void}
 */
function iniciar() {
    console.log('entramos en iniciar');
    esperando();
    asignaEntorno();
    estadistica('inicio');
    // se crean lo menus
    $('.titulo').html(titulo);
    calculaResolucion();
    crearMenus();
    // se inicia la lecturas de feeds
    precargaQuienesSomos(true);
    leeRss();
    //leeTwitter();
    //leeFacebook();
    adaptaMapa();
    //navigator.splashscreen.show();
    $.event.special.swipe.horizontalDistanceThreshold = 100;
    eventos();
    //activaPush();
}

function eventos() {
    $('#dayudaAceptar').click(cierraAyuda);
    $('#dayudaNoMostrar').click(noMostrarAyuda);
    $('#centrado').change(centraMapa);
    $('.web, .portaIcono').click(irWeb);
    $('#menuServicios td').click(avisoServicios);
    $('#menuSocial td').click(avisoSocial);
    $('#dAvisoSocialAceptar').click(function(){cierraPopup('#dAvisoSocial');});
    $('#dDesarrolloAceptar').click(function(){cierraPopup('#dDesarrollo');});
}

function cierraAyuda() {
    $('#dAyuda').popup('close');
}

function noMostrarAyuda() {
    localStorage.setItem('noMostrarAyuda', true);
    cierraAyuda();
}

function avisoServicios(){
   $('#dDesarrollo').popup('open'); 
}

function avisoSocial(){
    $('#dAvisoSocial').popup('open'); 
}

function cierraPopup(popup){
    $(popup).popup('close');
}

/**
 * Muestra el grafico de carga
 * @returns {Void}
 */
function esperando() {
    console.log('entramos en Esperando');
    try {        
            $.mobile.loading("show", {
                text: 'Cargando',
                textVisible: true,
                theme: 'b'
            });
    } catch (e) {
        console.log('Error en Esperando: ' + e);
        esperando();
    }
    console.log('Hemos pasado Esperando la funcion');
}

/**
 * Oculta el gráfico de esperando
 * @returns {Void}
 */
function finEspera() {
    $.mobile.loading("hide");
}

/**
 * Envia estadisticas del uso de la aplicación
 * @param {string} queHace
 * @returns {Void}
 */
function estadistica(queHace) {
    var url;
    if (registrado) {
        url = urlServicio + "accion=estadistica&dispositivo=" + dispositivo + "&queHace=" + queHace + "&app=" + app + "&callback=?";
    } else {
        url = urlServicio + "accion=estadistica&dispositivo=" + dispositivo + "&plataforma=" + plataforma + "&modelo=" + modelo + "&versionSo=" + versionSo + "&queHace=" + queHace + "&app=" + app + "&callback=?";
    }
    $.getJSON(url, function(data) {
        if (data.resultado === "Ok") {
            if (!registrado)
                registrado = true;
        }
    });
}

/**
 * Calcula el tamaño de los elementos de la página
 * @returns {Void}
 */
function calculaResolucion() {
    barra = $('.ui-header').height();
    pantalla = screen.height; //$('body').height();
}

/**
 * Crea los Menus de las diferentes páginas
 * @returns {Void}
 */
function crearMenus() {
    entradaMenu.sort(function(a, b) {
        return (a.orden - b.orden);
    });
    var primerMenu;
    for (i = 0; i < entradaMenu.length; i++) {
        if (entradaMenu[i].visible && !entradaMenu[i].funcion) {
            $('#menu' + entradaMenu[i].enlace).html('<li data-role="list-divider"><h2>Menú</h2></li>');
            for (a = 0; a < entradaMenu.length; a++) {
                if (entradaMenu[a].visible) {
                    if (typeof(primerMenu) === 'undefined') {
                        primerMenu = entradaMenu[a].enlace;
                    }
                    var entradaNueva = '<li data-icon="' + entradaMenu[a].icono + '">';
                    if (entradaMenu[a].funcion) {
                        entradaNueva = entradaNueva + '<a href="#" onclick= "' + entradaMenu[a].enlace + '();"';
                    } else {
                        entradaNueva = entradaNueva + '<a href="#' + entradaMenu[a].enlace + '"';
                    }
                    if (entradaMenu[a].enlace === entradaMenu[i].enlace) {
                        entradaNueva = entradaNueva + ' class="ui-btn-hover-b"';
                    }
                    entradaNueva = entradaNueva + '>' + entradaMenu[a].titulo + '</a></li>';
                    $('#menu' + entradaMenu[i].enlace).append(entradaNueva);
                }
            }
        }
    }
    $('#menu' + primerMenu).listview("refresh");
}

/**
 * Hace aparecer el menu lateral
 * @returns {Void}
 */
function muestraMenu() {
    var paginaActual = $.mobile.activePage.attr('id');
    $('#' + paginaActual + ' #menu').panel("open");
}

/**
 * Esta function recibe la notificaciones via push
 * @returns {undefined}
 */
function activaPush() {
    try {
        var socket = io.connect('http://grupoitalica.com:2903/notify');
        socket.on("connect", function() {
            console.log("connected");
            socket.emit("user", {Id: dispositivo});

        });
        socket.on('update', function(data) {
            // Do something cool like update badges/status/etc...
            var texto = data.Counts.texto;
            console.log(texto);
            notificaciones(texto, 0, null, "Mensaje desde el servidor");
            vibrar(1000);
        });
    } catch (e) {
        console.log(e);
    }
}

/**
 * Lee la rss de la url
 * @returns {Void}
 */
function leeRss() {
    var rss = new google.feeds.Feed(urlRss);
    rss.setNumEntries(10);
    rss.load(creaListaRss);
}

/**
 * Crea la lista con las entradas del rss
 * @param {Object} resultado objeto que almacena los resultados de las rss
 * @returns {Void}
 */
function creaListaRss(resultado) {
    estadistica('ver noticias');
    if (!resultado.error) {
        contenidoRss = resultado;
        for (var i = 0; i < resultado.feed.entries.length; i++) {
            var entrada = resultado.feed.entries[i];
            var fila = '<li><a href="#" onclick="muestraNoticia(' + i + ');">';
            fila = fila + '<h1 class=".ui-link">' + entrada.title + '</h1>';
            fila = fila + '<p>' + entrada.contentSnippet + '</p>';
            fila = fila + '</a></li>';
            $('#contieneNoticias').append(fila);
        }
        $('#contieneNoticias').listview("refresh");
    }
}

/**
 * Prepara el desarrollo de las noticas rss
 * @param {Int} id
 * @returns {Void}
 */
function muestraNoticia(id) {
    noticia = contenidoRss.feed.entries[id];
    noticia.tipo = "rss";
    $.mobile.changePage("#leeNoticias");
}

/**
 * Muestra las noticias rss
 * @returns {Void}
 */
function rellenaNoticia() {
    switch (noticia.tipo) {
        case "rss":
            estadistica('ver noticia: ' + noticia.title);
            $('#cabeceraNoticia a').attr('href', '#verNoticias');
            $('#tituloNoticia').html(noticia.title);
            $('#fechaNoticia').html(formatearFecha(noticia.publishedDate));
            var contenido = noticia.content;
            do {
                contenido = contenido.replace('<p>&nbsp;</p>', '');
            } while (contenido.indexOf('<p> </p>') >= 0);
            $('#contenidoNoticia').html(linkify_html(contenido));
            $('#contenidoNoticia a').click(function() {
                sigueEnlace($(this).attr('href'));
                return false;
            });
            var ancho = $('#contenidoNoticia').width();
            if ($('a[rel|="lightbox"]').length > 0) {
                var fotos = $('a[rel|="lightbox"]');
                for (var i = 0; i < fotos.length; i++) {
                    var url = fotos[i].href;
                    var contenedor = $(fotos[i]).parent();
                    $(contenedor[0]).attr('style', '');
                    $(contenedor[0]).html('<img src="' + url + '">');
                }
            }
            $('#contenidoNoticia img').attr('width', '');
            $('#contenidoNoticia img').attr('heigth', '');
            $('#contenidoNoticia img').css({'max-width': ancho, 'margin-left': 'auto', 'margin-right': 'auto', 'display': 'block'});
            break;
        case "facebook":
            estadistica('ver post de facebook: ' + noticia.id);
            $('#cabeceraNoticia a').attr('href', '#verFacebook');
            $('#tituloNoticia').html('');
            $('#fechaNoticia').html(formatearFecha(noticia.created_time.substring(0, 19).replace("T", " ").replace(/-/gi, "/")));
            var contenido = '';
            if (typeof(noticia.picture) !== 'undefined') {
                contenido = '<img src="' + noticia.picture + '">';
            }
            contenido = contenido + linkify_html(noticia.message);
            $('#contenidoNoticia').html(contenido);
            $('#contenidoNoticia a').click(function() {
                abreWeb($(this).attr('href'));
                return false;
            });
            var ancho = $('#contenidoNoticia').width();
            $('#contenidoNoticia img').css({'float': 'left', 'max-width': ancho, 'margin-right': '10px', 'margin-left': 'auto', 'display': 'block'});
            break;
    }

}

/**
 * Vacia de contenido la pagina de las noticias
 * @returns {Void}
 */
function vaciaNoticia() {
    $('#tituloNoticia').html('');
    $('#fechaNoticia').html('');
    $('#contenidoNoticia').html('');
}

/**
 * Muestra la lista de rss
 * @returns {Void}
 */
function volverRss() {
    $.mobile.changePage("#noticias");
}

/**
 * Lee los twitter y los pasa a un objeto
 * @returns {Void}
 */
function leeTwitter() {
    var twitter = new Codebird;
    twitter.setConsumerKey("jiG3jjkTt76AVHXHehZXw", "3p58L8xL5qKD9jR6eJJp63Q6fQqiwaphz28zZ2aag");
    twitter.setToken("301057433-xeTiRhd3Z04zAINvifmQyFb1r147l2V9KCi1cVQo", "wYcAUoSVUehluoWmbkJHCNQvqoj3cWq9FglUi7XWE0");

    twitter.__call(
            "statuses_userTimeline", {
        'screen_name': nombreTwitter,
        'count': numeroTwitter
    },
    function(reply) {
        contenidoTwitter = reply;
    }
    );
}

/**
 * Crea la lista con los resultados de los Twit
 * @returns {Void}
 */
function creaListaTwitter() {
    estadistica('ver twitter');
    $('#contieneTwitter').html('');
    var datos = contenidoTwitter;
    if (!datos.errors) {
        var imagePerfil = datos[0].user.profile_image_url;
        var fondoPerfil = "";// "'" + datos[0].user.profile_background_image_url + "'";
        var nombrePantalla = datos[0].user.screen_name;
        var descripcion = datos[0].user.description;
        var seguidores = datos[0].user.followers_count;

        var cabecera = '<li style="background-image:url(' + fondoPerfil + '); background-color:#cccccc; text-align:center">';
        cabecera = cabecera + '<img src="' + imagePerfil + '"><h1>@' + nombrePantalla + '</h1><p>' + descripcion + '</p> </li>';
        $('#contieneTwitter').append(cabecera);

        for (var i = 0; i < datos.length; i++) {
            var twit = datos[i];
            var fila = '<li>';
            fila = fila + '<h1>' + formatearFecha(twit.created_at) + '</h1>';
            fila = fila + '<p>' + linkify_html(twit.text) + '</p>';
            fila = fila + '</li>';
            $('#contieneTwitter').append(fila);
        }
        $('#contieneTwitter').listview("refresh");
        $('#contieneTwitter li a').click(function() {
            abreWeb($(this).attr('href'));
            return false;
        });
    }
}

// parte de facebook

/**
 * Lee el Facebook
 * @returns {Void}
 */
function leeFacebook() {
    var url = "https://graph.facebook.com/" + idFacebook + "/feed?fields=message,picture,link&access_token=" + tokenFacebook;
    $.getJSON(url, function(data) {
        contenidoFacebook = data;
    });
}

/**
 * Crea la lista de los Facebook
 * @returns {Void}
 */
function creaListaFacebook() {
    estadistica('ver facebook');
    $('#contieneFacebook').html('');
    var datos = contenidoFacebook.data;
    if (!datos.errors) {
        for (var i = 0; i < datos.length; i++) {
            if (typeof(datos[i].message) !== 'undefined') {
                var post = datos[i];
                var fila = '<li><a href="#" onclick="muestraPostFacebook(' + i + ');">';
                fila = fila + '<h1>' + formatearFecha(post.created_time.substring(0, 19).replace("T", " ").replace(/-/gi, "/")) + '</h1>';
                if (typeof(post.picture) !== 'undefined') {
                    fila = fila + '<img src="' + post.picture + '">';
                }
                fila = fila + '<p>' + post.message.slice(0, 100) + '...</p>';
                fila = fila + '</a></li>';
                $('#contieneFacebook').append(fila);
            }

        }
        $('#contieneFacebook').listview("refresh");
    }
}
/**
 * Prepara el desarrolo de los post
 * @param {Int} id del post
 * @returns {undefined}
 */
function muestraPostFacebook(id) {
    noticia = contenidoFacebook.data[id];
    noticia.tipo = "facebook";
    $.mobile.changePage("#leeNoticias");
}

/**
 * crearPinterest
 * @returns {Void}
 */
function crearPinterest() {
    $('#contienePinterest').attr('href', 'http://pinterest.com/' + idPinterest);
    var tamanoPinterest = pantalla - (barra + infoMapa) - 20;
    $('#contienePinterest').attr('data-pin-scale-height', tamanoPinterest);
}

/**
 * Crea el Mapa
 * @returns {Void}
 */
function creaMapa() {
    $('#centrado').html('');
    estadistica('ver mapa');
    var latLong = new google.maps.LatLng(posicionesMapa[0].lat, posicionesMapa[0].lon);
    var opcionesMapa = {
        center: latLong,
        zoom: posicionesMapa[0].zoom,
        mapTypeControl: true,
        zoomControl: true,
        zoomControlOptions: {
            style: google.maps.ZoomControlStyle.SMALL
        },
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    mapa = new google.maps.Map(document.getElementById('portaMapas'), opcionesMapa);
    var puntosMapa = new google.maps.LatLngBounds();
    var etiqueta, posicionpunto, punto;
    for (i = 1; i < posicionesMapa.length; i++) {
        etiqueta = posicionesMapa[i].etiqueta;
        posicionpunto = new google.maps.LatLng(posicionesMapa[i].lat, posicionesMapa[i].lon);
        punto = new google.maps.Marker({
        position: posicionpunto,
        map: mapa,
        title: etiqueta
    });
        if (i === 1) {
            $('#centrado').append(new Option(posicionesMapa[i].nombre, i, 1, 1));
        } else {
            $('#centrado').append(new Option(posicionesMapa[i].nombre, i));
        }        
    }
    $('#centrado').selectmenu("refresh");
    rellenaDireccion(1);
    adaptaMapa();
}

function rellenaDireccion(id) {
    $('#portaDireccion').html(posicionesMapa[id].direccion);
    var numeroTelefono = "";
    for (a = 0; a < posicionesMapa[id].telefono.length; a++) {
        numeroTelefono = numeroTelefono + posicionesMapa[id].telefono[a].numero + " ";
    }
    $('#portaTelefonos').html(numeroTelefono);
    var todosCorreos = "";
    for (a = 0; a < posicionesMapa[id].email.length; a++) {
        todosCorreos = todosCorreos + posicionesMapa[id].email[a].correo + " ";
    }
    $('#portaEmail').html(todosCorreos);
    adaptaMapa();
}

/**
 * Adapta el tamaño del mapa
 * @returns {Void}
 */
function adaptaMapa() {
    var infoMapa = $('#infoMapa').height() + 14;
    $('#portaMapas').css('bottom', infoMapa);
    $('#infoMapa').width($('#portaMapas').width() - 13);
//    var tamanoMapa = pantalla - (barra + infoMapa) - 3;
//    $('#portaMapas').height(tamanoMapa);
}

function centraMapa(posicion) {
    var id = parseInt(posicion.currentTarget.value);
    mapa.setCenter(new google.maps.LatLng(posicionesMapa[id].lat, posicionesMapa[id].lon), posicionesMapa[id].zoom);
    rellenaDireccion(id);
}

/**
 * Obtiene los datos de la pagina de quines somos
 * @param {Boolean} inicial indica si rellena 
 * @returns {undefined}
 */
function precargaQuienesSomos(inicial) {
//    console.log('entramos en Quines somos');
//    if (typeof(inicial) === "undefined")
//        inicial = false;
//    $.ajax(quienesSomosUrl)
//            .done(function(data) {
//        var resultado = data;
//        if (selectorContenido !== '') {
//            contenidoQuienesSomos = $(selectorContenido).html();
//        } else {
//            var inicio = resultado.indexOf(selectroInicio);
//            var final = resultado.indexOf(selectorFin);
//            contenidoQuienesSomos = resultado.substring(inicio, final);
//
//        }
        contenidoQuienesSomos = '<p>Con el fin de poder ofrecer un servicio integral a nuestros clientes realizamos transporte de mercancías en cargas completas y grupaje tanto a nivel nacional como internacional por carretera en tautliner y frigo, marítimo y aéreo.</p>' +
                    '<p>Tenemos, gracias a la confianza depositada por nuestros clientes a lo largo de los <span style="color: #957a04;">más de 60 años</span>, flujos a todos los países de la Unión Europea y a los países del este, así como rutas a distintos puntos de África, Asia y Sudamérica.</p>' +
                    '<p>Nuestra contrastada experiencia en el sector, nos sitúa como empresa referencia en crecimiento y calidad de servicio a nivel internacional.</p>' +
                    '<p>Un equipo <span style="color: #957a04;">de expertos</span> analizan todo su proceso productivo y le ofrecen soluciones competitivas que se ajustan en cada caso a sus necesidades de transporte con garantía de éxito.</p>' + 
                    '<p>Nuestros expertos hablan castellano, portugués, francés, inglés, italiano y alemán… para que nadie se quede atrás.</p>';
        if (inicial)
            crearQuienesomos();
        if (!localStorage.getItem('noMostrarAyuda'))
            $('#dAyuda').popup('open');
//    });
}

/**
 * Crea el contenido de quines somos
 * @returns {Void}
 */
function crearQuienesomos() {
    //var cargasCompletas = ''
    $('#contieneHTML').html(contenidoQuienesSomos);
    //$('#tituloQuienesSomos').html($('#contieneHTML ' + selectorTitulo).html());
    $('#contenidoQuienesSomos').html($('#contieneHTML ' + selectorContenido).html());
    $('#contenidoQuienesSomos a').click(function() {
        abreWeb($(this).attr('href'));
        return false;
    });
    $('#contenidoQuienesSomos img').attr('width', '');
    var ancho = $('#contenidoQuienesSomos').width();
    $('#contenidoQuienesSomos img').attr('heigth', '');
    $('#contenidoQuienesSomos img').css({'max-width': ancho, 'height': 'auto', 'margin-left': 'auto', 'margin-right': 'auto', 'display': 'block'});

    finEspera();
}

/**
 * Inica el formulario de contacto
 * @returns {Void}
 */
function cargaContacta() {
    estadistica('ver contacta');
    vaciaContacta();
    var altura = $('#contacta .ui-content').height();
    var tamanoTextArea = $('body').height() - (barra + altura);
    $('#fTexto').height($('#fTexto').height() + tamanoTextArea);
}

/**
 * Vacia el contenido del 
 * @returns {void}
 */
function vaciaContacta() {
    $('#fEmail').val('');
    $('#fTexto').val('');
}

/**
 * Envia por email el contenido del formulario de contacta
 * @returns {void}
 */
function enviarContacta() {
    var texto = $('#fTexto').val();
    var email = $('#fEmail').val();
    if (texto.length === 0) {
        notificaciones("No has escrito nada en cuéntanos", 0, null, "No hay mensaje");
    } else {
        var url = urlServicio + "accion=enviarCorreo&dispositivo=" + dispositivo + "&app=" + app + "&texto=" + texto + "&email=" + email + "&callback=?";
        esperando();
        $.getJSON(url, function(data) {
            if (data.envio) {
                finEspera();
                notificaciones('Envio correcto', 0, muestraMenu, 'Envio Ok');
                vaciaContacta();
            } else {
                finEspera();
                notificaciones('Error en el envio intentelo de nuevo', 0, null, 'Error de envio');
            }
        });
    }
    return null;
}

/**
 * Adapta el tamaño de Acerca de
 * @returns {Void}
 */
function adaptaAcercaDe() {
    $('#uid').html(dispositivo);
//    var contenido = $('#cliente').height() + $('#produccion').height();
//    var espacio = pantalla - (barra + contenido);
//    $('#espacio').height(espacio - 110);
    $('#contenidoAcercaDe a').click(function() {
        abreWeb($(this).attr('href'));
        return false;
    });
}

//Funciones comunes


function irWeb(elemento){
    new MozActivity({
    "name":"view",
    "data":
      {
        "type":"url",
        "url":elemento.currentTarget.title
      }
});
}

function sigueEnlace(url){
    new MozActivity({
    "name":"view",
    "data":
      {
        "type":"url",
        "url":url
      }
});
}

/**
 * Formate ala fecha de forma que se pueda mostrar en pantalla
 * @param {date} fecha
 * @returns {String}
 */
function formatearFecha(fecha) {
    fecha = new Date(fecha);
    var dia = aDosCifras(fecha.getDate());
    var mes = aDosCifras(fecha.getMonth() + 1);
    var ano = fecha.getFullYear();
    var hora = aDosCifras(fecha.getHours());
    var minutos = aDosCifras(fecha.getMinutes());
    fecha = dia + "/" + mes + "/" + ano + " " + hora + ":" + minutos;
    return fecha;
}

/**
 * Añade un 0 al principio sin sion numero de una sola cifra
 * @param {int} cifra
 * @returns {String}
 */
function aDosCifras(cifra) {
    if (cifra < 10) {
        cifra = "0" + cifra;
    }
    return cifra;
}