var FirefoxGSP = {
    options : {
        currentPage : "splash",
        cachedLines : []
    },
    initApp : function( callback ) {
        var self = this,
            o = self.options;

        // Podesi currentPage
        o.currentPage = self.currentPage();

        // Prikazi loader pri ucitavanju stranice
        $.mobile.loading( 'show', {
            text: 'Ucitavanje...',
            textVisible: true,
            theme: 'a',
            html: ""
        });

        // Ucitaj sve linije, a zatim idi na home page ako si trenutno na splash-u
        FirefoxGSP_API.getData( 'lines', function( data ) {
            o.cachedLines = data;
            if (o.currentPage == "splash") {
                setTimeout(function() {
                    $.mobile.changePage("#home");
                }, 1000);
            }
        });

        FirefoxGSP_API.getLive('last_update', function(data) {
            var tmp = FirefoxGSP_API.getCached( 'last_update' ),
                tmpSize = FirefoxGSP_API.objectSize(tmp);

            if (!!tmpSize) {
                // console.log( data.last_update, tmp.last_update );
                if (tmp.last_update !== data.last_update) {
                    // console.log('UPDATE AVAILABLE !');
                    self.updateData(function() {
                        FirefoxGSP_API.setCached('last_update', data);
                        window.location = "index.html";
                    });
                } else {
                    // console.log('no update available');
                }
            } else {
                // FirefoxGSP_API.setCached('last_update', '123');
                FirefoxGSP_API.setCached('last_update', data);
            }

        }, false);

        var precached = FirefoxGSP_API.getCached('precached');

        if (precached===true) {
            $("#precacheGridBlock").hide();
        }
        // Aktiviraj sve triggere
        self.setTriggers();

        // self.populateLineInfo(2,0,'R');
    },
    setTriggers: function() {
        var self = this,
            o = self.options;

        $(".showLines").on('click', function(e) {
            var $this = $(this),
                gsptype = $this.data('gsptype');
            e.preventDefault();

            jQuery.mobile.changePage("#linesListPage");
            self.populateLines( gsptype );
        });

        $(document).on('click', ".lineSingleListView", function(e) {
            var $this = $(this),
                line_id = $this.data('line_id');

            self.populateLineInfo( line_id, 0, 'R' );
        });
        $(".tableViewDaysBtn").on('click', function() {
            var $this = $(this),
                line_id = $("#tableView").data('lineid'),
                day = $this.data('day');

            $("#tableView").data('day', day);
            self.populateLineInfo( line_id, 0, day );
        });
        $("#lineDirectionChooser").on('change', function() {
            var $this = $(this),
                line_id = $("#tableView").data('lineid'),
                day = $("#tableView").data('day'),
                direction = $this.val();

            self.populateLineInfo( line_id, direction, day );
        });

        $(".loadAllData").on('click', function() {
            var tolito = TolitoProgressBar('progressbar')
                .setInnerTheme('b')
                .isMini(true)
                // .setMax(0)
                .showCounter(false);
                // .build();

            $(document).on('complete', '#progressbar', function () {
                tolito.destroy();
                FirefoxGSP_API.setCached('precached',true);
                window.location="index.html";
            });
            self.loadAllData( tolito );
        });

        $(".reloadSite").on('click', function(e) {
            e.preventDefault();
            location.reload(true);
        });

        $(document).on('pageshow', function() {
            o.currentPage = self.currentPage();
        });
    },
    loadAllData : function(loader) {
        var loaded = 0, i, lines = FirefoxGSP_API.getCached('lines');

        loader.setMax( lines.length ).build();

        for (i in lines) {
            // console.log( lines[i] );

            FirefoxGSP_API.getLive('linedata-'+lines[i].line_id, function(data) {
                loaded++;
                loader.setValue(loaded);
                // console.log( data );
            });
        }
    },
    updateData : function( callback ) {
        if (confirm('Izasla je nova verzija reda voznje, da li zelite da obrisete sacuvane linije i ucitate najsvezije sa servera?')) {
            var key;

            localStorage.removeItem( 'ffgsp-lines' );
            localStorage.removeItem( 'ffgsp-precached' );
            for (key in localStorage) {
                if ( key.substr(0,14) === 'ffgsp-linedata' ) {
                    console.log( key );
                    localStorage.removeItem( key );
                }
            }

            callback();
        }
    },
    populateLines : function( gsptype ) {
        var self = this,
            o = self.options,
            $list = $("#linesListView");

        $list.empty();

        $.each(o.cachedLines, function(key, value) {
            if (value.type == gsptype) {
                $list
                .append(
                    $("<li></li>").append(
                        $("<a/>").attr('href','#')
                                 .addClass("lineSingleListView")
                                 .data('line_id', value.line_id)
                                 .text( value.number + " - " + self.htmlDecode( value.name ))
                    )
                );

            }

        });

        $list.listview('refresh');
    },
    populateLineInfo : function( line_id, direction, day ) {
        var self = this,
            $tableView = $("#tableView");

        $.mobile.loading( 'show', {
            text: 'Ucitavanje...',
            textVisible: true,
            theme: 'a',
            html: ""
        });
        FirefoxGSP_API.getData( 'linedata-'+line_id, function( data ) {
            var i,j, out = "";
            jQuery.mobile.changePage("#tableView");
            $.mobile.loading( 'hide' );

            // Dodelimo klasu ui-btn-active na odgovarajuc dan (radni, subota, nedelja)
            $(".tableViewDaysBtn").each(function() {
                var $this = $(this);

                if ( $this.data('day') === day ) {
                    $this.addClass('ui-btn-active');
                }
            });

            // Popunjavamo data-lineid u tableView
            $tableView.data('lineid', line_id);

            // Popunjavamo title sa brojem i imenom linije
            $tableView.find('.lineTitle').text( data.lineNumber +". " + self.htmlDecode( data.lineName ) );

            // Popunjavamo dropdown za smerove
            var $selectChooser = $("#lineDirectionChooser"),
                selected = false;

            $selectChooser.empty();
            $selectChooser.append('<option>Izaberite smer:</option>');

            for (i in data.directions) {
                // Uvek selektujemo prvi direction
                if (direction == data.directions[i].direction_id) selected = true;
                else if ( (direction === 0) && (i==="0") ) selected = true;
                else selected = false;


                $selectChooser.append(
                    $("<option/>").text( self.htmlDecode( data.directions[i].direction_name ) )
                                  .val( data.directions[i].direction_id)
                                  .attr('selected',selected)
                );
            }
            $selectChooser.selectmenu('refresh');


            // Popunjavamo spisak sa vremenima
            for (i in data.times) {
                if (!direction) direction = i;

                if (direction != i) continue;

                for( j in data.times[i] ) {
                    var mins = data.times[i][j][day];
                    if (mins === undefined) continue;
                    out += "<li>" + self.displayNumber( j ) + "<sup>" + mins + "</sup></li>";
                }
                $tableView.find('.lineTimesData').html( out );
                break;
            }

            // Popunjavamo extraInfo ako ima
            $tableView.find('.extraInfo').html( data.extraInfo );
        });
    },
    displayNumber : function(num) {
        if (num<10) return "0" + num;
        else return num;
    },
    currentPage : function() {
        return $(".ui-page-active").attr('id');
    },
    htmlDecode : function( value ) {
        return $('<div/>').html(value).text();
    }

};