var FirefoxGSP_API = {
    options : {
        apiUrl : "http://gsp.turshija.com/",
        // apiUrl : "http://localhost/FirefoxGSPServer/",
        localStoragePrefix : 'ffgsp-'
    },
    /**
     * Metoda uzima podatke koje zatrazimo
     *
     * Prvo proveri da li podaci postoje u cache, ako postoje vrati ih,
     * ako ne postoje, onda poziva getLive metodu koja fetch-uje sveze
     * podatke sa servera
     */
    getData : function( type, callback ) {
        var tmp = this.getCached( type ),
            tmpSize = this.objectSize(tmp);

        if ( !tmpSize ) {
            // console.log('No cached data found for ' + type + '! Fetching live data now !');
            this.getLive(type, function( data ) {
                // console.log('Fetched live data', data);
                callback( data );
            });
        } else {
            // console.log('Data for ' + type + ' found in cache!', tmp);
            callback( tmp );
        }
    },
    /**
     * Metoda koja uzima sveze podatke sa API-ja koje zatrazimo
     *
     * Salje se AJAX zahtev za uzimanje svezih podataka sa API-ja.
     * API vraca podatke koje keshiramo pozivom setCached metode
     * a zatim poziva callback sa podacima
     */
    getLive : function( type, callback, cacheme ) {
        var self = this,
            o = self.options;

        cacheme = typeof cacheme !== 'undefined' ? cacheme : true;
        $.ajax({
            url: o.apiUrl + 'get.php',
            type: 'GET',
            dataType: 'jsonp',
            data: {
                data: type
            },
            success: function(data, textStatus, xhr) {
                if (cacheme) {
                    self.setCached( type, data );
                }
                // console.log('Caching data for '+type);
                callback( data );
            },
            error: function(xhr, textStatus, errorThrown) {

            }
        });
    },
    /**
     * Metoda koja uzima keshirane podatke iz localStorage
     *
     * Prvo procita podatke iz localStorage, a zatim uradi JSON.parse
     * posto su keshirani podaci zapravo JsonP objekat pretvoren u string
     * Ukoliko nema nista u keshu, vraca prazan objekat []
     */
    getCached : function( type ) {
        var o = this.options;

        return JSON.parse(
            localStorage.getItem( o.localStoragePrefix + type )
        ) || [];
    },
    /**
     * Metoda snima podatke u localStorage
     *
     * Kako bi mogli da sacuvamo JsonP objekat u localStorage, potrebno je
     * prvo da ga pretvorimo u string pomocu JSON.stringify
     */
    setCached : function( type, data ) {
        var o = this.options;

        localStorage.setItem( o.localStoragePrefix + type, JSON.stringify(data) );
    },
    /**
     * Metoda koja vraca velicinu objekta
     * @source - http://stackoverflow.com/questions/5223/length-of-javascript-object-ie-associative-array
     */
    objectSize : function(obj) {
        var size = 0, key;
        for (key in obj) {
            if (obj.hasOwnProperty(key)) size++;
        }
        return size;
    }


};