// Bubble Pop Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Bubble Pop Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after the required number of bubbles for the round have been popped and eating by the catcher.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a bubble with a target item is touched.
//         
// Round Properties
//
//     numBubbles: Maximum number of bubbles visible on the screen at once.
//     background
//         Properties:
//            filename: Filename of the background image.
//     bubbleHighlight: Displayed behind the bubble when it is highlighted.
//     bubblePopAnimation: Displayed when a bubble is touched.
//     emptyBubble
//         Properties:
//             filename: Filename of the emoty bubble image.
//     catcher: A character would catches items that fall out of bubbles which are popped.
//         Available States:
//             WAIT: Displayed when the catcher is not active.
//             WAVE: Displayed at the beginning of each round.
//             MOVE: Displayed when the catcher is moving.
//             JUMP: Displayed when a popped bubble has dropped in range of the catcher.
//				PAYOFF: Required for final payoff animation
//				ENDPOSE: Required for final payoff animation as final pose for end of round
//     target: A random item is selected at the start of each round to be the correct item.
//         Properties:
//             unpopped
//                 Properties:
//                     filename: Filename of the image displayed if the bubble has not been touched.
//             popped
//                 Properties:
//                     filename: Filename of the image displayed after bubble has been touched.
//             label
//                 Available States:
//                     NOTFOUND: Initial state of the label.
//                     FOUND: Displayed after the item is found.
//     distractors (Array): Array of objects that will be displayed with target bubbles that just pop when touch
//         Properties:
//             filename: Filename of the distractor image.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -64
		}
	},
	gameIcon: "H5_hpthumb_guacamole.png",
	audioEnabled: true,
	// jhl
	endRoundPayoff: false,
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "HTML5_startscreen_etm_guacamole_ipad.jpg",
	audioFilename: "audio-bubblePop-guac.mp3", //all audio including intro, payoff, and music is in one file found here
	audio: {
		states: [
			{
				name: "music", 
				startTime: 72,
				duration: 26.2,
				loop: true
			}
		]
	},
	hud: {
		sidebar: {
			type: "SIDEBAR",
			states: [
				{
					type: "Default",
					filename: "sidebar.png",
					numFrames: 12,
					autoStart: false
				}
			]
		}
	},
	rounds: [ 
		{ //round1
			numBubbles: 6, //the number of bubbles on the screen at one time
			endRoundPayoff: false,
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 0,
						duration: 8.8
					}, {
						name: "payoff",
						startTime: 9.7,
						duration: 6.5
					}
				]
			},
			background: {
				filename: "Guac-Background-1.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: -3,
				offsetY: -4
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "elmo-wait.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Wave",
						filename: "EtM_Guac_ENTER.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					},{
						type: "Move",
						filename: "elmo-move2.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Jump",
						filename: "EtM_Guac_Catch_Onion.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "Bubble-Red-Onion.png"
				},
				popped: {
					filename: "onion.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-onion.png"
						},{
							type: "Found",
							filename: "label-onion-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Distracter-Bubble-Banana.png"
				},
				{
					filename: "Distracter-Bubble-Carrot.png"
				},
				{
					filename: "Distracter-Bubble-Sardine.png"
				}
			]
		},
		{ //round2
			numBubbles: 6, //the number of bubbles on the screen at one time
			endRoundPayoff: false,
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 16.7,
						duration: 4.3
					}, {
						name: "payoff",
						startTime: 21.7,
						duration: 5.8
					}
				]
			},
			background: {
				filename: "Guac-Background-2.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: -3,
				offsetY: -3
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "elmo-wait.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Wave",
						filename: "EtM_Guac_ENTER.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					},{
						type: "Move",
						filename: "elmo-move2.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Jump",
						filename: "EtM_Guac_Catch_Tomato.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "Bubble-Tomato.png"
				},
				popped: {
					filename: "tomato.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-tomato.png"
						},{
							type: "Found",
							filename: "label-tomato-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Distracter-Bubble-Banana.png"
				},
				{
					filename: "Distracter-Bubble-Carrot.png"
				},
				{
					filename: "Distracter-Bubble-Sardine.png"
				}
			]
		},
		{ //round3
			numBubbles: 6, //the number of bubbles on the screen at one time
			endRoundPayoff: false,
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 27.7,
						duration: 4.6
					}, {
						name: "payoff",
						startTime: 32.7,
						duration: 6.5
					}
				]
			},
			background: {
				filename: "Guac-Background-3.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: -3,
				offsetY: -3
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "elmo-wait.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Wave",
						filename: "EtM_Guac_ENTER.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					},{
						type: "Move",
						filename: "elmo-move2.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Jump",
						filename: "EtM_Guac_Catch_Garlic.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "Bubble-Garlic.png"
				},
				popped: {
					filename: "garlic.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-garlic.png"
						},{
							type: "Found",
							filename: "label-garlic-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Distracter-Bubble-Banana.png"
				},
				{
					filename: "Distracter-Bubble-Carrot.png"
				},
				{
					filename: "Distracter-Bubble-Sardine.png"
				}
			]
		},
		{ //round4
			numBubbles: 6, //the number of bubbles on the screen at one time
			endRoundPayoff: false,
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 40.7,
						duration: 4.1
					}, {
						name: "payoff",
						startTime: 45.7,
						duration: 6.8
					}
				]
			},
			background: {
				filename: "Guac-Background-4.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: -3,
				offsetY: -3
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "elmo-wait.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Wave",
						filename: "EtM_Guac_ENTER.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					},{
						type: "Move",
						filename: "elmo-move2.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Jump",
						filename: "EtM_Guac_Catch_Lime.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "Bubble-Lime.png"
				},
				popped: {
					filename: "lime.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-lime.png"
						},{
							type: "Found",
							filename: "label-lime-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Distracter-Bubble-Banana.png"
				},
				{
					filename: "Distracter-Bubble-Carrot.png"
				},
				{
					filename: "Distracter-Bubble-Sardine.png"
				}
			]
		},
		{ //round5
			numBubbles: 6, //the number of bubbles on the screen at one time
			endRoundPayoff: true,
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 53.7,
						duration: 5.2
					}, {
						name: "payoff",
						startTime: 58.7,
						duration: 11.8
					}
				]
			},
			background: {
				filename: "Guac-Background-5.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: -3,
				offsetY: -3
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "elmo-wait.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Payoff",
						filename: "EtM_Guac_END.png",
						numFrames: 28,
						offsetX: 0,
						offsetY: 10,
					},{
						type: "EndPose",
						filename: "EtM_Guac_END_still.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: 10,
						loop: false
					},{
						type: "Wave",
						filename: "EtM_Guac_ENTER.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					},{
						type: "Move",
						filename: "elmo-move2.png",
						numFrames: 1,
						offsetX: 0,
						offsetY: -15,
						loop: false
					},{
						type: "Jump",
						filename: "EtM_Guac_Catch_Avocado.png",
						numFrames: 14,
						offsetX: 0,
						offsetY: -15
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "Bubble-Avocado.png"
				},
				popped: {
					filename: "avocado.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-avocado.png"
						},{
							type: "Found",
							filename: "label-avocado-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "Distracter-Bubble-Banana.png"
				},
				{
					filename: "Distracter-Bubble-Carrot.png"
				},
				{
					filename: "Distracter-Bubble-Sardine.png"
				}
			]
		}
	]
};