(function ($) {

    // declaring the variables
    var currentLowerLimit, currentUpperLimit, userGuess, correctAnswer, 
        currentNumberOfTries, initApp, getRandomInt, wireEventHandlers, resetApp,
        debug, isDebugOn, updateGameHelp, updateFeedback, updateTriesCount,
        DEFAULT_LOWER_LIMIT, DEFAULT_UPPER_LIMIT, MAX_TRIES,
        LEVEL1_UPPER_LIMIT, LEVEL2_UPPER_LIMIT,
        LEVEL3_UPPER_LIMIT, LEVEL4_UPPER_LIMIT;

    // set debug on/off here
    isDebugOn = false;
    
    // custom debug function for logging
    debug = function(msg) {
        if(isDebugOn && console !== undefined) {
            console.log('Guess-A-Number$ ' + msg);
        }
    };
    
    // update game help
    updateGameHelp = function () {
        debug('updateGameHelp()');
        
        $('#gameHelp').html('Guess a number between ' + currentLowerLimit + ' - ' + currentUpperLimit);
    };
    
    // update feedback
    updateFeedback = function (msg) {
        $('#feedback')
            .html('<h3>' + msg + '</h3>')
            .hide()
            .fadeIn(500);
    };
    
    updateTriesCount = function () {
        $('#triesCount')
            .html(currentNumberOfTries)
            .hide()
            .fadeIn(500);
    };
    
    resetApp = function () {
        currentNumberOfTries = 0;
        updateTriesCount();
        updateFeedback('Try something!');
        
        $('.answer').hide();
        $('.userInterface').show();
        $('#userGuess').val('');
        $('.tryAgain').hide();
    };
    
    // attach all event handlers
    wireEventHandlers = function () {
        debug('wireEventHandlers()');

        $('#lvl1').click(function () {
            debug('#lvl1 click');

            currentUpperLimit = LEVEL1_UPPER_LIMIT;
            correctAnswer = getRandomInt(currentLowerLimit, currentUpperLimit);
            updateGameHelp();
            
            debug('correctAnswer - ' + correctAnswer);
        });

        $('#lvl2').click(function () {
            debug('#lvl2 click');

            currentUpperLimit = LEVEL2_UPPER_LIMIT;
            correctAnswer = getRandomInt(currentLowerLimit, currentUpperLimit);
            updateGameHelp();
            
            debug('correctAnswer - ' + correctAnswer);
        });

        $('#lvl3').click(function () {
            debug('#lvl3 click');

            currentUpperLimit = LEVEL3_UPPER_LIMIT;
            correctAnswer = getRandomInt(currentLowerLimit, currentUpperLimit);
            updateGameHelp();
            
            debug('correctAnswer - ' + correctAnswer);
        });

        $('#lvl4').click(function () {
            debug('#lvl4 click');

            currentUpperLimit = LEVEL4_UPPER_LIMIT;
            correctAnswer = getRandomInt(currentLowerLimit, currentUpperLimit);
            updateGameHelp();

            debug('correctAnswer - ' + correctAnswer);
        });
        
        $('.tryAgain').click(function () {
            resetApp();
        });
      
        $('#checkTheAnswer').click(function () {
            debug('#checkTheAnswer click');

            userGuess = $('#userGuess').val();
            
            if(userGuess == '') {
                debug('no input');
                
                updateFeedback('Try something!');
                return;
            }
            
            currentNumberOfTries++;
            updateTriesCount();
            
            debug('userGuess - ' + userGuess);
            debug('correctAnswer - ' + correctAnswer);
            
            if(userGuess == correctAnswer) {
                debug('guessed correct');
 
                updateFeedback('Correct! Well Done');
                
                $('.userInterface').hide();
                $('.tryAgain').fadeIn(500);
            }
            else {
                debug('guessed wrong');
                
                if(currentNumberOfTries >= MAX_TRIES) {
                    debug('MAX_TRIES reached');
                    updateFeedback('Maximum tries reached!');
                    
                    $('.answer').html( $('<h3>Answer - ' + correctAnswer + '</h3>')).fadeIn(200);
                    $('.userInterface').hide();
                    $('.tryAgain').fadeIn(500);
                }
                else {
                    debug('MAX_TRIES not reached');

                    if(userGuess < correctAnswer) {
                        updateFeedback('Too low!');
                    }
                    else {
                        updateFeedback('Too high!');
                    }
                }
            }            
        });
    };

    // initialize the app
    initApp = function () {
        debug('initApp()');

        // initialize the constants
        MAX_TRIES = 5;
        LEVEL1_UPPER_LIMIT = 50;
        LEVEL2_UPPER_LIMIT = 100;
        LEVEL3_UPPER_LIMIT = 150;
        LEVEL4_UPPER_LIMIT = 200;
        DEFAULT_LOWER_LIMIT = 1;
        DEFAULT_UPPER_LIMIT = LEVEL1_UPPER_LIMIT;
        
        // initialize the app vars
        currentNumberOfTries = 0;
        currentLowerLimit = DEFAULT_LOWER_LIMIT;
        currentUpperLimit = DEFAULT_UPPER_LIMIT;
        correctAnswer = 0;
        userGuess = 0;

        wireEventHandlers();
        $('.tryAgain').hide();
    };

    // for random generation of numbers
    getRandomInt = function (min, max) {
        debug('getRandomInt(' + min + ', ' + max + ')');

        return Math.floor(Math.random() * (max - min + 1)) + min;
    };

    // dom ready
    $(function () {
        initApp();
    });

}).call(this, window.jQuery);
