﻿var db;

// This is what our customer data looks like.
var customerData = [
  { object: "Ponte levatoio", ppa: "Europa", action: "Rompere", difficult: "Maschera da scerma", mix: "Banda" },
  { object: "Bustina di te'", ppa: "Pesciolino Rosso", action: "Misurare", difficult: "Il sole bacia i capelli", mix: "Campo da football" },
  { object: "Baguette", ppa: "Sposo", action: "Sbucciare", difficult: "Fumare la pipa", mix: "Serra" },
  { object: "Luci natalizie", ppa: "Fenicottero", action: "Palleggiare", difficult: "Partita di calcio", mix: "Nazione" },
  { object: "Megafono", ppa: "Monte everest", action: "Spaventare", difficult: "Tirarsi su le maniche", mix: "Orto" },
  { object: "Grilletto", ppa: "Cavaliere", action: "Ripetere", difficult: "Acqua", mix: "Fianco" },
  { object: "Scala a pioli", ppa: "Negoziante", action: "Colorare", difficult: "Partire in quarta", mix: "Sfinge" },
  { object: "Molo", ppa: "Villaggio", action: "Fluttuare", difficult: "Fuoristrada", mix: "Classe" },
  { object: "Ponte", ppa: "Delfino", action: "Irrigare", difficult: "Bus a due piani", mix: "Principe" },
  { object: "Forbicine", ppa: "Chiesa", action: "Scavare", difficult: "Perle ai porci", mix: "Dollaro" },
  { object: "Ago", ppa: "Cyrano", action: "Spennare", difficult: "Piedi in testa", mix: "Festa" },
  { object: "Proiettore", ppa: "Cappuccetto rosso", action: "Unire", difficult: "Mettere le mani avanti", mix: "Gara" },
  { object: "Piscina gonfiabile", ppa: "Suora", action: "Accorciare", difficult: "Pollice verde", mix: "Fendinebbia" },
  { object: "Lattice", ppa: "Agnello", action: "Invertire", difficult: "Abito da sera", mix: "Indirizzo" },
  { object: "Stop", ppa: "Biancaneve", action: "Truccarsi", difficult: "Promessa da marinaio", mix: "Corona" },
  { object: "Salvadanaio", ppa: "Lady D", action: "Evidenziare", difficult: "Pozzo di scienza", mix: "Cintura" },
  { object: "Vulcano", ppa: "Parroco", action: "Votare", difficult: "Orecchie da mercante", mix: "Anello" },
  { object: "Palla da beach volley", ppa: "Foresta nera", action: "Chiamare", difficult: "Pelle d\'oca", mix: "Alluce" },
  { object: "Grondaia", ppa: "Agente immobiliare", action: "Colpire", difficult: "Quattro gatti", mix: "Sconfitta" },
  { object: "Croissant", ppa: "Capitan uncino", action: "Eruttare", difficult: "Contare le pecore", mix: "Guanto" },
  { object: "Dentifricio", ppa: "Cenerentola", action: "Raggiungere", difficult: "Ragazza della porta accanto", mix: "Terremoto" },
  { object: "Disco volante", ppa: "Portiere", action: "Spingere", difficult: "Romanzo giallo", mix: "Stivale" },
  { object: "Ombrello", ppa: "Saturno", action: "Incollare", difficult: "Aria condizionata", mix: "Pioggia" },
  { object: "Sentiero", ppa: "Poliziotto", action: "Scivolare", difficult: "Rompere il ghiaccio", mix: "Ananas" },
  { object: "Tetto", ppa: "Foca", action: "Pungere", difficult: "Rotto della cuffia", mix: "Luna" },
  
];

$(document).ready(function () {
    window.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
    window.IDBTransaction = window.IDBTransaction || window.webkitIDBTransaction || window.msIDBTransaction;
    window.IDBKeyRange = window.IDBKeyRange || window.webkitIDBKeyRange || window.msIDBKeyRange;

    var dbName = "the_name";

    var request = indexedDB.open(dbName, 13);

    request.onerror = function (event) {
        // Handle errors.
    };
    request.onsuccess = function (event) {
        db = event.target.result;
    }
    request.onupgradeneeded = function (event) {
        db = event.target.result;

        // Create an objectStore to hold information about our customers. We're
        // going to use "ssn" as our key path because it's guaranteed to be
        // unique.
        try {
            db.deleteObjectStore("customers");
        } catch (e) { }
        var objectStore = db.createObjectStore("customers", { autoIncrement: true });

        // Create an index to search customers by name. We may have duplicates
        // so we can't use a unique index.
        objectStore.createIndex("object", "object", { unique: false });
        objectStore.createIndex("ppa", "ppa", { unique: false });
        objectStore.createIndex("action", "action", { unique: false });
        // Create an index to search customers by email. We want to ensure that
        // no two customers have the same email, so use a unique index.
        objectStore.createIndex("difficult", "difficult", { unique: false });
        objectStore.createIndex("mix", "mix", { unique: false });

        // Use transaction oncomplete to make sure the objectStore creation is 
        // finished before adding data into it.
        objectStore.transaction.oncomplete = function (event) {
            // Store values in the newly created objectStore.
            var customerObjectStore = db.transaction("customers", "readwrite").objectStore("customers");
            for (var i in customerData) {
                customerObjectStore.add(customerData[i]);
            }

        }
    };

    function successCB() {
        var store = db.transaction("customers").objectStore("customers");
        var req;
        req = store.count();
        // Requests are executed in the order in which they were made against the
        // transaction, and their results are returned in the same order.
        // Thus the count text below will be displayed before the actual pub list
        // (not that it is algorithmically important in this case).
        var count;
        req.onsuccess = function (evt) {
            count = evt.target.result;
            var rand = Math.ceil(Math.random() * count);

            store.get(rand).onsuccess = function (event) {
                //alert(event.target.result.object);
                var word = Math.floor(Math.random() * 5);

                jQuery('#p-object').hide();
                jQuery('#p-ppa').hide();
                jQuery('#p-action').hide();
                jQuery('#p-difficult').hide();
                jQuery('#p-mix').hide();
                switch (word) {
                    case 0:
                        jQuery('#p-object').show();
                        jQuery('#p-object > span > span').html(event.target.result.object);
                        break;
                    case 1:
                        jQuery('#p-ppa').show();
                        jQuery('#p-ppa > span > span').html(event.target.result.ppa);
                        break;
                    case 2:
                        jQuery('#p-action').show();
                        jQuery('#p-action > span > span').html(event.target.result.action);
                        break;
                    case 3:
                        jQuery('#p-difficult').show();
                        jQuery('#p-difficult > span > span').html(event.target.result.difficult);
                        break;
                    case 4:
                        jQuery('#p-mix').show();
                        jQuery('#p-mix > span > span').html(event.target.result.mix);
                        break;
                    default:
                        console.log("Non dovrebbe succedere");
                }
            }
        };

    }
    $('#wordFooter a')[0].onclick = successCB;
});
