
function createPauseScreen(list) {
    //Crafty.audio.stop();

    if(list != undefined ){
        hideImages(list, false);    
    }
    
    var bg = Crafty.e("2D, Canvas, Image, Mouse").attr({x:0, y:0, w:480, h:280}).image("images/bg.png");

    var resumeHover = Crafty.e("2D, Canvas, Image, Mouse").image("images/resume1.png");
    resumeHover.x = bg._x+160; resumeHover.y = bg._y+50;
    
    var resumeBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/resume.png");
    resumeBtn.x = bg._x+160; resumeBtn.y = bg._y+50;
    
    var helpBtnHover = Crafty.e("2D, Canvas, Image, Mouse").image("images/help1.png");
    helpBtnHover.x = bg._x+200; helpBtnHover.y = bg._y+150;

    var helpBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/help.png");
    helpBtn.x = bg._x+200; helpBtn.y = bg._y+150;
    
    //    var soundTag = Crafty.e("2D, Canvas, Image, Mouse").image("images/sound.png");
//    soundTag.x = bg._x+150; soundTag.y = bg._y+100;

    var onBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/on1.png");
    onBtn.x = bg._x+150; onBtn.y = bg._y+100;
    onBtn.originX = onBtn._x;
    
    var offBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/off1.png");
    offBtn.x = bg._x+150; offBtn.y = bg._y+100;
    offBtn.originX = offBtn._x;

    
    var mainMenuHover = Crafty.e("2D, Canvas, Image, Mouse").image("images/mainmenu1.png");
    mainMenuHover.x = bg._x+160; mainMenuHover.y = bg._y+210;
   
    var mainMenuBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/mainmenu.png");
    mainMenuBtn.x = bg._x+160; mainMenuBtn.y = bg._y+210;

    
    if(getAudioIsMuted()) {
        offBtn.visible = true;
        onBtn.visible = false;
        onBtn.x = -1000;
    }
	else {
        offBtn.visible = false;
        onBtn.visible = true;
        offBtn.x = -1000;
    }
            
    offBtn.bind("MouseDown", function(e) {
        console.log("menu off btn clicked");
        setAudioIsMuted(false)
        onBtn.visible = true;
        offBtn.visible = false;
        offBtn.x = -1000;
        onBtn.x = onBtn.originX
        playBgMusic("BgmMenu")
        soundBtn = 1;
	});
    
    onBtn.bind("MouseDown", function(e) {
        console.log("menu on btn clicked");
        setAudioIsMuted(true)
        offBtn.visible = true;
        onBtn.visible = false;
        offBtn.x = offBtn.originX
        onBtn.x = -1000;
        Crafty.audio.stop();
        playSfxAudio("BtnClick");
        setBgMusicPlaying();
        soundBtn = 0;
    });
    
    

    bg.bind("MouseUp", function(e) { 
        helpBtn.alpha = 1;
        helpBtnHover.alpha = 0.01;
        resumeBtn.alpha = 1;
        resumeHover.alpha = 0.01;
        mainMenuBtn.alpha = 1;
        mainMenuHover.alpha = 0.01;
    });
    
 
    mainMenuBtn.bind("MouseDown", function(e) { 
        mainMenuBtn.alpha = 0.01;
        mainMenuHover.alpha = 1;
        playSfxAudio("BtnClick");
    });
    mainMenuBtn.bind("MouseUp", function(e) { 
        mainMenuBtn.alpha = 1;
        mainMenuHover.alpha = 0.01;
        createPromptScreen();
    });
    
	helpBtn.bind("MouseDown", function(e) { 
        helpBtn.alpha = 0.01;
        helpBtnHover.alpha = 1;
        playSfxAudio("BtnClick");
    });
    
    helpBtn.bind("MouseUp", function(e) { 
        helpBtn.alpha = 1;
        helpBtnHover.alpha = 0.01;
        createHelpScreen();
    });

    resumeBtn.bind("MouseDown", function(e) { 
        resumeBtn.alpha = 0.01;
        resumeHover.alpha = 1;
        playSfxAudio("BtnClick");
    });
    
    
    resumeBtn.bind("MouseUp", function(e) { 
        resumeBtn.alpha = 1;
        resumeHover.alpha = 0.01;
        deleteImages([bg,resumeBtn, resumeHover,  onBtn, offBtn, helpBtnHover, mainMenuHover, helpBtn, mainMenuBtn]);
        playBgMusic("GameMusic")
    });


    playBgMusic("BgmMenu")
}


